/*
 * Decompiled with CFR 0.152.
 */
package sernet.verinice.bpm.rcp;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;
import org.eclipse.swt.widgets.Display;
import sernet.gs.service.IThreadCompleteListener;
import sernet.gs.service.RuntimeCommandException;
import sernet.gs.ui.rcp.main.common.model.CnAElementFactory;
import sernet.gs.ui.rcp.main.common.model.IModelLoadListener;
import sernet.gs.ui.rcp.main.service.ServiceFactory;
import sernet.verinice.bpm.rcp.LoadTaskJob;
import sernet.verinice.bpm.rcp.Messages;
import sernet.verinice.bpm.rcp.RefreshTaskView;
import sernet.verinice.bpm.rcp.TaskView;
import sernet.verinice.interfaces.CommandException;
import sernet.verinice.interfaces.ICommand;
import sernet.verinice.interfaces.ICommandService;
import sernet.verinice.interfaces.bpm.ITaskParameter;
import sernet.verinice.interfaces.bpm.KeyMessage;
import sernet.verinice.iso27k.rcp.ComboModelObject;
import sernet.verinice.model.bp.elements.BpModel;
import sernet.verinice.model.bpm.TaskParameter;
import sernet.verinice.model.bsi.BSIModel;
import sernet.verinice.model.catalog.CatalogModel;
import sernet.verinice.model.common.CnATreeElement;
import sernet.verinice.model.common.configuration.Configuration;
import sernet.verinice.model.iso27k.ISO27KModel;
import sernet.verinice.service.commands.LoadCnAElementByEntityTypeId;
import sernet.verinice.service.commands.LoadVisibleAccounts;

public class TaskViewDataLoader {
    private static final Logger LOG = Logger.getLogger(TaskViewDataLoader.class);
    private TaskView taskView;
    private IModelLoadListener modelLoadListener;
    private LoadTaskJob job;
    private ExecutorService executer = Executors.newFixedThreadPool(1);
    private ICommandService commandService;
    private List<CnATreeElement> auditList;
    private List<CnATreeElement> filteredAuditList;

    public TaskViewDataLoader(TaskView taskView) {
        this.taskView = taskView;
        this.job = new LoadTaskJob();
        RefreshListener listener = new RefreshListener(this.job);
        this.job.addListener(listener);
    }

    void initData() {
        if (CnAElementFactory.isModelLoaded()) {
            this.loadGroups();
            this.loadAssignees();
            this.loadProcessTypes();
            this.loadTaskTypes();
            this.loadTasks();
        } else if (this.modelLoadListener == null) {
            this.modelLoadListener = new IModelLoadListener(){

                @Override
                public void closed(BSIModel model) {
                }

                @Override
                public void loaded(BSIModel model) {
                    Display.getDefault().syncExec(() -> TaskViewDataLoader.this.initData());
                }

                @Override
                public void loaded(ISO27KModel model) {
                }

                @Override
                public void loaded(BpModel model) {
                }

                @Override
                public void loaded(CatalogModel model) {
                }
            };
            CnAElementFactory.getInstance().addLoadListener(this.modelLoadListener);
        }
    }

    public void loadTasks() {
        TaskParameter param = new TaskParameter();
        param.setUsername(this.taskView.selectedAssignee);
        if (this.taskView.selectedAssignee != null) {
            param.setAllUser(false);
        } else {
            param.setAllUser(true);
        }
        if (this.taskView.selectedScope != null) {
            param.setAuditUuid(this.taskView.selectedScope.getUuid());
        }
        if (this.taskView.selectedAudit != null) {
            param.setAuditUuid(this.taskView.selectedAudit.getUuid());
        } else if (this.taskView.selectedScope != null && this.filteredAuditList != null && !this.filteredAuditList.isEmpty()) {
            param.setGroupIdList(this.getUuidList(this.filteredAuditList));
        }
        if (this.taskView.selectedProcessType != null) {
            param.setProcessKey(this.taskView.selectedProcessType.getKey());
        }
        if (this.taskView.selectedTaskType != null) {
            param.setTaskId(this.taskView.selectedTaskType.getKey());
        }
        if (this.taskView.dueDateFrom != null) {
            param.setDueDateFrom(this.taskView.dueDateFrom);
        }
        if (this.taskView.dueDateTo != null) {
            param.setDueDateTo(this.taskView.dueDateTo);
        }
        this.job.setParam((ITaskParameter)param);
        this.loadTasksInBackground(this.job);
        Display.getDefault().syncExec(() -> this.taskView.getInfoPanel().setText(""));
    }

    private List<String> getUuidList(List<CnATreeElement> auditList) {
        ArrayList<String> uuidList = new ArrayList<String>(auditList.size());
        for (CnATreeElement audit : auditList) {
            uuidList.add(audit.getUuid());
        }
        return uuidList;
    }

    private void loadTasksInBackground(LoadTaskJob job) {
        this.taskView.searchButton.setText(Messages.TaskView_19);
        this.taskView.searchButton.setEnabled(false);
        this.executer.execute((Runnable)((Object)job));
    }

    public void loadGroups() {
        try {
            this.taskView.comboModelScope.clear();
            LoadCnAElementByEntityTypeId command = new LoadCnAElementByEntityTypeId("org");
            command = (LoadCnAElementByEntityTypeId)this.taskView.getCommandService().executeCommand((ICommand)command);
            this.taskView.comboModelScope.addAll(command.getElements());
            command = new LoadCnAElementByEntityTypeId("it-verbund");
            command = (LoadCnAElementByEntityTypeId)this.taskView.getCommandService().executeCommand((ICommand)command);
            this.taskView.comboModelScope.addAll(command.getElements());
            command = new LoadCnAElementByEntityTypeId("bp_itnetwork");
            command = (LoadCnAElementByEntityTypeId)this.taskView.getCommandService().executeCommand((ICommand)command);
            this.taskView.comboModelScope.addAll(command.getElements());
            this.taskView.comboModelScope.sort((Comparator<ComboModelObject<CnATreeElement>>)((Object)TaskView.COMPARATOR_CNA_TREE_ELEMENT));
            this.taskView.comboModelScope.addNoSelectionObject(Messages.TaskView_21);
            TaskView.getDisplay().syncExec(() -> {
                this.taskView.comboScope.setItems(this.taskView.comboModelScope.getLabelArray());
                this.selectDefaultGroup();
            });
            this.loadAudits();
        }
        catch (CommandException e) {
            throw new RuntimeCommandException("Error while loading organizations, it-verbunds, IT networks or audits", (Throwable)e);
        }
    }

    public void loadAudits() {
        try {
            this.taskView.comboModelAudit.clear();
            LoadCnAElementByEntityTypeId command = new LoadCnAElementByEntityTypeId("audit");
            command = (LoadCnAElementByEntityTypeId)this.taskView.getCommandService().executeCommand((ICommand)command);
            this.auditList = command.getElements();
            this.filteredAuditList = this.filterAudits();
            this.taskView.comboModelAudit.addAll(this.filteredAuditList);
            this.taskView.comboModelAudit.sort((Comparator<ComboModelObject<CnATreeElement>>)((Object)TaskView.COMPARATOR_CNA_TREE_ELEMENT));
            if (this.filteredAuditList != null && !this.filteredAuditList.isEmpty()) {
                this.taskView.comboModelAudit.addNoSelectionObject(Messages.TaskView_21);
            } else {
                this.taskView.comboModelAudit.addNoSelectionObject(Messages.TaskViewDataLoader_0);
            }
            this.refreshAudits();
        }
        catch (CommandException e) {
            throw new RuntimeCommandException("Error while loading organizations, it-verbunds or audits", (Throwable)e);
        }
    }

    private List<CnATreeElement> filterAudits() {
        List<CnATreeElement> filteredList = this.auditList;
        if (this.taskView.selectedScope != null) {
            filteredList = new LinkedList<CnATreeElement>();
            for (CnATreeElement audit : this.auditList) {
                if (!this.taskView.selectedScope.getDbId().equals(audit.getScopeId())) continue;
                filteredList.add(audit);
            }
        }
        return filteredList;
    }

    private void refreshAudits() {
        TaskView.getDisplay().syncExec(() -> {
            this.taskView.comboAudit.setItems(this.taskView.comboModelAudit.getLabelArray());
            this.selectDefaultAudit();
        });
    }

    public void refreshScopes() {
        TaskView.getDisplay().syncExec(() -> {
            this.taskView.comboScope.setItems(this.taskView.comboModelScope.getLabelArray());
            this.selectDefaultGroup();
        });
    }

    private void selectDefaultGroup() {
        this.taskView.comboScope.select(0);
        this.taskView.comboModelScope.setSelectedIndex(this.taskView.comboScope.getSelectionIndex());
        this.taskView.selectedScope = this.taskView.comboModelScope.getSelectedObject();
    }

    private void selectDefaultAudit() {
        this.taskView.comboAudit.select(0);
        this.taskView.comboModelAudit.setSelectedIndex(this.taskView.comboAudit.getSelectionIndex());
        this.taskView.selectedAudit = this.taskView.comboModelAudit.getSelectedObject();
    }

    void loadAssignees() {
        this.taskView.comboModelAccount.clear();
        this.taskView.comboModelAccount.addAll(this.loadAccounts());
        this.taskView.comboModelAccount.sort((Comparator<ComboModelObject<Configuration>>)((Object)TaskView.COMPARATOR_CONFIGURATION));
        this.taskView.comboModelAccount.addNoSelectionObject(Messages.TaskView_20);
        TaskView.getDisplay().syncExec(() -> {
            this.taskView.comboAccount.setItems(this.taskView.comboModelAccount.getLabelArray());
            this.selectDefaultAssignee();
        });
    }

    private Collection<Configuration> loadAccounts() {
        try {
            if (this.taskView.isTaskShowAllEnabled()) {
                LoadVisibleAccounts command = new LoadVisibleAccounts();
                command = (LoadVisibleAccounts)this.getCommandService().executeCommand((ICommand)command);
                return command.getAccountList();
            }
            String currentUserName = ServiceFactory.lookupAuthService().getUsername();
            Configuration currentUserConfiguration = ServiceFactory.lookupAccountService().getAccountByName(currentUserName);
            return Arrays.asList(currentUserConfiguration);
        }
        catch (CommandException e) {
            LOG.error((Object)"Error while loading accounts.", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    private void selectDefaultAssignee() {
        String logedInUserName = ServiceFactory.lookupAuthService().getUsername();
        List<Configuration> allAccounts = this.taskView.comboModelAccount.getObjectList();
        for (Configuration account : allAccounts) {
            if (account == null || !logedInUserName.equals(account.getUser())) continue;
            this.taskView.comboModelAccount.setSelectedObject(account);
            this.taskView.comboAccount.select(this.taskView.comboModelAccount.getSelectedIndex());
            this.taskView.selectedAssignee = account.getUser();
        }
    }

    void loadProcessTypes() {
        this.taskView.comboModelProcessType.clear();
        Set processDefinitionSet = ServiceFactory.lookupIndividualService().findAllProcessDefinitions();
        this.taskView.comboModelProcessType.addAll(processDefinitionSet);
        this.taskView.comboModelProcessType.sort((Comparator<ComboModelObject<KeyMessage>>)((Object)TaskView.COMPARATOR_KEY_MESSAGE));
        this.taskView.comboModelProcessType.addNoSelectionObject(Messages.TaskView_23);
        TaskView.getDisplay().syncExec(() -> {
            this.taskView.comboProcessType.setItems(this.taskView.comboModelProcessType.getLabelArray());
            this.selectDefaultProcessType();
        });
    }

    private void selectDefaultProcessType() {
        this.taskView.comboProcessType.select(0);
        this.taskView.comboModelProcessType.setSelectedIndex(this.taskView.comboProcessType.getSelectionIndex());
        this.taskView.selectedProcessType = this.taskView.comboModelProcessType.getSelectedObject();
    }

    void loadTaskTypes() {
        TaskView.getDisplay().syncExec(() -> {
            this.taskView.comboTaskType.setItems(this.taskView.comboModelTaskType.getLabelArray());
            this.selectDefaultTaskType();
        });
    }

    private void selectDefaultTaskType() {
        this.taskView.comboTaskType.select(0);
        this.taskView.comboModelTaskType.setSelectedIndex(this.taskView.comboTaskType.getSelectionIndex());
        this.taskView.selectedTaskType = (KeyMessage)this.taskView.comboModelTaskType.getSelectedObject();
    }

    public void dispose() {
        CnAElementFactory.getInstance().removeLoadListener(this.modelLoadListener);
        this.job.removeAllListener();
        this.shutdownAndAwaitTermination(this.executer);
    }

    private void shutdownAndAwaitTermination(ExecutorService executer) {
        executer.shutdown();
        try {
            if (!executer.awaitTermination(30L, TimeUnit.SECONDS)) {
                executer.shutdownNow();
                if (!executer.awaitTermination(30L, TimeUnit.SECONDS)) {
                    LOG.error((Object)"Task loader (ExecutorService) shutdown failed.");
                }
            }
        }
        catch (InterruptedException ie) {
            executer.shutdownNow();
            Thread.currentThread().interrupt();
        }
    }

    public ICommandService getCommandService() {
        if (this.commandService == null) {
            this.commandService = ServiceFactory.lookupCommandService();
        }
        return this.commandService;
    }

    private final class RefreshListener
    implements IThreadCompleteListener {
        private final LoadTaskJob job;

        private RefreshListener(LoadTaskJob job) {
            this.job = job;
        }

        public void notifyOfThreadComplete(Thread thread) {
            RefreshTaskView refresh = new RefreshTaskView(this.job.getTaskList(), TaskViewDataLoader.this.taskView.getViewer());
            Display.getDefault().asyncExec(() -> {
                refresh.refresh();
                if (!TaskViewDataLoader.this.taskView.searchButton.isDisposed()) {
                    TaskViewDataLoader.this.taskView.searchButton.setText(Messages.TaskView_29);
                    TaskViewDataLoader.this.taskView.searchButton.setEnabled(true);
                }
            });
        }
    }
}

