/*
 * Decompiled with CFR 0.152.
 */
package sernet.verinice.bpm.rcp;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.LocationListener;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MenuDetectListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DateTime;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.IProgressService;
import sernet.gs.service.NumericStringComparator;
import sernet.gs.service.RetrieveInfo;
import sernet.gs.ui.rcp.main.Activator;
import sernet.gs.ui.rcp.main.ComboModelNumericStringComparator;
import sernet.gs.ui.rcp.main.ExceptionUtil;
import sernet.gs.ui.rcp.main.ImageCache;
import sernet.gs.ui.rcp.main.bsi.editors.BSIElementEditorInput;
import sernet.gs.ui.rcp.main.bsi.editors.EditorFactory;
import sernet.gs.ui.rcp.main.bsi.editors.TaskEditorContext;
import sernet.gs.ui.rcp.main.bsi.views.HtmlWriter;
import sernet.gs.ui.rcp.main.bsi.views.listeners.DisableContextMenuListener;
import sernet.gs.ui.rcp.main.bsi.views.listeners.WhiteListLocationListener;
import sernet.gs.ui.rcp.main.service.ServiceFactory;
import sernet.hui.common.VeriniceContext;
import sernet.springclient.RightsServiceClient;
import sernet.verinice.bpm.rcp.ComboModelTaskType;
import sernet.verinice.bpm.rcp.CompareChangedElementPropertiesAction;
import sernet.verinice.bpm.rcp.CompleteTaskAction;
import sernet.verinice.bpm.rcp.CompositeCreator;
import sernet.verinice.bpm.rcp.GroupLabelProvider;
import sernet.verinice.bpm.rcp.Messages;
import sernet.verinice.bpm.rcp.TableCollapseAndExpandListener;
import sernet.verinice.bpm.rcp.TaskChangeRegistry;
import sernet.verinice.bpm.rcp.TaskContentProvider;
import sernet.verinice.bpm.rcp.TaskLabelProvider;
import sernet.verinice.bpm.rcp.TaskSortSelectionAdapter;
import sernet.verinice.bpm.rcp.TaskTableComparator;
import sernet.verinice.bpm.rcp.TaskViewDataLoader;
import sernet.verinice.interfaces.ICommand;
import sernet.verinice.interfaces.ICommandService;
import sernet.verinice.interfaces.IInternalServerStartListener;
import sernet.verinice.interfaces.bpm.ITask;
import sernet.verinice.interfaces.bpm.ITaskListener;
import sernet.verinice.interfaces.bpm.KeyMessage;
import sernet.verinice.interfaces.bpm.KeyValue;
import sernet.verinice.iso27k.rcp.ComboModel;
import sernet.verinice.iso27k.rcp.RegexComboModelFilter;
import sernet.verinice.model.bpm.TaskInformation;
import sernet.verinice.model.common.CnATreeElement;
import sernet.verinice.model.common.PersonAdapter;
import sernet.verinice.model.common.configuration.Configuration;
import sernet.verinice.rcp.RightsEnabledView;
import sernet.verinice.rcp.TextEventAdapter;
import sernet.verinice.service.commands.LoadAncestors;

public class TaskView
extends RightsEnabledView {
    private static final Logger LOG = Logger.getLogger(TaskView.class);
    static final NumericStringComparator NSC = new NumericStringComparator();
    static final ComboModelNumericStringComparator<CnATreeElement> COMPARATOR_CNA_TREE_ELEMENT = new ComboModelNumericStringComparator();
    static final ComboModelNumericStringComparator<Configuration> COMPARATOR_CONFIGURATION = new ComboModelNumericStringComparator();
    static final ComboModelNumericStringComparator<KeyMessage> COMPARATOR_KEY_MESSAGE = new ComboModelNumericStringComparator();
    public static final String ID = "sernet.verinice.bpm.rcp.TaskView";
    private static final int WEIGHT_40 = 40;
    private static final int WEIGHT_60 = 60;
    private static final int COMBO_WIDTH = 140;
    private static final int WIDTH_SEARCH_FORM = 1060;
    private static final int HEIGHT_SEARCH_FORM = 60;
    CnATreeElement selectedScope;
    CnATreeElement selectedAudit;
    String selectedAssignee;
    KeyMessage selectedProcessType;
    KeyMessage selectedTaskType;
    private TableViewer tableViewer;
    private TaskTableComparator tableSorter = new TaskTableComparator();
    private TaskContentProvider contentProvider;
    private Listener collapseAndExpandListener = new TableCollapseAndExpandListener();
    private Browser textPanel;
    private Label labelDateFrom;
    private Label labelDateUntil;
    Date dueDateFrom = null;
    Date dueDateTo = null;
    Button searchButton;
    private TaskViewDataLoader dataLoader;
    ComboModel<CnATreeElement> comboModelScope;
    Combo comboScope;
    RegexComboModelFilter filterScope;
    ComboModel<CnATreeElement> comboModelAudit;
    Combo comboAudit;
    ComboModel<Configuration> comboModelAccount;
    Combo comboAccount;
    ComboModel<KeyMessage> comboModelProcessType;
    Combo comboProcessType;
    ComboModelTaskType comboModelTaskType;
    Combo comboTaskType;
    DateTime dateTimeFrom;
    Button disableDateButtonFrom;
    DateTime dateTimeUntil;
    Button disableDateButtonTo;
    private Action cancelTaskAction;
    private ICommandService commandService;
    private RightsServiceClient rightsService;
    private ITaskListener taskListener;
    private ActionContributionItem cancelToolbarItem;

    @Override
    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        if (Activator.getDefault().isStandalone()) {
            return;
        }
        try {
            this.dataLoader = new TaskViewDataLoader(this);
            this.initView(parent);
        }
        catch (Exception e) {
            LOG.error((Object)"Error while creating task view.", (Throwable)e);
            ExceptionUtil.log(e, Messages.TaskView_5);
        }
    }

    private void initView(Composite parent) {
        this.createRootComposite(parent);
        this.dataLoader.initData();
        this.makeActions();
        this.addToolBarActions();
        this.addListeners();
    }

    public void loadTasks() {
        this.dataLoader.loadTasks();
    }

    private void createRootComposite(Composite parent) {
        Composite rootComposite = CompositeCreator.create1ColumnComposite(parent);
        Composite topComposite = CompositeCreator.create2ColumnComposite(rootComposite);
        this.createSearchComposite(topComposite);
        SashForm splitComposite = CompositeCreator.createSplitComposite(rootComposite, 512);
        this.createInfoComposite((Composite)splitComposite);
        this.createTableComposite((Composite)splitComposite);
        splitComposite.setWeights(new int[]{40, 60});
    }

    private void createSearchComposite(Composite composite) {
        ScrolledComposite scrolledComposite = CompositeCreator.createScrolledComposite(composite);
        Composite formComposite = this.createSearchFormComposite((Composite)scrolledComposite);
        scrolledComposite.setContent((Control)formComposite);
        scrolledComposite.setVisible(true);
        scrolledComposite.setMinSize(1060, 60);
        this.createLoadButtonComposite(composite);
    }

    private void createLoadButtonComposite(Composite parent) {
        Composite buttonComposite = CompositeCreator.create1ColumnComposite(parent, false, true);
        new Label(buttonComposite, 64);
        this.createButtonControls(buttonComposite);
        buttonComposite.pack();
    }

    private Composite createSearchFormComposite(Composite parent) {
        Composite formComposite = TaskView.createInnerFormComposite(parent);
        Label label = new Label(formComposite, 64);
        label.setText(Messages.TaskView_11);
        this.setLayoutData(label, 50, false);
        label = new Label(formComposite, 64);
        label.setText("");
        this.setLayoutData(label, true);
        label = new Label(formComposite, 64);
        label.setText(Messages.TaskView_22);
        this.setLayoutData(label, true);
        label = new Label(formComposite, 64);
        label.setText(Messages.TaskView_12);
        this.setLayoutData(label, true);
        label = new Label(formComposite, 64);
        label.setText(Messages.TaskView_13);
        this.setLayoutData(label, true);
        label = new Label(formComposite, 64);
        label.setText(Messages.TaskView_14);
        this.setLayoutData(label, false);
        this.labelDateFrom = new Label(formComposite, 64);
        this.labelDateFrom.setText(Messages.TaskView_18);
        this.labelDateUntil = new Label(formComposite, 64);
        this.labelDateUntil.setText(Messages.TaskView_1);
        this.createGroupControls(formComposite);
        this.createAssigneeControls(formComposite);
        this.createProcessTypeControls(formComposite);
        this.createTaskTypeControls(formComposite);
        this.createDateFromControls(formComposite);
        this.createDateToControls(formComposite);
        return formComposite;
    }

    private void setLayoutData(Label label, boolean grabExcessHorizontalSpace) {
        this.setLayoutData(label, 140, grabExcessHorizontalSpace);
    }

    private void setLayoutData(Label label, int minimumWidth, boolean grabExcessHorizontalSpace) {
        GridData gridData = new GridData();
        gridData.minimumWidth = minimumWidth;
        gridData.grabExcessHorizontalSpace = grabExcessHorizontalSpace;
        label.setLayoutData((Object)gridData);
    }

    public static Composite createInnerFormComposite(Composite parentComposite) {
        Composite composite = new Composite(parentComposite, 0);
        GridData gridData = new GridData(4, 0, true, false);
        composite.setLayoutData((Object)gridData);
        GridLayout gridLayout = new GridLayout(8, false);
        gridLayout.marginHeight = 4;
        gridLayout.marginWidth = 4;
        composite.setLayout((Layout)gridLayout);
        return composite;
    }

    private void createTableComposite(Composite parent) {
        this.tableViewer = new TableViewer(parent, 68354);
        GridData gridData = new GridData(4, 4, true, true);
        this.tableViewer.getControl().setLayoutData((Object)gridData);
        this.tableViewer.setUseHashlookup(true);
        this.getTable().setHeaderVisible(true);
        this.getTable().setLinesVisible(true);
        this.createTableColumn(null, 0);
        this.createTableColumn(Messages.TaskView_9, 1);
        this.createTableColumn(Messages.TaskView_10, 2);
        this.createTableColumn(Messages.TaskView_4, 3);
        this.createTableColumn(Messages.TaskViewColumn_1, 4);
        this.createTableColumn(Messages.TaskViewColumn_2, 5);
        this.createTableColumn(Messages.TaskViewColumn_3, 6);
        TableLayout layout = new TableLayout();
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(22, 22, false));
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(192, 192, true));
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(350, 350, true));
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(130, 130, true));
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(110, 110, true));
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(120, 120, true));
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(76, 76, true));
        this.getTable().setLayout((Layout)layout);
        TableColumn[] tableColumnArray = this.getTable().getColumns();
        int n = tableColumnArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableColumn tc = tableColumnArray[n2];
            tc.pack();
            ++n2;
        }
        this.getTable().addListener(17, this.collapseAndExpandListener);
        this.getTable().addListener(18, this.collapseAndExpandListener);
        this.contentProvider = new TaskContentProvider(this.tableViewer);
        this.tableViewer.setContentProvider((IContentProvider)this.contentProvider);
        TaskLabelProvider labelProvider = new TaskLabelProvider();
        this.tableViewer.setLabelProvider((IBaseLabelProvider)labelProvider);
        this.tableViewer.setComparator((ViewerComparator)this.tableSorter);
    }

    private void createInfoComposite(Composite container) {
        int gridDataHeight = 80;
        this.textPanel = new Browser(container, 0);
        this.textPanel.setJavascriptEnabled(false);
        this.textPanel.addMenuDetectListener((MenuDetectListener)new DisableContextMenuListener());
        this.textPanel.addLocationListener((LocationListener)WhiteListLocationListener.DEFAULT);
        this.textPanel.setLayoutData((Object)new GridData(768));
        GridData gridData = new GridData(4, 4, true, true);
        gridData.heightHint = 80;
        this.textPanel.setLayoutData((Object)gridData);
    }

    private void createGroupControls(Composite searchComposite) {
        final Text textFilterScope = new Text(searchComposite, 2048);
        textFilterScope.setToolTipText(Messages.TaskView_26);
        textFilterScope.addKeyListener((KeyListener)new TextEventAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                TaskView.this.filterScope.setFilter(textFilterScope.getText());
                TaskView.this.dataLoader.refreshScopes();
                TaskView.this.dataLoader.loadAudits();
            }
        });
        this.comboModelScope = new ComboModel<CnATreeElement>(new GroupLabelProvider());
        this.filterScope = new RegexComboModelFilter();
        this.comboModelScope.setFilter(this.filterScope);
        this.comboScope = this.createComboBox(searchComposite);
        this.comboScope.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TaskView.this.comboModelScope.setSelectedIndex(TaskView.this.comboScope.getSelectionIndex());
                TaskView.this.selectedScope = TaskView.this.comboModelScope.getSelectedObject();
                TaskView.this.selectedAudit = null;
                TaskView.this.dataLoader.loadAudits();
            }
        });
        this.comboModelAudit = new ComboModel<CnATreeElement>(new GroupLabelProvider());
        this.comboAudit = this.createComboBox(searchComposite);
        this.comboAudit.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TaskView.this.comboModelAudit.setSelectedIndex(TaskView.this.comboAudit.getSelectionIndex());
                TaskView.this.selectedAudit = TaskView.this.comboModelAudit.getSelectedObject();
            }
        });
    }

    private void createAssigneeControls(Composite searchComposite) {
        this.comboModelAccount = new ComboModel<Configuration>(account -> {
            String fullName = PersonAdapter.getFullName((CnATreeElement)account.getPerson());
            String user = account.getUser();
            return StringUtils.join((Object[])new Object[]{fullName, " [", user, "]"});
        });
        this.comboAccount = this.createComboBox(searchComposite);
        this.comboAccount.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TaskView.this.comboModelAccount.setSelectedIndex(TaskView.this.comboAccount.getSelectionIndex());
                Configuration account = TaskView.this.comboModelAccount.getSelectedObject();
                TaskView.this.selectedAssignee = account != null ? account.getUser() : null;
            }
        });
    }

    private void createProcessTypeControls(Composite searchComposite) {
        this.comboModelProcessType = new ComboModel<KeyMessage>(KeyValue::getValue);
        this.comboProcessType = this.createComboBox(searchComposite);
        this.comboProcessType.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TaskView.this.comboModelProcessType.setSelectedIndex(TaskView.this.comboProcessType.getSelectionIndex());
                TaskView.this.selectedProcessType = TaskView.this.comboModelProcessType.getSelectedObject();
            }
        });
    }

    private void createTaskTypeControls(Composite searchComposite) {
        this.comboModelTaskType = new ComboModelTaskType();
        this.comboTaskType = this.createComboBox(searchComposite);
        this.comboTaskType.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TaskView.this.comboModelTaskType.setSelectedIndex(TaskView.this.comboTaskType.getSelectionIndex());
                TaskView.this.selectedTaskType = (KeyMessage)TaskView.this.comboModelTaskType.getSelectedObject();
            }
        });
    }

    private void createDateFromControls(Composite searchComposite) {
        GridData gridData = new GridData(16384, 16384, false, false);
        Composite dateFromComposite = CompositeCreator.create2ColumnComposite(searchComposite, gridData);
        this.dateTimeFrom = new DateTime(dateFromComposite, 36);
        this.dateTimeFrom.setEnabled(false);
        this.labelDateFrom.setEnabled(false);
        this.dateTimeFrom.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TaskView.this.dueDateFrom = TaskView.this.extractDateFrom(TaskView.this.dateTimeFrom);
                TaskView.this.dueDateTo = TaskView.this.extractDateTo(TaskView.this.dateTimeFrom);
            }
        });
        this.disableDateButtonFrom = new Button(dateFromComposite, 32);
        this.disableDateButtonFrom.setSelection(false);
        this.disableDateButtonFrom.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TaskView.this.dateTimeFrom.setEnabled(!TaskView.this.dateTimeFrom.isEnabled());
                TaskView.this.labelDateFrom.setEnabled(TaskView.this.dateTimeFrom.isEnabled());
                TaskView.this.disableDateButtonFrom.setSelection(TaskView.this.dateTimeFrom.isEnabled());
                TaskView.this.setDuedateFromLabel();
                TaskView.this.extractDates();
            }
        });
        dateFromComposite.pack();
    }

    private void createDateToControls(Composite searchComposite) {
        GridData gridData = new GridData(16384, 16384, false, false);
        Composite dateToComposite = CompositeCreator.create2ColumnComposite(searchComposite, gridData);
        this.dateTimeUntil = new DateTime(dateToComposite, 36);
        this.dateTimeUntil.setEnabled(false);
        this.labelDateUntil.setEnabled(false);
        this.dateTimeUntil.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TaskView.this.dueDateTo = TaskView.this.extractDateTo(TaskView.this.dateTimeUntil);
            }
        });
        this.disableDateButtonTo = new Button(dateToComposite, 32);
        this.disableDateButtonTo.setSelection(false);
        this.disableDateButtonTo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TaskView.this.dateTimeUntil.setEnabled(!TaskView.this.dateTimeUntil.isEnabled());
                TaskView.this.labelDateUntil.setEnabled(TaskView.this.dateTimeUntil.isEnabled());
                TaskView.this.disableDateButtonTo.setSelection(TaskView.this.dateTimeUntil.isEnabled());
                TaskView.this.setDuedateFromLabel();
                TaskView.this.extractDates();
            }
        });
        dateToComposite.pack();
    }

    private void setDuedateFromLabel() {
        if (this.disableDateButtonTo.getSelection()) {
            this.labelDateFrom.setText(Messages.TaskView_18);
        } else {
            this.labelDateFrom.setText(Messages.TaskView_16);
        }
    }

    private void extractDates() {
        if (!this.dateTimeFrom.isEnabled()) {
            this.dueDateFrom = null;
            this.dueDateTo = null;
        } else {
            this.dueDateFrom = this.extractDateFrom(this.dateTimeFrom);
            this.dueDateTo = !this.dateTimeUntil.isEnabled() ? this.extractDateTo(this.dateTimeFrom) : this.extractDateTo(this.dateTimeUntil);
        }
    }

    private void createButtonControls(Composite searchComposite) {
        this.searchButton = new Button(searchComposite, 0);
        this.searchButton.setText(Messages.TaskView_17);
        this.searchButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TaskView.this.dataLoader.loadTasks();
            }
        });
    }

    private Date extractDateFrom(DateTime dueDate) {
        Calendar cal = this.getDateWithoutTime(dueDate);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        return cal.getTime();
    }

    private Date extractDateTo(DateTime dueDate) {
        Calendar cal = this.getDateWithoutTime(dueDate);
        cal.set(11, 23);
        cal.set(12, 59);
        cal.set(13, 59);
        return cal.getTime();
    }

    private Calendar getDateWithoutTime(DateTime dueDate) {
        Calendar cal = Calendar.getInstance();
        cal.set(1, dueDate.getYear());
        cal.set(2, dueDate.getMonth());
        cal.set(5, dueDate.getDay());
        return cal;
    }

    private void makeActions() {
        this.cancelTaskAction = this.createCancelTaskAction();
        if (Activator.getDefault().isStandalone() && !Activator.getDefault().getInternalServer().isRunning()) {
            IInternalServerStartListener listener = e -> {
                if (e.isStarted()) {
                    this.configureActions();
                }
            };
            Activator.getDefault().getInternalServer().addInternalServerStatusListener(listener);
        } else {
            this.configureActions();
        }
    }

    private Action createCancelTaskAction() {
        Action action = new Action(Messages.ButtonCancel, 2){

            public void run() {
                try {
                    TaskView.this.cancelTask();
                    this.setChecked(false);
                }
                catch (Exception e) {
                    LOG.error((Object)"Error while canceling task.", (Throwable)e);
                    TaskView.this.showError(Messages.TaskView_6, Messages.TaskView_7);
                }
            }
        };
        action.setEnabled(false);
        action.setImageDescriptor(ImageCache.getInstance().getImageDescriptor("16-em-cross.png"));
        return action;
    }

    private void configureActions() {
        Display.getDefault().asyncExec(() -> {
            this.cancelTaskAction.setEnabled(this.getRightsService().isEnabled("taskdelete"));
            this.comboAccount.setEnabled(this.isTaskShowAllEnabled());
        });
    }

    boolean isTaskShowAllEnabled() {
        return this.getRightsService().isEnabled("taskshowall");
    }

    private void addToolBarActions() {
        IActionBars bars = this.getViewSite().getActionBars();
        IToolBarManager manager = bars.getToolBarManager();
        Action dummyAction = new Action(){};
        dummyAction.setText(" ");
        dummyAction.setEnabled(false);
        ActionContributionItem item = new ActionContributionItem((IAction)dummyAction);
        item.setMode(ActionContributionItem.MODE_FORCE_TEXT);
        manager.add((IContributionItem)item);
        this.cancelToolbarItem = new ActionContributionItem((IAction)this.cancelTaskAction);
        this.cancelToolbarItem.setVisible(false);
        manager.add((IContributionItem)this.cancelToolbarItem);
    }

    private void addListeners() {
        this.taskListener = new ITaskListener(){

            public void newTasks(List<ITask> taskList) {
                TaskView.this.addTasks(taskList);
            }

            public void newTasks() {
                Display.getDefault().syncExec(() -> TaskView.this.dataLoader.loadTasks());
            }
        };
        TaskChangeRegistry.addTaskChangeListener(this.taskListener);
        this.tableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (this.isTaskSelected()) {
                    try {
                        TaskView.this.selectTask();
                        TaskView.this.cancelToolbarItem.setVisible(true);
                    }
                    catch (Exception t) {
                        LOG.error((Object)"Error while configuring task actions.", (Throwable)t);
                    }
                } else {
                    TaskView.this.resetToolbar();
                    TaskView.this.cancelToolbarItem.setVisible(false);
                    TaskView.this.getInfoPanel().setText("");
                }
                TaskView.this.getViewSite().getActionBars().updateActionBars();
            }

            private boolean isTaskSelected() {
                return TaskView.this.getViewer().getSelection() instanceof IStructuredSelection && ((IStructuredSelection)TaskView.this.getViewer().getSelection()).getFirstElement() instanceof TaskInformation;
            }
        });
        this.addTaskDoubleClickListener();
        MenuManager menuManager = new MenuManager();
        Menu menu = menuManager.createContextMenu((Control)this.tableViewer.getTable());
        this.tableViewer.getTable().setMenu(menu);
        this.getSite().registerContextMenu(menuManager, (ISelectionProvider)this.tableViewer);
        this.getSite().setSelectionProvider((ISelectionProvider)this.tableViewer);
    }

    private void addTaskDoubleClickListener() {
        this.tableViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                ISelection selection = event.getSelection();
                if (selection instanceof IStructuredSelection && ((IStructuredSelection)selection).getFirstElement() instanceof TaskInformation) {
                    TaskInformation task = (TaskInformation)((IStructuredSelection)selection).getFirstElement();
                    this.openTask(task);
                }
            }

            private void openTask(TaskInformation task) {
                try {
                    RetrieveInfo ri = RetrieveInfo.getPropertyInstance();
                    LoadAncestors loadControl = new LoadAncestors(task.getElementType(), task.getUuid(), ri);
                    loadControl = (LoadAncestors)TaskView.this.getCommandService().executeCommand((ICommand)loadControl);
                    CnATreeElement element = loadControl.getElement();
                    if (element == null) {
                        TaskView.this.showError("Error", Messages.TaskView_25);
                    }
                    if (task.isWithAReleaseProcess()) {
                        ITask reloadedTask = ServiceFactory.lookupTaskService().findTask(task.getId());
                        if (reloadedTask == null) {
                            TaskView.this.loadTasks();
                            TaskView.this.showError(Messages.TaskView_6, Messages.TaskView_Task_List_Refreshed);
                            return;
                        }
                        TaskEditorContext editorContext = new TaskEditorContext(task, element);
                        EditorFactory.getInstance().updateAndOpenObject(editorContext);
                    } else {
                        EditorFactory.getInstance().updateAndOpenObject(element);
                    }
                }
                catch (Exception t) {
                    LOG.error((Object)"Error while opening control.", (Throwable)t);
                }
            }
        });
    }

    public void dispose() {
        TaskChangeRegistry.removeTaskChangeListener(this.taskListener);
        this.dataLoader.dispose();
        this.contentProvider.dispose();
        super.dispose();
    }

    private void selectTask() {
        IToolBarManager manager = this.resetToolbar();
        this.cancelTaskAction.setEnabled(false);
        this.cancelTaskAction.setEnabled(this.getRightsService().isEnabled("taskdelete"));
        TaskInformation task = (TaskInformation)((IStructuredSelection)this.getViewer().getSelection()).getFirstElement();
        this.getInfoPanel().setText(HtmlWriter.getPage(task.getDescription()));
        if (task.isWithAReleaseProcess()) {
            CompareChangedElementPropertiesAction compareChangesAction = new CompareChangedElementPropertiesAction(this, (ITask)task);
            compareChangesAction.setText(Messages.CompareTaskChangesAction_0);
            compareChangesAction.setImageDescriptor(ImageCache.getInstance().getImageDescriptor("history_rep.gif"));
            ActionContributionItem item = new ActionContributionItem((IAction)compareChangesAction);
            manager.add((IContributionItem)item);
        }
        List outcomeList = task.getOutcomes();
        for (KeyValue keyValue : outcomeList) {
            CompleteTaskAction completeAction = new CompleteTaskAction(this, keyValue.getKey());
            completeAction.setText(keyValue.getValue());
            completeAction.setImageDescriptor(ImageCache.getInstance().getImageDescriptor("16-em-check.png"));
            ActionContributionItem item = new ActionContributionItem((IAction)completeAction);
            item.setMode(ActionContributionItem.MODE_FORCE_TEXT);
            manager.add((IContributionItem)item);
        }
    }

    private IToolBarManager resetToolbar() {
        IToolBarManager manager = this.getViewSite().getActionBars().getToolBarManager();
        IContributionItem[] items = manager.getItems();
        int i = 2;
        while (i < items.length) {
            IContributionItem item = items[i];
            manager.remove(item);
            item.dispose();
            ++i;
        }
        return manager;
    }

    protected void addTasks(List<ITask> taskList) {
        List<Object> newList = taskList == null || taskList.isEmpty() ? new LinkedList() : taskList;
        List currentTaskList = (List)this.getViewer().getInput();
        if (currentTaskList != null) {
            for (ITask task : currentTaskList) {
                if (newList.contains(task)) continue;
                newList.add(task);
            }
        }
        Display.getDefault().syncExec(() -> this.getViewer().setInput((Object)newList));
    }

    private void cancelTask() throws InvocationTargetException, InterruptedException {
        IProgressService progressService = PlatformUI.getWorkbench().getProgressService();
        final List<TaskInformation> taskList = this.getSelectedTasks();
        if (!taskList.isEmpty() && MessageDialog.openConfirm((Shell)TaskView.getShell(), (String)Messages.ConfirmTaskDelete_0, (String)Messages.bind((String)Messages.ConfirmTaskDelete_1, (Object)taskList.size()))) {
            this.closeEditors(taskList);
            progressService.run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    Activator.inheritVeriniceContextState();
                    for (TaskInformation task : taskList) {
                        ServiceFactory.lookupTaskService().cancelTask(task.getId());
                        TaskView.this.contentProvider.removeTask((ITask)task);
                    }
                }
            });
            this.getInfoPanel().setText("");
        }
    }

    protected List<TaskInformation> getSelectedTasks() {
        StructuredSelection selection = (StructuredSelection)this.getViewer().getSelection();
        ArrayList<TaskInformation> taskList = new ArrayList<TaskInformation>(selection.size());
        for (Object sel : selection) {
            if (!(sel instanceof TaskInformation)) continue;
            taskList.add((TaskInformation)sel);
        }
        return taskList;
    }

    public void removeTask(ITask task) {
        this.contentProvider.removeTask(task);
    }

    public void closeEditorForElement(String uuid) {
        IEditorReference[] iEditorReferenceArray = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getEditorReferences();
        int n = iEditorReferenceArray.length;
        int n2 = 0;
        while (n2 < n) {
            IEditorReference editorReference = iEditorReferenceArray[n2];
            try {
                CnATreeElement element = ((BSIElementEditorInput)editorReference.getEditorInput()).getCnAElement();
                IWorkbenchPage activePage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                if (editorReference.getEditorInput() instanceof BSIElementEditorInput && uuid.equals(element.getUuid())) {
                    activePage.closeEditors(new IEditorReference[]{editorReference}, true);
                    break;
                }
            }
            catch (PartInitException e) {
                LOG.error((Object)"Error while closing element editor.", (Throwable)e);
            }
            ++n2;
        }
    }

    private void closeEditors(List<TaskInformation> taskList) {
        for (TaskInformation taskInformation : taskList) {
            this.closeEditorForElement(taskInformation.getUuid());
        }
    }

    private Combo createComboBox(Composite composite) {
        Combo combo = new Combo(composite, 12);
        combo.setLayoutData((Object)new GridData(768));
        return combo;
    }

    private void createTableColumn(String label, int columnIndex) {
        TableColumn column = new TableColumn(this.getTable(), 16384);
        if (label != null) {
            column.setText(label);
        }
        column.addSelectionListener((SelectionListener)new TaskSortSelectionAdapter(this, column, columnIndex));
    }

    protected TableViewer getViewer() {
        return this.tableViewer;
    }

    protected TaskTableComparator getTableSorter() {
        return this.tableSorter;
    }

    Browser getInfoPanel() {
        return this.textPanel;
    }

    private Table getTable() {
        return this.tableViewer.getTable();
    }

    protected void showError(String title, String message) {
        Display.getDefault().syncExec(() -> MessageDialog.openError((Shell)TaskView.getShell(), (String)title, (String)message));
    }

    static Display getDisplay() {
        Display display = Display.getCurrent();
        if (display == null) {
            display = Display.getDefault();
        }
        return display;
    }

    private static Shell getShell() {
        return TaskView.getDisplay().getActiveShell();
    }

    public ICommandService getCommandService() {
        if (this.commandService == null) {
            this.commandService = ServiceFactory.lookupCommandService();
        }
        return this.commandService;
    }

    public RightsServiceClient getRightsService() {
        if (this.rightsService == null) {
            this.rightsService = (RightsServiceClient)VeriniceContext.get((String)"rightsService");
        }
        return this.rightsService;
    }

    @Override
    public void setFocus() {
    }

    @Override
    public String getRightID() {
        return "taskview";
    }

    @Override
    public String getViewId() {
        return ID;
    }
}

