/*
 * Decompiled with CFR 0.152.
 */
package sernet.verinice.bpm.rcp;

import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import sernet.verinice.interfaces.bpm.ITask;
import sernet.verinice.interfaces.bpm.KeyValue;

public class TaskTreeModel {
    List<ITask> taskList;
    Map<KeyValue, List<ITask>> nodeMap;

    public TaskTreeModel(List<ITask> taskList) {
        this.taskList = taskList;
        this.init();
    }

    private void init() {
        this.nodeMap = new HashMap<KeyValue, List<ITask>>();
        for (ITask task : this.taskList) {
            KeyValue keyValue = new KeyValue(task.getUuidGroup(), task.getGroupTitle());
            List<ITask> taskList = this.nodeMap.get(keyValue);
            if (taskList == null) {
                taskList = new LinkedList<ITask>();
                this.nodeMap.put(keyValue, taskList);
            }
            taskList.add(task);
        }
    }

    public Object[] getRootElementArray() {
        Object[] result = this.getRootElementSet().toArray();
        Arrays.sort(result);
        return result;
    }

    public Set<KeyValue> getRootElementSet() {
        return this.nodeMap.keySet();
    }

    public List<ITask> getChildren(KeyValue parent) {
        return this.nodeMap.get(parent);
    }

    public Object[] getChildrenArray(KeyValue parent) {
        List<ITask> children = this.nodeMap.get(parent);
        Object[] taskArray = null;
        taskArray = children == null ? new ITask[]{} : children.toArray();
        return taskArray;
    }

    public void remove(ITask task) {
        this.taskList.remove(task);
        KeyValue keyValue = new KeyValue(task.getUuidGroup(), task.getGroupTitle());
        List<ITask> nodeChildren = this.nodeMap.get(keyValue);
        if (nodeChildren != null) {
            nodeChildren.remove(task);
            if (nodeChildren.isEmpty()) {
                this.nodeMap.remove(keyValue);
            }
        }
    }
}

