/*
 * Decompiled with CFR 0.152.
 */
package sernet.verinice.bpm.rcp;

import java.util.Date;
import org.apache.log4j.Logger;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import sernet.gs.service.NumericStringComparator;
import sernet.verinice.interfaces.bpm.ITask;

class TaskTableComparator
extends ViewerComparator {
    private static final Logger LOG = Logger.getLogger(TaskTableComparator.class);
    private int propertyIndex = 0;
    private static final int DEFAULT_SORT_COLUMN = 0;
    private static final int DESCENDING = 1;
    private static final int ASCENDING = 0;
    private int direction = 0;
    private static final NumericStringComparator NSC = new NumericStringComparator();

    public void setColumn(int column) {
        if (column == this.propertyIndex) {
            this.direction = this.direction == 0 ? 1 : 0;
        } else {
            this.propertyIndex = column;
            this.direction = 0;
        }
    }

    public int compare(Viewer viewer, Object e1, Object e2) {
        int rc = 0;
        if (e1 == null && e2 != null) {
            rc = 1;
        } else if (e2 == null && e1 != null) {
            rc = -1;
        } else {
            ITask a1 = (ITask)e1;
            ITask a2 = (ITask)e2;
            rc = this.compareNullSafe(a1, a2);
        }
        if (this.direction == 1) {
            rc = -rc;
        }
        return rc;
    }

    private int compareNullSafe(ITask a1, ITask a2) {
        int rc = 0;
        switch (this.propertyIndex) {
            case 0: {
                rc = NSC.compare((Object)a1.getPriority(), (Object)a2.getPriority());
                break;
            }
            case 1: {
                rc = NSC.compare((Object)a1.getGroupTitle(), (Object)a2.getGroupTitle());
                break;
            }
            case 2: {
                rc = NSC.compare((Object)a1.getElementTitle(), (Object)a2.getElementTitle());
                break;
            }
            case 3: {
                rc = this.compareStringNullSave(a1.getProcessName(), a2.getProcessName());
                break;
            }
            case 4: {
                rc = this.compareStringNullSave(a1.getName(), a2.getName());
                break;
            }
            case 5: {
                rc = this.compareStringNullSave(a1.getAssignee(), a2.getAssignee());
                break;
            }
            case 6: {
                rc = this.compareDateNullSave(a1.getDueDate(), a2.getDueDate());
                break;
            }
            default: {
                rc = 0;
            }
        }
        return rc;
    }

    private int compareStringNullSave(String s1, String s2) {
        if (s1 == null) {
            if (s2 == null) {
                return 0;
            }
            return 1;
        }
        int result = s1.compareToIgnoreCase(s2);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)(String.valueOf(result) + " " + s1 + " - " + s2 + " (compare result)"));
        }
        return result;
    }

    private int compareDateNullSave(Date d1, Date d2) {
        if (d1 == null) {
            if (d2 == null) {
                return 0;
            }
            return 1;
        }
        return d1.compareTo(d2);
    }
}

