/*
 * Decompiled with CFR 0.152.
 */
package sernet.verinice.bpm.rcp;

import java.text.DateFormat;
import java.util.Hashtable;
import java.util.Map;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.swt.graphics.Image;
import sernet.gs.ui.rcp.main.ImageCache;
import sernet.gs.ui.rcp.main.common.model.PlaceHolder;
import sernet.gs.ui.rcp.main.service.ServiceFactory;
import sernet.verinice.interfaces.IAuthService;
import sernet.verinice.interfaces.bpm.ITask;

public class TaskLabelProvider
implements ITableLabelProvider {
    private static final Map<String, String> PRIO_IMAGE_MAP = new Hashtable<String, String>();

    static {
        PRIO_IMAGE_MAP.put("LOW", "priority-4.gif");
        PRIO_IMAGE_MAP.put("NORMAL", "priority-2.gif");
        PRIO_IMAGE_MAP.put("HIGH", "priority-1.gif");
    }

    public Image getColumnImage(Object element, int columnIndex) {
        Image image = null;
        if (element instanceof ITask) {
            ITask task = (ITask)element;
            switch (columnIndex) {
                case 0: {
                    image = ImageCache.getInstance().getImage(PRIO_IMAGE_MAP.get(task.getPriority()));
                    break;
                }
            }
        }
        return image;
    }

    public String getColumnText(Object element, int columnIndex) {
        int maxColumnTextLength = 100;
        String text = null;
        if (element instanceof ITask) {
            ITask task = (ITask)element;
            text = this.getColumnText(columnIndex, task);
        }
        if (element instanceof PlaceHolder) {
            PlaceHolder placeHolder = (PlaceHolder)element;
            text = this.getColumnText(columnIndex, placeHolder);
        }
        if (text != null && text.length() > 100) {
            text = String.valueOf(text.substring(0, 99)) + "...";
        }
        return text;
    }

    private String getColumnText(int columnIndex, ITask task) {
        String text = null;
        switch (columnIndex) {
            case 1: {
                text = task.getGroupTitle();
                break;
            }
            case 2: {
                text = task.getElementTitle();
                break;
            }
            case 3: {
                text = task.getProcessName();
                break;
            }
            case 4: {
                text = task.getName();
                break;
            }
            case 5: {
                IAuthService authService = ServiceFactory.lookupAuthService();
                text = task.getAssignee();
                if (text == null || !text.equals(authService.getUsername())) break;
                text = String.valueOf(text) + " (you)";
                break;
            }
            case 6: {
                if (task.getDueDate() == null) break;
                text = DateFormat.getDateInstance().format(task.getDueDate());
                break;
            }
        }
        return text;
    }

    private String getColumnText(int columnIndex, PlaceHolder placeHolder) {
        String text = null;
        switch (columnIndex) {
            case 2: {
                text = placeHolder.getTitle();
                break;
            }
        }
        return text;
    }

    public void addListener(ILabelProviderListener listener) {
    }

    public void dispose() {
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
    }
}

