/*
 * Decompiled with CFR 0.152.
 */
package sernet.verinice.bpm.rcp;

import java.util.LinkedList;
import java.util.List;
import sernet.verinice.interfaces.bpm.ITask;
import sernet.verinice.interfaces.bpm.ITaskListener;

public abstract class TaskChangeRegistry {
    private static List<ITaskListener> taskChangeListeners;

    public static void addTaskChangeListener(ITaskListener listener) {
        TaskChangeRegistry.getTaskChangeListeners().add(listener);
    }

    public static void removeTaskChangeListener(ITaskListener listener) {
        TaskChangeRegistry.getTaskChangeListeners().remove(listener);
    }

    public static void tasksAdded() {
        for (ITaskListener listener : TaskChangeRegistry.getTaskChangeListeners()) {
            listener.newTasks();
        }
    }

    public static void tasksAdded(List<ITask> newTasks) {
        for (ITaskListener listener : TaskChangeRegistry.getTaskChangeListeners()) {
            listener.newTasks(newTasks);
        }
    }

    private static List<ITaskListener> getTaskChangeListeners() {
        if (taskChangeListeners == null) {
            taskChangeListeners = new LinkedList<ITaskListener>();
        }
        return taskChangeListeners;
    }
}

