/*
 * Decompiled with CFR 0.152.
 */
package sernet.verinice.bpm.rcp;

import java.lang.reflect.InvocationTargetException;
import java.util.LinkedList;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.IProgressService;
import sernet.gs.ui.rcp.main.Activator;
import sernet.gs.ui.rcp.main.ExceptionUtil;
import sernet.gs.ui.rcp.main.service.ServiceFactory;
import sernet.hui.common.VeriniceContext;
import sernet.springclient.RightsServiceClient;
import sernet.verinice.bpm.rcp.Messages;
import sernet.verinice.bpm.rcp.NewQmIssueDialog;
import sernet.verinice.bpm.rcp.TaskChangeRegistry;
import sernet.verinice.interfaces.RightEnabledUserInteraction;
import sernet.verinice.interfaces.bpm.IProcessStartInformation;
import sernet.verinice.model.common.CnATreeElement;
import sernet.verinice.rcp.InfoDialogWithShowToggle;

public class StartQmProcess
implements IObjectActionDelegate,
RightEnabledUserInteraction {
    private static final Logger LOG = Logger.getLogger(StartQmProcess.class);
    private List<String> selectedUuids = new LinkedList<String>();
    private List<String> selectedTitles = new LinkedList<String>();
    int numberOfProcess = 0;
    Boolean isActive = null;

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
    }

    public void run(IAction action) {
        NewQmIssueDialog dialog;
        if (!this.selectedUuids.isEmpty() && (dialog = new NewQmIssueDialog(Display.getCurrent().getActiveShell(), this.selectedTitles.get(0))).open() == 0) {
            this.startProcess(dialog.getDescription(), dialog.getPriority());
        }
    }

    private void startProcess(final String description, final String priority) {
        IProgressService progressService = PlatformUI.getWorkbench().getProgressService();
        try {
            progressService.run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    Activator.inheritVeriniceContextState();
                    StartQmProcess.this.numberOfProcess = 0;
                    IProcessStartInformation info = null;
                    if (!StartQmProcess.this.selectedUuids.isEmpty()) {
                        info = ServiceFactory.lookupQmService().startProcessesForElement(StartQmProcess.this.selectedUuids.get(0), (Object)description, priority);
                    }
                    if (info != null) {
                        StartQmProcess.this.numberOfProcess = info.getNumber();
                    }
                }
            });
            if (this.numberOfProcess > 0) {
                TaskChangeRegistry.tasksAdded();
            }
            InfoDialogWithShowToggle.openInformation(Messages.StartIsaProcess_0, Messages.bind((String)"{0} QM Processes started", (Object)this.numberOfProcess), Messages.StartIsaProcess_3, "info_processes_started");
        }
        catch (Exception t) {
            LOG.error((Object)"Error while creating tasks.", (Throwable)t);
            ExceptionUtil.log(t, Messages.StartIsaProcess_5);
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        action.setEnabled(this.checkRights());
        if (!Activator.getDefault().isStandalone()) {
            if (selection instanceof ITreeSelection) {
                ITreeSelection treeSelection = (ITreeSelection)selection;
                this.selectedUuids.clear();
                this.selectedTitles.clear();
                for (Object selectedElement : treeSelection) {
                    if (!(selectedElement instanceof CnATreeElement)) continue;
                    this.selectedUuids.add(((CnATreeElement)selectedElement).getUuid());
                    this.selectedTitles.add(((CnATreeElement)selectedElement).getTitle());
                }
            }
        } else {
            action.setEnabled(false);
        }
    }

    public boolean checkRights() {
        RightsServiceClient service = (RightsServiceClient)VeriniceContext.get((String)"rightsService");
        return service.isEnabled(this.getRightID());
    }

    public String getRightID() {
        return "createisatasks";
    }
}

