/*
 * Decompiled with CFR 0.152.
 */
package sernet.verinice.bpm.rcp;

import java.lang.reflect.InvocationTargetException;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.IProgressService;
import sernet.gs.ui.rcp.main.Activator;
import sernet.gs.ui.rcp.main.ExceptionUtil;
import sernet.gs.ui.rcp.main.service.ServiceFactory;
import sernet.hui.common.VeriniceContext;
import sernet.springclient.RightsServiceClient;
import sernet.verinice.bpm.rcp.Messages;
import sernet.verinice.interfaces.RightEnabledUserInteraction;
import sernet.verinice.interfaces.bpm.IProcessStartInformation;
import sernet.verinice.model.iso27k.Audit;
import sernet.verinice.rcp.InfoDialogWithShowToggle;

public class StartIsaProcess
implements IObjectActionDelegate,
RightEnabledUserInteraction {
    private static final Logger LOG = Logger.getLogger(StartIsaProcess.class);
    private Audit selectedAudit;
    int numberOfProcess = 0;
    Boolean isActive = null;

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
    }

    public void run(IAction action) {
        if (this.selectedAudit != null) {
            IProgressService progressService = PlatformUI.getWorkbench().getProgressService();
            try {
                progressService.run(true, true, new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                        Activator.inheritVeriniceContextState();
                        IProcessStartInformation info = ServiceFactory.lookupProcessServiceIsa().startProcessForIsa(StartIsaProcess.this.selectedAudit.getUuid());
                        StartIsaProcess.this.numberOfProcess = 0;
                        if (info != null) {
                            StartIsaProcess.this.numberOfProcess = info.getNumber();
                        }
                    }
                });
                if (this.numberOfProcess > 0) {
                    InfoDialogWithShowToggle.openInformation(Messages.StartIsaProcess_0, Messages.bind((String)Messages.StartIsaProcess_1, (Object)this.numberOfProcess), Messages.StartIsaProcess_3, "info_processes_started");
                } else {
                    MessageDialog.openInformation((Shell)Display.getDefault().getActiveShell(), (String)Messages.StartIsaProcess_0, (String)Messages.StartIsaProcess_7);
                }
            }
            catch (Exception t) {
                LOG.error((Object)"Error while creating tasks.", (Throwable)t);
                ExceptionUtil.log(t, Messages.StartIsaProcess_5);
            }
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        action.setEnabled(this.checkRights());
        if (!Activator.getDefault().isStandalone()) {
            ITreeSelection treeSelection;
            Object selectedElement;
            if (selection instanceof ITreeSelection && (selectedElement = (treeSelection = (ITreeSelection)selection).getFirstElement()) instanceof Audit) {
                this.selectedAudit = (Audit)selectedElement;
            }
        } else {
            action.setEnabled(false);
        }
    }

    public boolean checkRights() {
        RightsServiceClient service = (RightsServiceClient)VeriniceContext.get((String)"rightsService");
        return service.isEnabled(this.getRightID());
    }

    public String getRightID() {
        return "createisatasks";
    }
}

