/*
 * Decompiled with CFR 0.152.
 */
package sernet.verinice.bpm.rcp;

import java.lang.reflect.InvocationTargetException;
import java.util.LinkedList;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.IProgressService;
import sernet.gs.ui.rcp.main.Activator;
import sernet.gs.ui.rcp.main.ExceptionUtil;
import sernet.gs.ui.rcp.main.service.ServiceFactory;
import sernet.hui.common.VeriniceContext;
import sernet.springclient.RightsServiceClient;
import sernet.verinice.bpm.rcp.Messages;
import sernet.verinice.bpm.rcp.TaskChangeRegistry;
import sernet.verinice.interfaces.RightEnabledUserInteraction;
import sernet.verinice.interfaces.bpm.IProcessStartInformation;
import sernet.verinice.model.common.CnATreeElement;
import sernet.verinice.model.iso27k.Audit;
import sernet.verinice.model.iso27k.Control;
import sernet.verinice.model.iso27k.ControlGroup;
import sernet.verinice.rcp.InfoDialogWithShowToggle;

public class StartIsaControlFlowProcess
implements IObjectActionDelegate,
RightEnabledUserInteraction {
    private static final Logger LOG = Logger.getLogger(StartIsaControlFlowProcess.class);
    private List<String> selectedControlUuids = new LinkedList<String>();
    private List<String> selectedControlGroupUuids = new LinkedList<String>();
    private List<String> selectedAuditUuids = new LinkedList<String>();
    int numberOfProcess = 0;
    Boolean isActive = null;

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
    }

    public void run(IAction action) {
        if (!(this.selectedControlUuids.isEmpty() && this.selectedControlGroupUuids.isEmpty() && this.selectedAuditUuids.isEmpty())) {
            IProgressService progressService = PlatformUI.getWorkbench().getProgressService();
            try {
                progressService.run(true, true, new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                        Activator.inheritVeriniceContextState();
                        StartIsaControlFlowProcess.this.numberOfProcess = 0;
                        IProcessStartInformation info = null;
                        if (!StartIsaControlFlowProcess.this.selectedControlUuids.isEmpty()) {
                            info = ServiceFactory.lookupIsaControlFlowService().startProcessesForControls(StartIsaControlFlowProcess.this.selectedControlUuids);
                        }
                        if (info != null) {
                            StartIsaControlFlowProcess.this.numberOfProcess = info.getNumber();
                        }
                        info = null;
                        if (!StartIsaControlFlowProcess.this.selectedControlGroupUuids.isEmpty()) {
                            info = ServiceFactory.lookupIsaControlFlowService().startProcessesForGroups(StartIsaControlFlowProcess.this.selectedControlGroupUuids);
                        }
                        if (info != null) {
                            StartIsaControlFlowProcess.this.numberOfProcess += info.getNumber();
                        }
                        info = null;
                        if (!StartIsaControlFlowProcess.this.selectedAuditUuids.isEmpty()) {
                            info = ServiceFactory.lookupIsaControlFlowService().startProcessesForAudits(StartIsaControlFlowProcess.this.selectedAuditUuids);
                        }
                        if (info != null) {
                            StartIsaControlFlowProcess.this.numberOfProcess += info.getNumber();
                        }
                    }
                });
                if (this.numberOfProcess > 0) {
                    TaskChangeRegistry.tasksAdded();
                }
                if (this.numberOfProcess > 0) {
                    InfoDialogWithShowToggle.openInformation(Messages.StartIsaProcess_0, Messages.bind((String)Messages.StartIsaProcess_1, (Object)this.numberOfProcess), Messages.StartIsaProcess_3, "info_processes_started");
                } else if (this.numberOfProcess == 0) {
                    MessageDialog.openInformation((Shell)Display.getDefault().getActiveShell(), (String)Messages.StartIsaProcess_0, (String)Messages.StartIsaProcess_6);
                }
            }
            catch (Exception t) {
                LOG.error((Object)"Error while creating tasks.", (Throwable)t);
                ExceptionUtil.log(t, Messages.StartIsaProcess_5);
            }
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        action.setEnabled(this.checkRights());
        if (!Activator.getDefault().isStandalone()) {
            if (selection instanceof ITreeSelection) {
                ITreeSelection treeSelection = (ITreeSelection)selection;
                this.selectedControlUuids.clear();
                this.selectedControlGroupUuids.clear();
                for (Object selectedElement : treeSelection) {
                    if (selectedElement instanceof Control) {
                        this.selectedControlUuids.add(((CnATreeElement)selectedElement).getUuid());
                    }
                    if (selectedElement instanceof ControlGroup) {
                        this.selectedControlGroupUuids.add(((CnATreeElement)selectedElement).getUuid());
                    }
                    if (!(selectedElement instanceof Audit)) continue;
                    this.selectedAuditUuids.add(((CnATreeElement)selectedElement).getUuid());
                }
            }
        } else {
            action.setEnabled(false);
        }
    }

    public boolean checkRights() {
        RightsServiceClient service = (RightsServiceClient)VeriniceContext.get((String)"rightsService");
        return service.isEnabled(this.getRightID());
    }

    public String getRightID() {
        return "createisatasks";
    }
}

