/*
 * Decompiled with CFR 0.152.
 */
package sernet.verinice.bpm.rcp;

import java.lang.reflect.InvocationTargetException;
import java.util.LinkedList;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.IProgressService;
import sernet.gs.ui.rcp.main.Activator;
import sernet.gs.ui.rcp.main.ExceptionUtil;
import sernet.gs.ui.rcp.main.service.ServiceFactory;
import sernet.hui.common.VeriniceContext;
import sernet.springclient.RightsServiceClient;
import sernet.verinice.bpm.rcp.IndividualProcessWizard;
import sernet.verinice.bpm.rcp.Messages;
import sernet.verinice.bpm.rcp.TaskChangeRegistry;
import sernet.verinice.interfaces.RightEnabledUserInteraction;
import sernet.verinice.interfaces.bpm.IProcessStartInformation;
import sernet.verinice.interfaces.bpm.IndividualServiceParameter;
import sernet.verinice.model.bsi.ImportBsiGroup;
import sernet.verinice.model.common.CnATreeElement;
import sernet.verinice.model.common.Domain;
import sernet.verinice.model.common.DomainSpecificElementUtil;
import sernet.verinice.model.iso27k.ImportIsoGroup;
import sernet.verinice.rcp.InfoDialogWithShowToggle;
import sernet.verinice.rcp.NonModalWizardDialog;
import sernet.verinice.service.commands.CnATypeMapper;

public class StartIndividualProcess
implements IObjectActionDelegate,
RightEnabledUserInteraction {
    private static final Logger LOG = Logger.getLogger(StartIndividualProcess.class);
    private List<String> selectedUuids = new LinkedList<String>();
    private List<String> selectedTitles = new LinkedList<String>();
    private List<String> selectedTypeIds = new LinkedList<String>();
    private String personTypeId = "person-iso";
    private IndividualServiceParameter parameter = new IndividualServiceParameter();
    private int numberOfProcess = 0;

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
    }

    public void run(IAction action) {
        try {
            if (!this.selectedUuids.isEmpty() && this.isValid()) {
                IndividualProcessWizard wizard = new IndividualProcessWizard(this.selectedUuids, this.selectedTitles.get(0), this.selectedTypeIds.get(0));
                wizard.setPersonTypeId(this.personTypeId);
                NonModalWizardDialog wizardDialog = new NonModalWizardDialog(Display.getCurrent().getActiveShell(), (IWizard)wizard);
                if (wizardDialog.open() == 0) {
                    wizard.saveTemplate();
                    this.parameter = wizard.getParameter();
                    this.startProcess(wizard.getUuids());
                }
            }
        }
        catch (Exception e) {
            LOG.error((Object)"Error while starting individual task.", (Throwable)e);
        }
    }

    private boolean isValid() {
        boolean valid = true;
        if (!this.selectedTypeIds.isEmpty() && (valid = this.isOfTheSameType())) {
            valid = this.isValidType();
        }
        return valid;
    }

    private boolean isOfTheSameType() {
        boolean valid = true;
        String lastTypeId = null;
        for (String typeId : this.selectedTypeIds) {
            if (lastTypeId != null && !lastTypeId.equals(typeId)) {
                MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)Messages.StartIndividualProcess_1, (String)Messages.StartIndividualProcess_2);
                valid = false;
                break;
            }
            lastTypeId = typeId;
        }
        return valid;
    }

    private boolean isValidType() {
        String type;
        boolean valid = true;
        if (!this.selectedTypeIds.isEmpty() && (ImportBsiGroup.TYPE_ID.equals(type = this.selectedTypeIds.get(0)) || ImportIsoGroup.TYPE_ID.equals(type) || "bp_import_group".equals(type))) {
            MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)Messages.StartIndividualProcess_1, (String)Messages.StartIndividualProcess_3);
            valid = false;
        }
        return valid;
    }

    private void startProcess(final List<String> uuids) {
        IProgressService progressService = PlatformUI.getWorkbench().getProgressService();
        try {
            progressService.run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    Activator.inheritVeriniceContextState();
                    StartIndividualProcess.this.numberOfProcess = 0;
                    IProcessStartInformation info = null;
                    if (uuids != null && !uuids.isEmpty()) {
                        for (String uuid : uuids) {
                            StartIndividualProcess.this.parameter.setUuid(uuid);
                            info = ServiceFactory.lookupIndividualService().startProcess(StartIndividualProcess.this.parameter);
                            if (info == null) continue;
                            StartIndividualProcess.this.numberOfProcess += info.getNumber();
                        }
                    }
                }
            });
            if (this.numberOfProcess > 0) {
                TaskChangeRegistry.tasksAdded();
            }
            InfoDialogWithShowToggle.openInformation(Messages.StartIsaProcess_0, Messages.bind((String)Messages.StartIndividualProcess_0, (Object)this.numberOfProcess), Messages.StartIsaProcess_3, "info_processes_started");
        }
        catch (Exception t) {
            LOG.error((Object)"Error while creating tasks.", (Throwable)t);
            ExceptionUtil.log(t, Messages.StartIsaProcess_5);
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        action.setEnabled(this.checkRights());
        if (!Activator.getDefault().isStandalone()) {
            if (selection instanceof ITreeSelection) {
                ITreeSelection treeSelection = (ITreeSelection)selection;
                this.handleNewSelection(treeSelection);
            }
        } else {
            action.setEnabled(false);
        }
    }

    private void handleNewSelection(ITreeSelection treeSelection) {
        this.selectedUuids.clear();
        this.selectedTitles.clear();
        this.selectedTypeIds.clear();
        for (Object selectedElement : treeSelection) {
            if (!(selectedElement instanceof CnATreeElement)) continue;
            CnATreeElement element = (CnATreeElement)selectedElement;
            this.selectedUuids.add(element.getUuid());
            this.selectedTitles.add(element.getTitle());
            String typeId = element.getTypeId();
            Domain domain = CnATypeMapper.getDomainFromTypeId((String)typeId);
            this.personTypeId = DomainSpecificElementUtil.getPersonTypeIdFromDomain((Domain)domain);
            this.selectedTypeIds.add(typeId);
        }
    }

    public boolean checkRights() {
        RightsServiceClient service = (RightsServiceClient)VeriniceContext.get((String)"rightsService");
        return service.isEnabled(this.getRightID());
    }

    public String getRightID() {
        return "createindividualtasks";
    }
}

