/*
 * Decompiled with CFR 0.152.
 */
package sernet.verinice.bpm.rcp;

import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import sernet.hui.common.connect.DirectedHuiRelation;
import sernet.hui.common.connect.HuiRelation;
import sernet.hui.common.connect.HuiRelationUtil;
import sernet.verinice.bpm.rcp.Messages;
import sernet.verinice.iso27k.rcp.ComboModel;
import sernet.verinice.iso27k.rcp.IComboModelLabelProvider;

public class RelationPage
extends WizardPage {
    private static final Logger LOG = Logger.getLogger(RelationPage.class);
    public static final String NAME = "RELATION_PAGE";
    private String elementType;
    private DirectedHuiRelation relation;
    private Combo relationCombo;
    private ComboModel<DirectedHuiRelation> relationComboModel;
    private boolean isActive = true;
    private final String personTypeId;

    protected RelationPage(String elementType, String personTypeId) {
        super(NAME);
        this.personTypeId = personTypeId;
        this.setTitle(Messages.RelationPage_1);
        this.setMessage(Messages.RelationPage_2);
        this.elementType = elementType;
        this.initComboValues();
    }

    private void addFormElements(Composite container) {
        Label typeLabel = new Label(container, 0);
        typeLabel.setText(Messages.RelationPage_3);
        this.relationCombo = new Combo(container, 2572);
        GridData gd = new GridData(4, 128, true, false);
        this.relationCombo.setLayoutData((Object)gd);
        this.relationCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RelationPage.this.relationComboModel.setSelectedIndex(RelationPage.this.relationCombo.getSelectionIndex());
                RelationPage.this.relation = RelationPage.this.relationComboModel.getSelectedObject();
            }
        });
        if (!this.relationComboModel.isEmpty()) {
            this.relationCombo.setItems(this.relationComboModel.getLabelArray());
            this.relationCombo.select(0);
            this.relationComboModel.setSelectedIndex(0);
            this.relation = this.relationComboModel.getSelectedObject();
        } else {
            this.relationCombo.setEnabled(false);
        }
    }

    public boolean isPageComplete() {
        if (!this.isActive) {
            return true;
        }
        boolean complete = super.isPageComplete();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("page complete: " + complete));
        }
        return complete;
    }

    private void initComboValues() {
        this.relationComboModel = new ComboModel<DirectedHuiRelation>(new IComboModelLabelProvider<DirectedHuiRelation>(){

            @Override
            public String getLabel(DirectedHuiRelation relation) {
                return relation.getLabel();
            }
        });
        Set allPossibleRelations = HuiRelationUtil.getAllRelationsBothDirections((String)this.elementType, (String)this.personTypeId);
        for (DirectedHuiRelation possibleRelation : allPossibleRelations) {
            this.relationComboModel.add(possibleRelation);
        }
        if (!this.relationComboModel.isEmpty()) {
            this.relationComboModel.sort();
        }
    }

    public boolean isRelation() {
        return !this.relationComboModel.isEmpty();
    }

    public IWizardPage getNextPage() {
        return this.getWizard().getPage("PROPERTY_PAGE");
    }

    public void createControl(Composite parent) {
        int defaultMarginWidth = 10;
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(1, true);
        layout.marginWidth = 10;
        composite.setLayout((Layout)layout);
        GridData gd = new GridData(4, 4, true, true);
        composite.setLayoutData((Object)gd);
        this.addFormElements(composite);
        composite.pack();
        this.setControl((Control)composite);
        this.setPageComplete(true);
    }

    public void setActive(boolean active) {
        this.isActive = active;
    }

    public String getRelationId() {
        return this.relation != null ? this.relation.getHuiRelation().getId() : null;
    }

    public String getRelationName() {
        return this.relation != null ? this.relation.getLabel() : null;
    }

    public void setRelationId(String relationId) {
        if (relationId != null && this.relationComboModel != null) {
            int size = this.relationComboModel.getSize();
            int i = 0;
            while (i < size) {
                DirectedHuiRelation directedHuiRelation = this.relationComboModel.getObject(i);
                HuiRelation rel = directedHuiRelation.getHuiRelation();
                if (relationId.equals(rel.getId())) {
                    this.relationComboModel.setSelectedIndex(i);
                    this.relationCombo.select(i);
                    this.relation = directedHuiRelation;
                    break;
                }
                ++i;
            }
        }
    }
}

