/*
 * Decompiled with CFR 0.152.
 */
package sernet.verinice.bpm.rcp;

import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import sernet.gs.ui.rcp.main.service.ServiceFactory;
import sernet.hui.common.VeriniceContext;
import sernet.verinice.bpm.ICompleteClientHandler;
import sernet.verinice.bpm.rcp.CompletionAbortedException;
import sernet.verinice.bpm.rcp.IndividualProcessWizard;
import sernet.verinice.interfaces.bpm.ITask;
import sernet.verinice.interfaces.bpm.ITaskService;
import sernet.verinice.interfaces.bpm.IndividualServiceParameter;
import sernet.verinice.model.common.Domain;
import sernet.verinice.model.common.DomainSpecificElementUtil;
import sernet.verinice.rcp.NonModalWizardDialog;
import sernet.verinice.service.commands.CnATypeMapper;

public class RejectRealizationClientHandler
implements ICompleteClientHandler {
    private static final Logger LOG = Logger.getLogger(RejectRealizationClientHandler.class);
    private Shell shell;
    private int dialogStatus;

    @Override
    public Map<String, Object> execute(ITask task) {
        HashMap<String, Object> parameter = new HashMap<String, Object>();
        try {
            IndividualProcessWizard wizard = new IndividualProcessWizard(Collections.singletonList(task.getUuid()), task.getElementTitle(), task.getElementType());
            Domain domain = CnATypeMapper.getDomainFromTypeId((String)task.getElementType());
            String type = DomainSpecificElementUtil.getPersonTypeIdFromDomain((Domain)domain);
            wizard.setPersonTypeId(type);
            Display.getDefault().syncExec(() -> {
                NonModalWizardDialog wizardDialog = new NonModalWizardDialog(this.shell, (IWizard)wizard);
                wizardDialog.create();
                IndividualServiceParameter individualServiceParameter = this.getIndividualServiceParameter(task.getId());
                wizard.setTemplateForRejectedRealization(individualServiceParameter);
                this.dialogStatus = wizardDialog.open();
            });
            if (this.dialogStatus != 0) {
                throw new CompletionAbortedException("Canceled by user.");
            }
            wizard.saveTemplate();
            parameter.putAll(ServiceFactory.lookupIndividualService().createParameterMap(wizard.getParameter()));
        }
        catch (CompletionAbortedException e) {
            throw e;
        }
        catch (Exception e) {
            LOG.error((Object)"Error while apply for extension.", (Throwable)e);
        }
        return parameter;
    }

    private IndividualServiceParameter getIndividualServiceParameter(String taskId) {
        Map taskVariables = this.getTaskService().getVariables(taskId);
        IndividualServiceParameter individualServiceParameter = new IndividualServiceParameter();
        individualServiceParameter.setDueDate((Date)taskVariables.get("ISA_DUEDATE"));
        individualServiceParameter.setReminderPeriodDays((Integer)taskVariables.get("INDI_REMINDER_DAYS"));
        individualServiceParameter.setAssignee((String)taskVariables.get("ISA_ASSIGNEE_NAME"));
        individualServiceParameter.setAssigneeRelationId((String)taskVariables.get("INDI_RELATION_ID"));
        individualServiceParameter.setProperties((Set)taskVariables.get("PROPERTY_TYPES"));
        individualServiceParameter.setTitle((String)taskVariables.get("INDI_TITLE"));
        individualServiceParameter.setDescription((String)taskVariables.get("INDI_DESCRIPTION"));
        individualServiceParameter.setWithAReleaseProcess(((Boolean)taskVariables.get("INDI_IS_WITH_RELEASE_PROCESS")).booleanValue());
        return individualServiceParameter;
    }

    @Override
    public void setShell(Shell shell) {
        this.shell = shell;
    }

    private ITaskService getTaskService() {
        return (ITaskService)VeriniceContext.get((String)"taskService");
    }
}

