/*
 * Decompiled with CFR 0.152.
 */
package sernet.verinice.bpm.rcp;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import sernet.hui.common.connect.EntityType;
import sernet.hui.common.connect.HitroUtil;
import sernet.hui.common.connect.IEntityElement;
import sernet.hui.common.connect.PropertyGroup;
import sernet.hui.common.connect.PropertyType;
import sernet.verinice.bpm.rcp.Messages;
import sernet.verinice.bpm.rcp.PropertyTreeContentProvider;

public class PropertyPage
extends WizardPage {
    private static final Logger LOG = Logger.getLogger(PropertyPage.class);
    public static final String NAME = "PROPERTY_PAGE";
    private String elementType;
    private TreeViewer tableSelected;
    private TreeViewer table;
    private PropertyTreeContentProvider selectedContentProvider = new PropertyTreeContentProvider();
    private PropertyTreeContentProvider contentProvider = new PropertyTreeContentProvider();
    private Button addAllButton;
    private Button removeAllButton;
    private List selectedItems;
    private List unselectedItems = new ArrayList();
    private List<PropertyType> selectedProperties;
    private List<PropertyType> unselectedProperties = new ArrayList<PropertyType>();
    private List<PropertyType> allProperties;
    private Map<String, PropertyType> allPropertiesMap;

    protected PropertyPage(String elementType) {
        super(NAME);
        this.setTitle(Messages.PropertyPage_1);
        this.setMessage(Messages.PropertyPage_2);
        this.elementType = elementType;
    }

    private void addFormElements(Composite parent) {
        int fourCCompositeCharLength = 20;
        int fourCCompositeNumColumns = 3;
        int leftCompositeCharLength = 40;
        int rightCompositeCharLength = 40;
        Composite composite = new Composite(parent, 4);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(1808));
        Composite fourColumnComposite = new Composite(composite, 0);
        GridData gridData = new GridData(4, 4, true, true);
        gridData.heightHint = this.convertHeightInCharsToPixels(20);
        fourColumnComposite.setLayoutData((Object)gridData);
        GridLayout gridLayout = new GridLayout(3, false);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        fourColumnComposite.setLayout((Layout)gridLayout);
        Composite leftComposite = new Composite(fourColumnComposite, 0);
        gridData = new GridData(4, 4, true, true);
        gridData.widthHint = this.convertWidthInCharsToPixels(40);
        leftComposite.setLayoutData((Object)gridData);
        gridLayout = new GridLayout(1, false);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        leftComposite.setLayout((Layout)gridLayout);
        Composite centerComposite = new Composite(fourColumnComposite, 0);
        gridLayout = new GridLayout(1, false);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        centerComposite.setLayout((Layout)gridLayout);
        centerComposite.setLayoutData((Object)new GridData(0x1000000, 128, false, false));
        Composite rightComposite = new Composite(fourColumnComposite, 0);
        gridData = new GridData(4, 4, true, true);
        gridData.widthHint = this.convertWidthInCharsToPixels(40);
        rightComposite.setLayoutData((Object)gridData);
        gridLayout = new GridLayout(1, false);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        rightComposite.setLayout((Layout)gridLayout);
        this.tableSelected = this.createTreeTable(leftComposite, Messages.PropertyPage_3);
        this.tableSelected.setLabelProvider((IBaseLabelProvider)new PropertyTypeLabelProvider());
        this.tableSelected.setContentProvider((IContentProvider)this.selectedContentProvider);
        this.tableSelected.refresh(true);
        this.table = this.createTreeTable(rightComposite, Messages.PropertyPage_4);
        this.table.setLabelProvider((IBaseLabelProvider)new PropertyTypeLabelProvider());
        this.table.setContentProvider((IContentProvider)this.contentProvider);
        this.table.refresh(true);
        this.initializeContent();
        this.createButtons(centerComposite);
    }

    private void initializeContent() {
        EntityType entityType = HitroUtil.getInstance().getTypeFactory().getEntityType(this.elementType);
        this.allProperties = new LinkedList<PropertyType>();
        this.selectedProperties = new LinkedList<PropertyType>();
        this.allPropertiesMap = new Hashtable<String, PropertyType>();
        for (PropertyType property : entityType.getAllPropertyTypes()) {
            if (!property.isVisible()) continue;
            this.allProperties.add(property);
            this.selectedProperties.add(property);
            this.allPropertiesMap.put(property.getId(), property);
        }
        this.selectedItems = new LinkedList();
        for (IEntityElement element : entityType.getElements()) {
            PropertyType propertyType;
            if (element instanceof PropertyType && (propertyType = (PropertyType)element).isVisible()) {
                this.selectedItems.add(propertyType);
            }
            if (!(element instanceof PropertyGroup)) continue;
            this.selectedItems.add(element);
        }
        this.selectedContentProvider.setVisibleTyps(this.selectedProperties);
        this.contentProvider.setVisibleTyps(this.unselectedProperties);
        this.tableSelected.setInput((Object)this.selectedItems);
        this.table.setInput((Object)this.selectedItems);
    }

    private void addSelection() {
        IStructuredSelection selection = (IStructuredSelection)this.table.getSelection();
        List selectionList = selection.toList();
        for (Object item : selectionList) {
            if (item instanceof PropertyType) {
                PropertyType propertyType = (PropertyType)item;
                this.selectedProperties.add(propertyType);
                this.unselectedProperties.remove(propertyType);
            }
            if (!(item instanceof PropertyGroup)) continue;
            PropertyGroup group = (PropertyGroup)item;
            this.selectedProperties.addAll(group.getPropertyTypes());
            this.unselectedProperties.removeAll(group.getPropertyTypes());
        }
        this.selectedContentProvider.setVisibleTyps(this.selectedProperties);
        this.contentProvider.setVisibleTyps(this.unselectedProperties);
        this.tableSelected.setInput((Object)this.selectedItems);
        this.table.setInput((Object)this.selectedItems);
        this.tableSelected.setSelection((ISelection)selection);
        this.table.getControl().setFocus();
    }

    private void removeSelection() {
        IStructuredSelection selection = (IStructuredSelection)this.tableSelected.getSelection();
        List selectionList = selection.toList();
        for (Object item : selectionList) {
            if (item instanceof PropertyType) {
                PropertyType propertyType = (PropertyType)item;
                this.selectedProperties.remove(propertyType);
                this.unselectedProperties.add(propertyType);
            }
            if (!(item instanceof PropertyGroup)) continue;
            PropertyGroup group = (PropertyGroup)item;
            this.selectedProperties.removeAll(group.getPropertyTypes());
            this.unselectedProperties.addAll(group.getPropertyTypes());
        }
        this.selectedContentProvider.setVisibleTyps(this.selectedProperties);
        this.contentProvider.setVisibleTyps(this.unselectedProperties);
        this.tableSelected.setInput((Object)this.selectedItems);
        this.table.setInput((Object)this.selectedItems);
        this.table.setSelection((ISelection)selection);
        this.tableSelected.getControl().setFocus();
    }

    private void createButtons(Composite parent) {
        Label spacer = new Label(parent, 0);
        spacer.setLayoutData((Object)new GridData(4, 128, true, false));
        final Button addButton = new Button(parent, 8);
        addButton.setLayoutData((Object)new GridData(4, 128, true, false));
        addButton.setText(Messages.PropertyPage_5);
        addButton.setEnabled(!this.table.getSelection().isEmpty());
        this.addAllButton = new Button(parent, 8);
        this.addAllButton.setLayoutData((Object)new GridData(4, 128, true, false));
        this.addAllButton.setText(Messages.PropertyPage_6);
        this.addAllButton.setEnabled(!this.unselectedItems.isEmpty());
        final Button removeButton = new Button(parent, 8);
        removeButton.setLayoutData((Object)new GridData(4, 128, true, false));
        removeButton.setText(Messages.PropertyPage_7);
        removeButton.setEnabled(!this.table.getSelection().isEmpty());
        this.removeAllButton = new Button(parent, 8);
        this.removeAllButton.setLayoutData((Object)new GridData(0x1000000, 128, false, false));
        this.removeAllButton.setText(Messages.PropertyPage_8);
        this.removeAllButton.setEnabled(!this.selectedItems.isEmpty());
        this.table.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                addButton.setEnabled(!event.getSelection().isEmpty());
            }
        });
        addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PropertyPage.this.addSelection();
                PropertyPage.this.removeAllButton.setEnabled(true);
                PropertyPage.this.addAllButton.setEnabled(!PropertyPage.this.table.getSelection().isEmpty());
            }
        });
        this.table.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                PropertyPage.this.addSelection();
                PropertyPage.this.removeAllButton.setEnabled(true);
                PropertyPage.this.addAllButton.setEnabled(!PropertyPage.this.table.getSelection().isEmpty());
            }
        });
        this.tableSelected.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                removeButton.setEnabled(!event.getSelection().isEmpty());
            }
        });
        removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PropertyPage.this.removeSelection();
                PropertyPage.this.addAllButton.setEnabled(true);
                PropertyPage.this.removeAllButton.setEnabled(!PropertyPage.this.selectedItems.isEmpty());
            }
        });
        this.tableSelected.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                PropertyPage.this.removeSelection();
                PropertyPage.this.addAllButton.setEnabled(true);
                PropertyPage.this.removeAllButton.setEnabled(!PropertyPage.this.selectedItems.isEmpty());
            }
        });
        this.addAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PropertyPage.this.selectedProperties.addAll(PropertyPage.this.unselectedProperties);
                PropertyPage.this.unselectedProperties.clear();
                PropertyPage.this.selectedContentProvider.setVisibleTyps(PropertyPage.this.selectedProperties);
                PropertyPage.this.contentProvider.setVisibleTyps(PropertyPage.this.unselectedProperties);
                PropertyPage.this.table.refresh();
                PropertyPage.this.tableSelected.refresh();
                PropertyPage.this.addAllButton.setEnabled(false);
                PropertyPage.this.removeAllButton.setEnabled(true);
            }
        });
        this.removeAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PropertyPage.this.unselectedProperties.addAll(PropertyPage.this.selectedProperties);
                PropertyPage.this.selectedProperties.clear();
                PropertyPage.this.selectedContentProvider.setVisibleTyps(PropertyPage.this.selectedProperties);
                PropertyPage.this.contentProvider.setVisibleTyps(PropertyPage.this.unselectedProperties);
                PropertyPage.this.table.refresh();
                PropertyPage.this.tableSelected.refresh();
                PropertyPage.this.removeAllButton.setEnabled(false);
                PropertyPage.this.addAllButton.setEnabled(true);
            }
        });
    }

    private TreeViewer createTreeTable(Composite parent, String title) {
        Label label = new Label(parent, 64);
        label.setText(title);
        label.setLayoutData((Object)new GridData(4, 128, true, false));
        int style = 2816;
        TreeViewer table = new TreeViewer(parent, style | 2);
        GridData gd = new GridData(4, 4, true, true);
        table.getControl().setLayoutData((Object)gd);
        table.setUseHashlookup(true);
        return table;
    }

    public void createControl(Composite parent) {
        int layoutMarginWidth = 10;
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(1, true);
        layout.marginWidth = 10;
        composite.setLayout((Layout)layout);
        GridData gd = new GridData(4, 4, true, true);
        composite.setLayoutData((Object)gd);
        this.addFormElements(composite);
        composite.pack();
        this.setControl((Control)composite);
        this.setPageComplete(true);
    }

    public void setPropertyIds(Set<String> propertyIds) {
        this.selectedProperties.clear();
        this.unselectedProperties.clear();
        for (String id : propertyIds) {
            PropertyType type = this.allPropertiesMap.get(id);
            if (type == null) continue;
            this.selectedProperties.add(type);
        }
        if (!this.selectedProperties.isEmpty()) {
            this.setUnselected();
            this.table.refresh();
            this.tableSelected.refresh();
        } else {
            this.initializeContent();
        }
    }

    private void setUnselected() {
        HashMap<String, String> mapSelected = new HashMap<String, String>(this.allProperties.size());
        for (PropertyType profile : this.selectedProperties) {
            mapSelected.put(profile.getId(), profile.getId());
        }
        this.unselectedProperties.clear();
        for (PropertyType prop : this.allProperties) {
            if (mapSelected.containsKey(prop.getId())) continue;
            this.unselectedProperties.add(prop);
        }
    }

    public boolean isPageComplete() {
        boolean complete = super.isPageComplete();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("page complete: " + complete));
        }
        return complete;
    }

    public List<PropertyType> getSelectedProperties() {
        return this.selectedProperties;
    }

    class PropertyTypeLabelProvider
    extends ColumnLabelProvider {
        PropertyTypeLabelProvider() {
        }

        public String getText(Object element) {
            String text = Messages.PropertyPage_10;
            if (element instanceof PropertyType) {
                text = ((PropertyType)element).getName();
            }
            if (element instanceof PropertyGroup) {
                text = ((PropertyGroup)element).getName();
            }
            return text;
        }
    }
}

