/*
 * Decompiled with CFR 0.152.
 */
package sernet.verinice.bpm.rcp;

import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import sernet.gs.ui.rcp.main.service.ServiceFactory;
import sernet.verinice.bpm.rcp.Messages;
import sernet.verinice.bpm.rcp.PropertyPage;
import sernet.verinice.interfaces.CommandException;
import sernet.verinice.interfaces.ICommand;
import sernet.verinice.model.common.CnATreeElement;
import sernet.verinice.model.common.configuration.Configuration;
import sernet.verinice.rcp.ElementSelectionComponent;
import sernet.verinice.service.commands.LoadConfiguration;

public class PersonPage
extends WizardPage {
    private static final Logger LOG = Logger.getLogger(PersonPage.class);
    public static final String NAME = "PERSON_PAGE";
    private CnATreeElement selectedPerson;
    private String selectedLogin;
    private String personTypeId = "person-iso";
    private boolean isActive = true;
    private ElementSelectionComponent component;

    protected PersonPage() {
        super(NAME);
        this.setTitle(Messages.PersonPage_1);
        this.setMessage(Messages.PersonPage_2);
    }

    private void addFormElements(Composite composite) {
        this.component = new ElementSelectionComponent(composite, this.personTypeId, null);
        this.component.setScopeOnly(false);
        this.component.setShowScopeCheckbox(false);
        this.component.init();
        this.component.getViewer().addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                PersonPage.this.setErrorMessage(null);
                List<CnATreeElement> selectedElements = PersonPage.this.component.getSelectedElements();
                boolean valid = PersonPage.this.laodAndCheckPerson(selectedElements);
                PersonPage.this.setPageComplete(valid);
            }
        });
    }

    private boolean laodAndCheckPerson(List<CnATreeElement> selectedElements) {
        boolean valid = true;
        if (selectedElements == null || selectedElements.isEmpty()) {
            valid = false;
        }
        if (valid && selectedElements.size() > 1) {
            valid = false;
            this.setErrorMessage(Messages.PersonPage_3);
        }
        if (valid) {
            this.selectedPerson = selectedElements.get(0);
            this.selectedLogin = this.loadLogin(this.selectedPerson);
            if (this.selectedLogin == null) {
                valid = false;
                this.selectedPerson = null;
                this.setErrorMessage(Messages.PersonPage_4);
            }
        }
        return valid;
    }

    public boolean isPageComplete() {
        if (!this.isActive) {
            return true;
        }
        boolean complete = super.isPageComplete();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("page complete: " + complete));
        }
        return complete;
    }

    public IWizardPage getNextPage() {
        return (PropertyPage)this.getWizard().getPage("PROPERTY_PAGE");
    }

    public void createControl(Composite parent) {
        int marginWidth = 10;
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(1, true);
        layout.marginWidth = 10;
        composite.setLayout((Layout)layout);
        GridData gd = new GridData(4, 4, true, true);
        composite.setLayoutData((Object)gd);
        this.addFormElements(composite);
        composite.pack();
        this.setControl((Control)composite);
        this.setPageComplete(false);
    }

    private String loadLogin(CnATreeElement element) {
        String login = null;
        try {
            LoadConfiguration command = new LoadConfiguration(element);
            command = (LoadConfiguration)ServiceFactory.lookupCommandService().executeCommand((ICommand)command);
            Configuration configuration = command.getConfiguration();
            if (configuration != null) {
                login = configuration.getUser();
            }
        }
        catch (CommandException e) {
            LOG.error((Object)"Error while loading account data.", (Throwable)e);
        }
        return login;
    }

    public void setActive(boolean active) {
        this.isActive = active;
    }

    public CnATreeElement getSelectedPerson() {
        return this.selectedPerson;
    }

    public void setSelectedPerson(CnATreeElement selectedPerson) {
        if (selectedPerson != null) {
            this.selectedPerson = selectedPerson;
            this.setErrorMessage(null);
            this.setPageComplete(true);
        }
    }

    public String getSelectedLogin() {
        return this.selectedLogin;
    }

    public void setPersonTypeId(String personTypeId) {
        this.personTypeId = personTypeId;
        if (this.component != null) {
            this.component.setTypeId(personTypeId);
            this.component.loadElementsAndSelect(this.selectedPerson);
        }
    }

    public void setSelectedLogin(String selectedLogin) {
        this.selectedLogin = selectedLogin;
        this.setPageComplete(selectedLogin != null);
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.component.loadElementsAndSelect(this.selectedPerson);
        }
    }
}

