/*
 * Decompiled with CFR 0.152.
 */
package sernet.verinice.bpm.rcp;

import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import sernet.verinice.bpm.rcp.Messages;

public class NewQmIssueDialog
extends TitleAreaDialog {
    private static final String[] PRIORITY_ARRAY = new String[]{"LOW", "NORMAL", "HIGH"};
    private static final String[] PRIORITY_LABEL_ARRAY = new String[]{Messages.NewQmIssueDialog_0, Messages.NewQmIssueDialog_1, Messages.NewQmIssueDialog_2};
    private static final int DEFAULT_PRIORITY_INDEX = 1;
    private static final int DIALOG_WIDTH = 400;
    private String elementTitle;
    private String description;
    private String priority;

    public NewQmIssueDialog(Shell parentShell) {
        super(parentShell);
        int style = 1120;
        style = style | 0x800 | 0x10000;
        this.setShellStyle(style | 0x10);
    }

    public NewQmIssueDialog(Shell activeShell, String title) {
        this(activeShell);
        int maxTitleLength = 40;
        String newTitle = title;
        if (title.length() > 40) {
            newTitle = String.valueOf(title.substring(0, 40)) + "...";
        }
        this.elementTitle = newTitle;
    }

    private void addFormElements(Composite composite) {
        int dialogWidthSubtrahend = 30;
        int gdHeightHint = 150;
        if (this.elementTitle != null) {
            Label objectLabel = new Label(composite, 0);
            objectLabel.setText(Messages.NewQmIssueDialog_4);
            Label object = new Label(composite, 0);
            FontData[] fD = object.getFont().getFontData();
            int i = 0;
            while (i < fD.length) {
                fD[i].setStyle(1);
                ++i;
            }
            Font newFont = new Font((Device)this.getShell().getDisplay(), fD);
            object.setFont(newFont);
            GC gc = new GC((Drawable)object);
            Point size = gc.textExtent(this.elementTitle);
            if (size.x > 370) {
                this.elementTitle = String.valueOf(this.trimTitleByWidthSize(gc, this.elementTitle, 370)) + "...";
            }
            object.setText(this.elementTitle);
        }
        Label descriptionLabel = new Label(composite, 0);
        descriptionLabel.setText(Messages.NewQmIssueDialog_6);
        final Text textArea = new Text(composite, 18498);
        GridData gd = new GridData(4, 128, true, false);
        gd.heightHint = 150;
        textArea.setLayoutData((Object)gd);
        textArea.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent e) {
                NewQmIssueDialog.this.description = textArea.getText();
            }

            public void focusGained(FocusEvent e) {
            }
        });
        Label priorityLabel = new Label(composite, 0);
        priorityLabel.setText(Messages.NewQmIssueDialog_7);
        final Combo priorityCombo = new Combo(composite, 2572);
        priorityCombo.setItems(PRIORITY_LABEL_ARRAY);
        priorityCombo.select(1);
        this.priority = PRIORITY_ARRAY[1];
        priorityCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NewQmIssueDialog.this.priority = PRIORITY_ARRAY[priorityCombo.getSelectionIndex()];
            }
        });
    }

    private String trimTitleByWidthSize(GC gc, String elementTitle, int width) {
        String newTitle = elementTitle.substring(0, elementTitle.length() - 1);
        Point size = gc.textExtent(String.valueOf(newTitle) + "...");
        if (size.x > width) {
            newTitle = this.trimTitleByWidthSize(gc, newTitle, width);
        }
        return newTitle;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        int shellHeight = 450;
        newShell.setSize(400, 450);
        newShell.setText(Messages.NewQmIssueDialog_9);
    }

    protected Control createDialogArea(Composite parent) {
        int defaultMarginWidth = 10;
        this.setTitle(Messages.NewQmIssueDialog_10);
        this.setMessage(Messages.NewQmIssueDialog_11);
        Composite composite = (Composite)super.createDialogArea(parent);
        GridLayout layout = (GridLayout)composite.getLayout();
        layout.marginWidth = 10;
        GridData gd = new GridData(4, 4, true, true);
        composite.setLayoutData((Object)gd);
        ScrolledComposite scrolledComposite = new ScrolledComposite(composite, 512);
        scrolledComposite.setLayoutData((Object)new GridData(1808));
        scrolledComposite.setExpandHorizontal(true);
        Composite innerComposite = new Composite((Composite)scrolledComposite, 0);
        scrolledComposite.setContent((Control)innerComposite);
        innerComposite.setLayoutData((Object)new GridData(4, 4, true, false));
        innerComposite.setLayout((Layout)new GridLayout(1, false));
        this.addFormElements(innerComposite);
        scrolledComposite.setVisible(true);
        Point size = innerComposite.computeSize(-1, -1);
        innerComposite.setSize(size);
        Label separator = new Label(composite, 258);
        separator.setLayoutData((Object)new GridData(768));
        composite.pack();
        this.setDialogLocation();
        return composite;
    }

    private void setDialogLocation() {
        Rectangle monitorArea = this.getShell().getDisplay().getPrimaryMonitor().getBounds();
        Rectangle shellArea = this.getShell().getBounds();
        int x = monitorArea.x + (monitorArea.width - shellArea.width) / 2;
        int y = monitorArea.y + (monitorArea.height - shellArea.height) / 2;
        this.getShell().setLocation(x, y);
    }

    public String getDescription() {
        return this.description;
    }

    public String getPriority() {
        return this.priority;
    }
}

