/*
 * Decompiled with CFR 0.152.
 */
package sernet.verinice.bpm.rcp;

import java.util.Collections;
import java.util.List;
import org.apache.log4j.Logger;
import sernet.gs.service.NotifyingThread;
import sernet.gs.ui.rcp.main.Activator;
import sernet.gs.ui.rcp.main.service.ServiceFactory;
import sernet.verinice.interfaces.bpm.ITask;
import sernet.verinice.interfaces.bpm.ITaskParameter;

final class LoadTaskJob
extends NotifyingThread {
    private static final Logger LOG = Logger.getLogger(LoadTaskJob.class);
    private ITaskParameter param;
    private List<ITask> taskList;

    public LoadTaskJob() {
    }

    public LoadTaskJob(ITaskParameter param) {
        this.param = param;
    }

    public void doRun() {
        this.loadTasks();
    }

    public void loadTasks() {
        Activator.inheritVeriniceContextState();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Loading tasks...");
        }
        this.taskList = this.listAllUserEnabled() ? ServiceFactory.lookupTaskService().getTaskList(this.param) : ServiceFactory.lookupTaskService().getCurrentUserTaskList(this.param);
        Collections.sort(this.taskList);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Tasks loading finished.");
        }
    }

    private boolean listAllUserEnabled() {
        return ServiceFactory.lookupRightsServiceClient().isEnabled("taskshowall");
    }

    public ITaskParameter getParam() {
        return this.param;
    }

    public void setParam(ITaskParameter param) {
        this.param = param;
    }

    public List<ITask> getTaskList() {
        return this.taskList;
    }
}

