/*
 * Decompiled with CFR 0.152.
 */
package sernet.verinice.bpm.rcp;

import java.time.LocalDate;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import sernet.gs.ui.rcp.main.service.ServiceFactory;
import sernet.hui.common.connect.PropertyType;
import sernet.verinice.bpm.rcp.DatePage;
import sernet.verinice.bpm.rcp.DescriptionPage;
import sernet.verinice.bpm.rcp.Messages;
import sernet.verinice.bpm.rcp.PersonPage;
import sernet.verinice.bpm.rcp.PropertyPage;
import sernet.verinice.bpm.rcp.RelationPage;
import sernet.verinice.bpm.rcp.TemplatePage;
import sernet.verinice.interfaces.CommandException;
import sernet.verinice.interfaces.ICommand;
import sernet.verinice.interfaces.bpm.IndividualServiceParameter;
import sernet.verinice.model.common.CnATreeElement;
import sernet.verinice.service.commands.LoadPersonForLogin;

public class IndividualProcessWizard
extends Wizard {
    private static final Logger LOG = Logger.getLogger(IndividualProcessWizard.class);
    private DescriptionPage descriptionPage;
    private DatePage datePage;
    private PersonPage personPage;
    private RelationPage relationPage;
    private PropertyPage propertyPage;
    private TemplatePage templatePage;
    private String elementTitle;
    private String elementType;
    private String personTypeId = "person-iso";
    private List<String> uuids;
    public static final String PREFERENCE_NAME = "task_templates";
    public static final String PREFERENCE_NODE_NAME = "bpm";

    public IndividualProcessWizard(List<String> selectedUuids, String elementTitle, String typeId) {
        this.uuids = new ArrayList<String>(selectedUuids);
        this.elementTitle = elementTitle;
        this.elementType = typeId;
        this.setNeedsProgressMonitor(true);
        this.setWindowTitle(Messages.IndividualProcessWizard_2);
    }

    public void addPages() {
        this.descriptionPage = new DescriptionPage(this.elementTitle);
        this.addPage((IWizardPage)this.descriptionPage);
        this.relationPage = new RelationPage(this.elementType, this.personTypeId);
        this.datePage = new DatePage(this.relationPage.isRelation());
        this.personPage = new PersonPage();
        this.personPage.setPersonTypeId(this.getPersonTypeId());
        this.propertyPage = new PropertyPage(this.elementType);
        this.templatePage = new TemplatePage();
        this.addPage((IWizardPage)this.datePage);
        this.addPage((IWizardPage)this.personPage);
        this.addPage((IWizardPage)this.relationPage);
        this.addPage((IWizardPage)this.propertyPage);
        this.addPage((IWizardPage)this.templatePage);
    }

    public void setTemplate(IndividualServiceParameter template) {
        Integer periodDays = template.getReminderPeriodDays();
        LocalDate dueDate = LocalDate.now().plusDays(periodDays.intValue());
        this.datePage.setDueDate(dueDate);
        this.datePage.setPeriod(template.getReminderPeriodDays());
        if (template.getAssignee() != null || !this.relationPage.isRelation()) {
            this.datePage.setAssigneeSelectionMode("ASSIGNEE_SELECTION_DIRECT");
            this.relationPage.setActive(false);
            if (template.getAssignee() != null) {
                this.personPage.setSelectedLogin(template.getAssignee());
                CnATreeElement person = this.loadPersonForLogin(template.getAssignee());
                this.personPage.setSelectedPerson(person);
            }
        }
        if (template.getAssigneeRelationId() != null && this.relationPage.isRelation()) {
            this.datePage.setAssigneeSelectionMode("ASSIGNEE_SELECTION_RELATION");
            this.relationPage.setRelationId(template.getAssigneeRelationId());
            this.personPage.setActive(false);
        }
        this.propertyPage.setPropertyIds(template.getProperties());
        this.descriptionPage.setTaskTitle(template.getTitle());
        this.descriptionPage.setTaskDescription(template.getDescription());
        this.descriptionPage.setReleaseProcessSelected(template.isWithAReleaseProcess());
    }

    public void setTemplateForRejectedRealization(IndividualServiceParameter template) {
        this.setTemplate(template);
        this.descriptionPage.disableTemplatesAndReleaseProcessCheckbox();
        this.descriptionPage.setTitle(Messages.DescriptionPage_14);
        this.descriptionPage.setMessage(Messages.DescriptionPage_15);
    }

    public IndividualServiceParameter getParameter() {
        IndividualServiceParameter parameter = new IndividualServiceParameter();
        parameter.setTypeId(this.getElementType());
        if ("ASSIGNEE_SELECTION_RELATION".equals(this.datePage.getAssigneeSelectionMode())) {
            parameter.setAssigneeRelationId(this.getAssigneeRelationId());
            parameter.setAssigneeRelationName(this.getAssigneeRelationName());
        } else {
            parameter.setAssignee(this.getAssigneeLoginName());
        }
        parameter.setTitle(this.getTaskTitle());
        parameter.setDescription(this.getDescription());
        parameter.setDueDate(this.getDueDate());
        parameter.setReminderPeriodDays(this.getPeriod());
        parameter.setProperties(this.getProperties());
        parameter.setPropertyNames(this.getPropertyNames());
        parameter.setWithAReleaseProcess(this.isWithAReleaseProcess());
        return parameter;
    }

    public void saveTemplate() {
        this.templatePage.saveTemplate(this.overwriteTemplate());
    }

    public boolean performFinish() {
        return true;
    }

    public CnATreeElement getSelectedPerson() {
        return this.personPage.getSelectedPerson();
    }

    public String getAssigneeLoginName() {
        return this.personPage.getSelectedLogin();
    }

    public String getAssigneeRelationId() {
        return this.relationPage.getRelationId();
    }

    public String getAssigneeRelationName() {
        return this.relationPage.getRelationName();
    }

    public String getTaskTitle() {
        return this.descriptionPage.getTaskTitle();
    }

    public String getDescription() {
        return this.descriptionPage.getTaskDescription();
    }

    public Date getDueDate() {
        Date dueDate = null;
        LocalDate localDate = this.datePage.getDueDate();
        if (localDate != null) {
            ZonedDateTime zonedDateTime = localDate.atTime(LocalTime.now()).atZone(ZoneId.systemDefault());
            dueDate = Date.from(zonedDateTime.toInstant());
        }
        return dueDate;
    }

    public Integer getPeriod() {
        return this.datePage.getPeriod();
    }

    public boolean overwriteTemplate() {
        return this.descriptionPage.isOverwriteTemplate();
    }

    public boolean isWithAReleaseProcess() {
        return this.descriptionPage.isWithAReleaseProcess();
    }

    public String getElementType() {
        return this.elementType;
    }

    public String getPersonTypeId() {
        return this.personTypeId;
    }

    public void setPersonTypeId(String personTypeId) {
        this.personTypeId = personTypeId;
    }

    public List<String> getUuids() {
        return this.uuids;
    }

    public Set<String> getProperties() {
        List<PropertyType> selectedTypes = this.propertyPage.getSelectedProperties();
        HashSet<String> typeIds = new HashSet<String>(selectedTypes.size());
        for (PropertyType type : selectedTypes) {
            typeIds.add(type.getId());
        }
        return typeIds;
    }

    public Set<String> getPropertyNames() {
        List<PropertyType> selectedTypes = this.propertyPage.getSelectedProperties();
        HashSet<String> names = new HashSet<String>(selectedTypes.size());
        for (PropertyType type : selectedTypes) {
            names.add(type.getName());
        }
        return names;
    }

    private CnATreeElement loadPersonForLogin(String login) {
        CnATreeElement person = null;
        try {
            LoadPersonForLogin command = new LoadPersonForLogin(login);
            command = (LoadPersonForLogin)ServiceFactory.lookupCommandService().executeCommand((ICommand)command);
            person = command.getPerson();
        }
        catch (CommandException e) {
            LOG.error((Object)"Error while loading person.", (Throwable)e);
        }
        return person;
    }
}

