/*
 * Decompiled with CFR 0.152.
 */
package sernet.verinice.bpm.rcp;

import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.handlers.HandlerUtil;
import sernet.hui.common.VeriniceContext;
import sernet.verinice.bpm.rcp.CompletionAbortedException;
import sernet.verinice.bpm.rcp.TaskChangeRegistry;
import sernet.verinice.interfaces.bpm.ITask;
import sernet.verinice.interfaces.bpm.ITaskService;
import sernet.verinice.rcp.DateSelectDialog;
import sernet.verinice.rcp.RightsEnabledHandler;

public class DuedateHandler
extends RightsEnabledHandler {
    private static final Logger LOG = Logger.getLogger(DuedateHandler.class);
    Set<String> taskIdSet;
    Date oldDate;
    private Shell shell;

    public Object execute(ExecutionEvent event) throws ExecutionException {
        try {
            ISelection selection = HandlerUtil.getActiveWorkbenchWindow((ExecutionEvent)event).getActivePage().getSelection();
            if (selection != null && selection instanceof IStructuredSelection) {
                this.taskIdSet = this.getSelectedTasks(selection);
                Date duedate = this.getDate();
                this.getTaskService().setDuedate(this.taskIdSet, duedate);
                TaskChangeRegistry.tasksAdded();
            }
        }
        catch (Exception e) {
            LOG.error((Object)"Error while assigning user to task.", (Throwable)e);
        }
        return null;
    }

    private Date getDate() {
        DateSelectDialog typeDialog = new DateSelectDialog(this.shell, this.oldDate);
        if (typeDialog.open() == 0) {
            return typeDialog.getDate();
        }
        throw new CompletionAbortedException("Canceled by user.");
    }

    private Set<String> getSelectedTasks(ISelection selection) {
        HashSet<String> taskIdSet = new HashSet<String>();
        for (ITask task : (IStructuredSelection)selection) {
            taskIdSet.add(task.getId());
            this.oldDate = task.getDueDate();
        }
        return taskIdSet;
    }

    private ITaskService getTaskService() {
        return (ITaskService)VeriniceContext.get((String)"taskService");
    }

    public String getRightID() {
        return "taskchangeduedate";
    }
}

