/*
 * Decompiled with CFR 0.152.
 */
package sernet.verinice.bpm.rcp;

import java.io.Serializable;
import java.util.Hashtable;
import java.util.Map;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.preferences.ConfigurationScope;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;
import sernet.gs.ui.rcp.main.Activator;
import sernet.hui.common.VeriniceContext;
import sernet.springclient.RightsServiceClient;
import sernet.verinice.bpm.rcp.Base64Utils;
import sernet.verinice.bpm.rcp.IndividualProcessWizard;
import sernet.verinice.bpm.rcp.Messages;
import sernet.verinice.interfaces.bpm.IndividualServiceParameter;
import sernet.verinice.iso27k.rcp.ComboModel;
import sernet.verinice.iso27k.rcp.IComboModelLabelProvider;

public class DescriptionPage
extends WizardPage {
    public static final String NAME = "DESCRIPTION_PAGE";
    private static final Logger LOG = Logger.getLogger(DescriptionPage.class);
    private Combo templateCombo;
    private ComboModel<IndividualServiceParameter> templateComboModel;
    private Text text;
    private Text textArea;
    private Button deleteButton;
    private Button overwriteTemplateCheckbox;
    private Button releaseProcessCheckbox;
    private Map<String, IndividualServiceParameter> templateMap;
    private Preferences preferences;
    private Preferences bpmPreferences;
    private String elementTitle;
    private String taskTitle;
    private String taskDescription;
    private boolean overwriteTemplate = true;
    private boolean withAReleaseProcess = Activator.getDefault().getPreferenceStore().getBoolean("enable_release_process");
    private static final int PAGE_WIDTH = 600;
    private RightsServiceClient rightsService;

    protected DescriptionPage(String elementTitle) {
        super(NAME);
        this.setTitle(Messages.DescriptionPage_0);
        this.setMessage(Messages.DescriptionPage_2);
        this.elementTitle = elementTitle;
        this.setControl((Control)this.text);
        this.initComboValues();
    }

    private void addFormElements(Composite composite) {
        int pageWidthSubtrahend = 30;
        int gdHeightHint = 150;
        if (this.elementTitle != null) {
            Label objectLabel = new Label(composite, 0);
            objectLabel.setText(Messages.DescriptionPage_3);
            Label object = new Label(composite, 0);
            FontData[] fD = object.getFont().getFontData();
            int i = 0;
            while (i < fD.length) {
                fD[i].setStyle(1);
                ++i;
            }
            Font newFont = new Font((Device)this.getShell().getDisplay(), fD);
            object.setFont(newFont);
            GC gc = new GC((Drawable)object);
            Point size = gc.textExtent(this.elementTitle);
            if (size.x > 570) {
                this.elementTitle = String.valueOf(this.trimTitleByWidthSize(gc, this.elementTitle, 570)) + "...";
            }
            object.setText(this.elementTitle);
        }
        Label templateLabel = new Label(composite, 0);
        templateLabel.setText(Messages.DescriptionPage_4);
        Composite templateComposite = new Composite(composite, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        templateComposite.setLayout((Layout)layout);
        GridData gd = new GridData(4, 128, true, false);
        templateComposite.setLayoutData((Object)gd);
        this.templateCombo = new Combo(templateComposite, 2572);
        gd = new GridData(4, 128, true, false);
        this.templateCombo.setLayoutData((Object)gd);
        this.deleteButton = new Button(templateComposite, 8);
        this.deleteButton.setText(Messages.DescriptionPage_1);
        this.deleteButton.setEnabled(false);
        this.deleteButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DescriptionPage.this.deleteTemplate();
            }
        });
        this.overwriteTemplateCheckbox = new Button(composite, 32);
        this.overwriteTemplateCheckbox.setText(Messages.DescriptionPage_7);
        this.overwriteTemplateCheckbox.setSelection(true);
        this.overwriteTemplateCheckbox.setEnabled(false);
        this.overwriteTemplateCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Button checkBox = (Button)e.getSource();
                DescriptionPage.this.overwriteTemplate = checkBox.getSelection();
            }
        });
        this.templateCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DescriptionPage.this.templateComboModel.setSelectedIndex(DescriptionPage.this.templateCombo.getSelectionIndex());
                IndividualServiceParameter template = DescriptionPage.this.templateComboModel.getSelectedObject();
                ((IndividualProcessWizard)DescriptionPage.this.getWizard()).setTemplate(template);
                DescriptionPage.this.deleteButton.setEnabled(true);
                DescriptionPage.this.overwriteTemplateCheckbox.setEnabled(true);
            }
        });
        this.showComboValues();
        Label titleLabel = new Label(composite, 0);
        titleLabel.setText(Messages.DescriptionPage_5);
        this.text = new Text(composite, 2052);
        gd = new GridData(4, 128, true, false);
        this.text.setLayoutData((Object)gd);
        this.text.addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent e) {
                DescriptionPage.this.taskTitle = DescriptionPage.this.text.getText();
                DescriptionPage.this.setPageComplete(DescriptionPage.this.isValid());
            }

            public void keyPressed(KeyEvent e) {
            }
        });
        Label descriptionLabel = new Label(composite, 0);
        descriptionLabel.setText(Messages.DescriptionPage_6);
        int style = 18434;
        this.textArea = new Text(composite, style | 0x40 | 0x200);
        gd = new GridData(4, 128, true, false);
        gd.heightHint = 150;
        this.textArea.setLayoutData((Object)gd);
        this.textArea.addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent e) {
                DescriptionPage.this.taskDescription = DescriptionPage.this.textArea.getText();
                DescriptionPage.this.setPageComplete(DescriptionPage.this.isValid());
            }

            public void keyPressed(KeyEvent e) {
            }
        });
        this.releaseProcessCheckbox = new Button(composite, 32);
        this.releaseProcessCheckbox.setText(Messages.DescriptionPage_12);
        this.releaseProcessCheckbox.setToolTipText(Messages.DescriptionPage_13);
        this.releaseProcessCheckbox.setSelection(this.isWithAReleaseProcess());
        this.releaseProcessCheckbox.setEnabled(this.getRightsService().isEnabled("taskwithreleaseprocess"));
        this.releaseProcessCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Button checkBox = (Button)e.getSource();
                DescriptionPage.this.withAReleaseProcess = checkBox.getSelection();
            }
        });
    }

    public void showComboValues() {
        this.templateCombo.setItems(this.templateComboModel.getLabelArray());
        if (this.templateComboModel.isEmpty()) {
            this.templateCombo.setEnabled(false);
            this.deleteButton.setEnabled(false);
            this.overwriteTemplateCheckbox.setEnabled(false);
        }
    }

    protected void deleteTemplate() {
        try {
            IndividualServiceParameter internalTemplate = this.templateComboModel.getSelectedObject();
            if (internalTemplate != null) {
                this.getTemplateMap().remove(internalTemplate.getTitle());
                String value = Base64Utils.encode((Serializable)((Object)this.getTemplateMap()));
                this.getBpmPreferences().put("task_templates", value);
                this.getPreferences().flush();
                this.templateComboModel.removeSelected();
                this.showComboValues();
                this.deleteButton.setEnabled(false);
                this.overwriteTemplateCheckbox.setEnabled(false);
            }
        }
        catch (Exception e) {
            LOG.error((Object)"Error while deleting template", (Throwable)e);
            this.setErrorMessage(Messages.DescriptionPage_9);
        }
    }

    private void initComboValues() {
        this.templateComboModel = new ComboModel<IndividualServiceParameter>(new IComboModelLabelProvider<IndividualServiceParameter>(){

            @Override
            public String getLabel(IndividualServiceParameter template) {
                return template.getTitle();
            }
        });
        try {
            for (String name : this.getTemplateMap().keySet()) {
                this.templateComboModel.add(this.getTemplateMap().get(name));
            }
            if (!this.templateComboModel.isEmpty()) {
                this.templateComboModel.sort();
            }
        }
        catch (Exception e) {
            LOG.error((Object)"Error while loading templates", (Throwable)e);
            this.setErrorMessage(Messages.DescriptionPage_8);
            this.removeTemplatesFromPreferences();
        }
    }

    private Map<String, IndividualServiceParameter> getTemplateMap() {
        if (this.templateMap == null) {
            this.templateMap = this.loadTemplateMap();
        }
        return this.templateMap;
    }

    private Map<String, IndividualServiceParameter> loadTemplateMap() {
        String value = this.getBpmPreferences().get("task_templates", null);
        Hashtable<String, IndividualServiceParameter> map = value != null ? (Hashtable<String, IndividualServiceParameter>)Base64Utils.decode(value) : new Hashtable<String, IndividualServiceParameter>();
        return map;
    }

    public void removeTemplatesFromPreferences() {
        if (this.getBpmPreferences() != null && this.getPreferences() != null) {
            this.getBpmPreferences().remove("task_templates");
            try {
                this.getPreferences().flush();
            }
            catch (BackingStoreException e1) {
                LOG.error((Object)"Error while flushing preferences.", (Throwable)e1);
            }
        }
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(1, true);
        composite.setLayout((Layout)layout);
        GridData gd = new GridData(4, 4, true, true);
        composite.setLayoutData((Object)gd);
        this.addFormElements(composite);
        composite.pack();
        this.setControl((Control)composite);
        this.setPageComplete(false);
    }

    public boolean isValid() {
        boolean valid = true;
        this.setErrorMessage(null);
        if (this.taskTitle == null || this.taskTitle.isEmpty()) {
            valid = false;
            this.setErrorMessage(Messages.DescriptionPage_10);
        }
        if (valid && (this.taskDescription == null || this.taskDescription.isEmpty())) {
            valid = false;
            this.setErrorMessage(Messages.DescriptionPage_11);
        }
        return valid;
    }

    public boolean isPageComplete() {
        boolean complete = super.isPageComplete();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("page complete: " + complete));
        }
        return complete;
    }

    private String trimTitleByWidthSize(GC gc, String elementTitle, int width) {
        String newTitle = elementTitle.substring(0, elementTitle.length() - 1);
        Point size = gc.textExtent(String.valueOf(newTitle) + "...");
        if (size.x > width) {
            newTitle = this.trimTitleByWidthSize(gc, newTitle, width);
        }
        return newTitle;
    }

    public String getTaskTitle() {
        return this.taskTitle;
    }

    public String getTaskDescription() {
        return this.taskDescription;
    }

    public void setTaskTitle(String taskTitle) {
        this.taskTitle = taskTitle;
        this.text.setText(taskTitle);
        this.setPageComplete(this.isValid());
    }

    public void setTaskDescription(String taskDescription) {
        this.taskDescription = taskDescription;
        this.textArea.setText(taskDescription);
        this.setPageComplete(this.isValid());
    }

    public boolean isOverwriteTemplate() {
        return this.overwriteTemplate;
    }

    public Preferences getPreferences() {
        if (this.preferences == null) {
            this.preferences = ConfigurationScope.INSTANCE.getNode("sernet.gs.ui.rcp.main");
        }
        return this.preferences;
    }

    public Preferences getBpmPreferences() {
        if (this.bpmPreferences == null) {
            this.bpmPreferences = this.getPreferences().node("bpm");
        }
        return this.bpmPreferences;
    }

    public RightsServiceClient getRightsService() {
        if (this.rightsService == null) {
            this.rightsService = (RightsServiceClient)VeriniceContext.get((String)"rightsService");
        }
        return this.rightsService;
    }

    public void setReleaseProcessSelected(boolean releaseProcessCheckboxSelected) {
        this.releaseProcessCheckbox.setEnabled(this.getRightsService().isEnabled("taskwithreleaseprocess"));
        this.releaseProcessCheckbox.setSelection(this.releaseProcessCheckbox.isEnabled() && releaseProcessCheckboxSelected);
        this.withAReleaseProcess = this.releaseProcessCheckbox.getSelection();
    }

    public boolean isWithAReleaseProcess() {
        return this.withAReleaseProcess;
    }

    public void disableTemplatesAndReleaseProcessCheckbox() {
        this.templateCombo.setEnabled(false);
        this.deleteButton.setEnabled(false);
        this.releaseProcessCheckbox.setEnabled(false);
    }
}

