/*
 * Decompiled with CFR 0.152.
 */
package sernet.verinice.bpm.rcp;

import java.time.LocalDate;
import java.time.temporal.ChronoUnit;
import org.apache.log4j.Logger;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DateTime;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import sernet.verinice.bpm.rcp.Messages;
import sernet.verinice.bpm.rcp.PersonPage;
import sernet.verinice.bpm.rcp.RelationPage;

public class DatePage
extends WizardPage {
    private static final Logger logger = Logger.getLogger(DatePage.class);
    public static final String NAME = "DATE_PAGE";
    public static final String ASSIGNEE_SELECTION_DIRECT = "ASSIGNEE_SELECTION_DIRECT";
    public static final String ASSIGNEE_SELECTION_RELATION = "ASSIGNEE_SELECTION_RELATION";
    private DateTime datePicker;
    private LocalDate dueDate;
    private Combo periodCombo;
    private Button[] radios = new Button[2];
    private Integer periodDays;
    private static final int MAX_PERIOD = 30;
    private static final int DEFAULT_PERIOD = 7;
    private String assigneeSelectionMode = "ASSIGNEE_SELECTION_DIRECT";
    private boolean isRelation = true;

    protected DatePage() {
        super(NAME);
        this.setTitle(Messages.DatePage_3);
        this.setMessage(Messages.DatePage_4);
        this.setControl((Control)this.datePicker);
    }

    public DatePage(boolean relation) {
        this();
        this.isRelation = relation;
    }

    private void addFormElements(Composite composite) {
        Label dueDateLabel = new Label(composite, 0);
        dueDateLabel.setText(Messages.DatePage_5);
        this.datePicker = new DateTime(composite, 1024);
        GridData gd = new GridData(4, 128, true, false);
        this.datePicker.setLayoutData((Object)gd);
        this.datePicker.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LocalDate newDueDate = LocalDate.of(DatePage.this.datePicker.getYear(), DatePage.this.datePicker.getMonth() + 1, DatePage.this.datePicker.getDay());
                if (newDueDate.isAfter(LocalDate.now())) {
                    DatePage.this.dueDate = newDueDate;
                    int diff = (int)ChronoUnit.DAYS.between(LocalDate.now(), DatePage.this.dueDate);
                    int newMaxPeriod = Math.min(diff, 30);
                    if (newMaxPeriod != DatePage.this.periodCombo.getItemCount()) {
                        DatePage.this.periodCombo.setItems(DatePage.createPeriodArray(newMaxPeriod));
                        DatePage.this.periodCombo.pack();
                    }
                    int newPeriodDays = Math.min(newMaxPeriod, DatePage.this.periodDays);
                    DatePage.this.setPeriod(newPeriodDays);
                } else {
                    DatePage.this.datePicker.setDate(DatePage.this.dueDate.getYear(), DatePage.this.dueDate.getMonthValue() - 1, DatePage.this.dueDate.getDayOfMonth());
                }
                DatePage.this.setPageComplete(DatePage.this.isValid());
            }
        });
        Label periodLabel = new Label(composite, 0);
        periodLabel.setText(Messages.DatePage_6);
        this.periodCombo = new Combo(composite, 2572);
        String[] selectablePeriods = DatePage.createPeriodArray(7);
        this.periodCombo.setItems(selectablePeriods);
        int defaultPeriodIndex = 6;
        this.periodDays = 7;
        this.periodCombo.select(defaultPeriodIndex);
        this.periodCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DatePage.this.periodDays = DatePage.this.periodCombo.getSelectionIndex() + 1;
                DatePage.this.setPageComplete(DatePage.this.isValid());
            }
        });
        this.dueDate = LocalDate.now().plusDays(this.periodDays.intValue());
        this.datePicker.setDate(this.dueDate.getYear(), this.dueDate.getMonthValue() - 1, this.dueDate.getDayOfMonth());
        if (this.isRelation) {
            this.radios[0] = new Button(composite, 16);
            this.radios[0].setLayoutData((Object)new GridData(4, 128, true, false));
            this.radios[0].setText(Messages.DatePage_7);
            this.radios[0].setSelection(true);
            this.radios[0].addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    DatePage.this.radios[1].setSelection(!DatePage.this.radios[0].getSelection());
                    if (DatePage.this.radios[0].getSelection()) {
                        DatePage.this.assigneeSelectionMode = DatePage.ASSIGNEE_SELECTION_DIRECT;
                    }
                }
            });
            this.radios[1] = new Button(composite, 16);
            this.radios[1].setLayoutData((Object)new GridData(4, 128, true, false));
            this.radios[1].setText(Messages.DatePage_8);
            this.radios[1].setSelection(false);
            this.radios[1].addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    DatePage.this.radios[0].setSelection(!DatePage.this.radios[1].getSelection());
                    if (DatePage.this.radios[1].getSelection()) {
                        DatePage.this.assigneeSelectionMode = DatePage.ASSIGNEE_SELECTION_RELATION;
                    }
                }
            });
            this.setRelationModeRadios();
        }
    }

    public IWizardPage getNextPage() {
        RelationPage relationPage = (RelationPage)this.getWizard().getPage("RELATION_PAGE");
        PersonPage personPage = (PersonPage)this.getWizard().getPage("PERSON_PAGE");
        if (ASSIGNEE_SELECTION_RELATION.equals(this.assigneeSelectionMode)) {
            personPage.setActive(false);
            relationPage.setActive(true);
            return relationPage;
        }
        relationPage.setActive(false);
        personPage.setActive(true);
        return personPage;
    }

    public void createControl(Composite parent) {
        int defaultMarginWidthHeight = 10;
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(1, true);
        layout.marginWidth = 10;
        composite.setLayout((Layout)layout);
        GridData gd = new GridData(4, 4, true, true);
        composite.setLayoutData((Object)gd);
        this.addFormElements(composite);
        composite.pack();
        this.setControl((Control)composite);
        this.setPageComplete(false);
    }

    public boolean isValid() {
        this.setErrorMessage(null);
        if (this.dueDate == null) {
            this.setErrorMessage(Messages.DatePage_9);
            return false;
        }
        if (this.dueDate.isBefore(LocalDate.now())) {
            this.setErrorMessage(Messages.DatePage_10);
            return false;
        }
        LocalDate reminderDate = this.dueDate.minusDays(this.periodDays.intValue());
        if (reminderDate.isBefore(LocalDate.now())) {
            this.setErrorMessage(Messages.DatePage_11);
            return false;
        }
        return true;
    }

    public boolean isPageComplete() {
        boolean complete = super.isPageComplete();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("page complete: " + complete));
        }
        return complete;
    }

    private static String[] createPeriodArray(int maxPeriod) {
        String[] periodArray = new String[maxPeriod];
        int i = 0;
        while (i < periodArray.length) {
            periodArray[i] = String.valueOf(i + 1);
            ++i;
        }
        return periodArray;
    }

    public LocalDate getDueDate() {
        return this.dueDate;
    }

    public Integer getPeriod() {
        return this.periodDays;
    }

    public void setDueDate(LocalDate dueDate) {
        this.dueDate = dueDate;
        this.datePicker.setDate(dueDate.getYear(), dueDate.getMonthValue() - 1, dueDate.getDayOfMonth());
        this.setPageComplete(this.isValid());
    }

    public void setPeriod(Integer period) {
        this.periodDays = period;
        int selectionIndex = period - 1;
        this.periodCombo.select(selectionIndex);
        this.setPageComplete(this.isValid());
    }

    public String getAssigneeSelectionMode() {
        return this.assigneeSelectionMode;
    }

    public void setAssigneeSelectionMode(String assigneeSelectionMode) {
        this.assigneeSelectionMode = assigneeSelectionMode;
        this.setRelationModeRadios();
    }

    public void setRelationModeRadios() {
        if (this.radios[0] != null && this.radios[1] != null) {
            if (ASSIGNEE_SELECTION_DIRECT.equals(this.assigneeSelectionMode)) {
                this.radios[0].setSelection(true);
                this.radios[1].setSelection(false);
            } else if (ASSIGNEE_SELECTION_RELATION.equals(this.assigneeSelectionMode)) {
                this.radios[1].setSelection(true);
                this.radios[0].setSelection(false);
            }
        }
    }
}

