/*
 * Decompiled with CFR 0.152.
 */
package sernet.verinice.bpm.rcp;

import java.util.Map;
import org.apache.log4j.Logger;
import org.eclipse.swt.widgets.Shell;
import sernet.gs.service.NotifyingThread;
import sernet.gs.ui.rcp.main.Activator;
import sernet.gs.ui.rcp.main.service.ServiceFactory;
import sernet.verinice.bpm.CompleteHandlerRegistry;
import sernet.verinice.bpm.ICompleteClientHandler;
import sernet.verinice.interfaces.bpm.ITask;
import sernet.verinice.interfaces.bpm.ITaskService;
import sernet.verinice.model.bpm.TaskInformation;

final class CompleteTaskJob
extends NotifyingThread {
    private static final Logger LOG = Logger.getLogger(CompleteTaskJob.class);
    private TaskInformation task;
    private String outcomeId;
    private Shell shell;

    public CompleteTaskJob() {
    }

    public CompleteTaskJob(TaskInformation task, String outcomeId, Shell shell) {
        this.task = task;
        this.outcomeId = outcomeId;
        this.shell = shell;
    }

    public void doRun() {
        this.completeTask();
    }

    public void completeTask() {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Completing task...");
        }
        Activator.inheritVeriniceContextState();
        String type = this.task.getType();
        ICompleteClientHandler handler = CompleteHandlerRegistry.getHandler(type + "." + this.outcomeId);
        Map<String, Object> parameter = null;
        if (handler != null) {
            handler.setShell(this.getShell());
            parameter = handler.execute((ITask)this.task);
        }
        if (this.outcomeId == null) {
            this.getTaskService().completeTask(this.task.getId());
        } else {
            this.getTaskService().completeTask(this.task.getId(), this.outcomeId, parameter);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Task completing finished.");
        }
    }

    private ITaskService getTaskService() {
        return ServiceFactory.lookupTaskService();
    }

    private Shell getShell() {
        return this.shell;
    }
}

