/*
 * Decompiled with CFR 0.152.
 */
package sernet.verinice.bpm.rcp;

import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;
import org.eclipse.jface.action.Action;
import sernet.gs.service.IThreadCompleteListener;
import sernet.hui.common.VeriniceContext;
import sernet.verinice.bpm.rcp.CompleteTaskJob;
import sernet.verinice.bpm.rcp.Messages;
import sernet.verinice.bpm.rcp.TaskView;
import sernet.verinice.interfaces.bpm.ITask;
import sernet.verinice.interfaces.bpm.ITaskService;
import sernet.verinice.model.bpm.TaskInformation;

final class CompleteTaskAction
extends Action {
    private static final Logger LOG = Logger.getLogger(CompleteTaskAction.class);
    private final TaskView taskView;
    final String id = String.valueOf(TaskView.class.getName()) + ".complete";
    String outcomeId;
    private ExecutorService executer;

    public CompleteTaskAction(TaskView taskView, String outcomeId) {
        this.taskView = taskView;
        this.outcomeId = outcomeId;
        this.setId(String.valueOf(this.id) + "." + outcomeId);
    }

    public void run() {
        try {
            this.executer = Executors.newFixedThreadPool(2);
            List<TaskInformation> taskList = this.taskView.getSelectedTasks();
            for (TaskInformation task : taskList) {
                if ("indi.trans.accept".equals(this.outcomeId) && task.isWithAReleaseProcess()) {
                    this.getTaskService().saveChangedElementPropertiesToCnATreeElement(task.getId(), task.getUuid());
                    this.taskView.closeEditorForElement(task.getUuid());
                }
                this.completeTask(task, this.outcomeId);
            }
            this.setEnabled(false);
            this.executer.shutdown();
        }
        catch (Exception t) {
            LOG.error((Object)"Error while completing tasks.", (Throwable)t);
            this.shutdownAndAwaitTermination();
            this.taskView.showError(Messages.CompleteTaskAction_6, Messages.CompleteTaskAction_7);
        }
    }

    protected void completeTask(final TaskInformation task, String outcomeId) {
        CompleteTaskJob job = new CompleteTaskJob(task, outcomeId, this.taskView.getSite().getShell());
        job.addListener(new IThreadCompleteListener(){

            public void notifyOfThreadComplete(Thread thread) {
                CompleteTaskAction.this.taskView.removeTask((ITask)task);
            }
        });
        this.executer.execute((Runnable)((Object)job));
    }

    private void shutdownAndAwaitTermination() {
        this.executer.shutdown();
        try {
            if (!this.executer.awaitTermination(10L, TimeUnit.SECONDS)) {
                this.executer.shutdownNow();
                if (!this.executer.awaitTermination(10L, TimeUnit.SECONDS)) {
                    LOG.error((Object)"Task loader (ExecutorService) shutdown failed.");
                }
            }
        }
        catch (InterruptedException ie) {
            this.executer.shutdownNow();
            Thread.currentThread().interrupt();
        }
    }

    private ITaskService getTaskService() {
        return (ITaskService)VeriniceContext.get((String)"taskService");
    }
}

