/*
 * Decompiled with CFR 0.152.
 */
package sernet.verinice.bpm.rcp;

import java.sql.Date;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import sernet.gs.service.RetrieveInfo;
import sernet.hui.common.VeriniceContext;
import sernet.hui.common.connect.EntityType;
import sernet.hui.common.connect.HUITypeFactory;
import sernet.hui.common.connect.PropertyType;
import sernet.hui.common.multiselectionlist.OptionSelectionHelper;
import sernet.snutils.AssertException;
import sernet.snutils.FormInputParser;
import sernet.verinice.bpm.rcp.Messages;
import sernet.verinice.interfaces.CommandException;
import sernet.verinice.interfaces.ICommand;
import sernet.verinice.interfaces.ICommandService;
import sernet.verinice.interfaces.bpm.ITask;
import sernet.verinice.interfaces.bpm.ITaskService;
import sernet.verinice.model.bp.risk.configuration.RiskConfiguration;
import sernet.verinice.model.common.CnATreeElement;
import sernet.verinice.service.bp.risk.RiskService;
import sernet.verinice.service.commands.LoadAncestors;

public class CompareChangedElementPropertiesDialog
extends TitleAreaDialog {
    private static final Logger LOG = Logger.getLogger(CompareChangedElementPropertiesDialog.class);
    private static final int DIALOG_WIDTH = 1000;
    private static final int DIALOG_HEIGHT = 450;
    private static final Set<String> PROPERTY_IDS_FREQUENCY_OF_OCCURRENCE = Stream.of("bp_threat_risk_without_safeguards_frequency", "bp_threat_risk_without_additional_safeguards_frequency", "bp_threat_risk_with_additional_safeguards_frequency").collect(Collectors.toSet());
    private static final Set<String> PROPERTY_IDS_EFFECT = Stream.of("bp_threat_risk_without_safeguards_impact", "bp_threat_risk_without_additional_safeguards_impact", "bp_threat_risk_with_additional_safeguards_impact").collect(Collectors.toSet());
    private static final Set<String> PROPERTY_IDS_RISK_CATEGORY = Stream.of("bp_threat_risk_without_safeguards_risk", "bp_threat_risk_without_additional_safeguards_risk", "bp_threat_risk_with_additional_safeguards_risk").collect(Collectors.toSet());
    private String title;
    private final ITask task;
    private CnATreeElement element;
    private Map<String, String> changedElementProperties;

    public CompareChangedElementPropertiesDialog(Shell parentShell, ITask task) throws CommandException {
        super(parentShell);
        this.task = task;
        RetrieveInfo ri = RetrieveInfo.getPropertyInstance();
        LoadAncestors loadControl = new LoadAncestors(task.getElementType(), task.getUuid(), ri);
        loadControl = (LoadAncestors)this.getCommandService().executeCommand((ICommand)loadControl);
        this.element = loadControl.getElement();
        this.loadChangedElementPropertiesFromTask();
        int style = 1120;
        style = style | 0x800 | 0x10000;
        this.setShellStyle(style | 0x10);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setSize(1000, 450);
        newShell.setText(Messages.NewQmIssueDialog_9);
    }

    protected Control createDialogArea(Composite parent) {
        int defaultMarginWidth = 10;
        this.setTitle(Messages.CompareTaskChangesAction_1);
        if (this.changedElementProperties.isEmpty()) {
            this.setMessage(Messages.bind((String)Messages.CompareTaskChangesAction_6, (Object)this.task.getElementTitle()));
        } else {
            this.setMessage(Messages.bind((String)Messages.CompareTaskChangesAction_2, (Object)this.task.getElementTitle()));
        }
        Composite composite = (Composite)super.createDialogArea(parent);
        GridLayout layout = (GridLayout)composite.getLayout();
        layout.marginWidth = 10;
        GridData gd = new GridData(4, 4, true, true);
        composite.setLayoutData((Object)gd);
        ScrolledComposite scrolledComposite = new ScrolledComposite(composite, 512);
        scrolledComposite.setLayoutData((Object)new GridData(1808));
        scrolledComposite.setExpandHorizontal(true);
        Composite innerComposite = new Composite((Composite)scrolledComposite, 0);
        scrolledComposite.setContent((Control)innerComposite);
        innerComposite.setLayoutData((Object)new GridData(4, 4, true, false));
        innerComposite.setLayout((Layout)new GridLayout(1, false));
        this.addFormElements(innerComposite);
        scrolledComposite.setVisible(true);
        Point size = innerComposite.computeSize(-1, -1);
        innerComposite.setSize(size);
        Label separator = new Label(composite, 258);
        separator.setLayoutData((Object)new GridData(768));
        composite.pack();
        this.setDialogLocation();
        return composite;
    }

    private void addFormElements(Composite composite) {
        int dialogWidthSubtrahend = 30;
        if (this.title != null) {
            Label titleLabel = new Label(composite, 0);
            FontData[] fD = titleLabel.getFont().getFontData();
            int i = 0;
            while (i < fD.length) {
                fD[i].setStyle(1);
                ++i;
            }
            Font newFont = new Font((Device)this.getShell().getDisplay(), fD);
            titleLabel.setFont(newFont);
            GC gc = new GC((Drawable)titleLabel);
            Point size = gc.textExtent(this.title);
            if (size.x > 970) {
                this.title = String.valueOf(this.trimTitleByWidthSize(gc, this.title, 970)) + "...";
            }
            titleLabel.setText(this.title);
        }
        if (!this.changedElementProperties.isEmpty()) {
            this.createGridComposite(composite);
        }
    }

    private String trimTitleByWidthSize(GC gc, String elementTitle, int width) {
        String newTitle = elementTitle.substring(0, elementTitle.length() - 1);
        Point size = gc.textExtent(String.valueOf(newTitle) + "...");
        if (size.x > width) {
            newTitle = this.trimTitleByWidthSize(gc, newTitle, width);
        }
        return newTitle;
    }

    private void createGridComposite(Composite parent) {
        GridLayout compositeLayout = new GridLayout(3, false);
        compositeLayout.marginWidth = 5;
        parent.setLayout((Layout)compositeLayout);
        this.createGridCompositeHeader(parent);
        this.createGridCompositeData(parent);
        parent.pack();
    }

    private void createGridCompositeHeader(Composite parent) {
        Label fealdNameHeaderLabel = new Label(parent, 0);
        fealdNameHeaderLabel.setLayoutData((Object)new GridData(1808));
        fealdNameHeaderLabel.setText(Messages.CompareTaskChangesAction_3);
        Label fealdOldHeaderLabel = new Label(parent, 0);
        fealdOldHeaderLabel.setLayoutData((Object)new GridData(1808));
        fealdOldHeaderLabel.setText(Messages.CompareTaskChangesAction_4);
        Label fealdNewHeaderLabel = new Label(parent, 0);
        fealdNewHeaderLabel.setLayoutData((Object)new GridData(1808));
        fealdNewHeaderLabel.setText(Messages.CompareTaskChangesAction_5);
    }

    private void createGridCompositeData(Composite parent) {
        HUITypeFactory typeFactory = HUITypeFactory.getInstance();
        EntityType entityType = typeFactory.getEntityType(this.element.getEntity().getEntityType());
        List propertyTypes = entityType.getAllPropertyTypesSorted();
        for (PropertyType propertyType : propertyTypes) {
            String newValueDisplay;
            String oldValue;
            RiskConfiguration riskConfiguration;
            if (!this.changedElementProperties.containsKey(propertyType.getId())) continue;
            String propertyId = propertyType.getId();
            String newValue = this.changedElementProperties.get(propertyType.getId());
            if (PROPERTY_IDS_FREQUENCY_OF_OCCURRENCE.contains(propertyId)) {
                riskConfiguration = this.getRiskConfiguration();
                oldValue = this.getDisplayValueForRiskPropertyValue(this.element.getEntity().getRawPropertyValue(propertyId), arg_0 -> ((RiskConfiguration)riskConfiguration).getLabelForFrequency(arg_0));
                newValueDisplay = this.getDisplayValueForRiskPropertyValue(newValue, arg_0 -> ((RiskConfiguration)riskConfiguration).getLabelForFrequency(arg_0));
            } else if (PROPERTY_IDS_EFFECT.contains(propertyId)) {
                riskConfiguration = this.getRiskConfiguration();
                oldValue = this.getDisplayValueForRiskPropertyValue(this.element.getEntity().getRawPropertyValue(propertyId), arg_0 -> ((RiskConfiguration)riskConfiguration).getLabelForImpact(arg_0));
                newValueDisplay = this.getDisplayValueForRiskPropertyValue(newValue, arg_0 -> ((RiskConfiguration)riskConfiguration).getLabelForImpact(arg_0));
            } else if (PROPERTY_IDS_RISK_CATEGORY.contains(propertyId)) {
                riskConfiguration = this.getRiskConfiguration();
                oldValue = this.getDisplayValueForRiskPropertyValue(this.element.getEntity().getRawPropertyValue(propertyId), arg_0 -> ((RiskConfiguration)riskConfiguration).getLabelForRisk(arg_0));
                newValueDisplay = this.getDisplayValueForRiskPropertyValue(newValue, arg_0 -> ((RiskConfiguration)riskConfiguration).getLabelForRisk(arg_0));
            } else {
                oldValue = this.element.getPropertyValue(propertyType.getId());
                newValueDisplay = propertyType.isReference() ? this.loadTextForReferenceProperty(propertyType, newValue) : (propertyType.isSingleSelect() || propertyType.isMultiselect() ? this.loadTextForOptionProperty(propertyType, newValue) : (propertyType.isDate() ? this.getDate(newValue) : newValue));
            }
            if (!StringUtils.isNotBlank((String)oldValue) && !StringUtils.isNotBlank((String)newValue)) continue;
            this.createLabelForProperty(parent, typeFactory, propertyType);
            this.createTextForOldValue(parent, propertyType, oldValue);
            this.createTextForNewValue(parent, propertyType, newValueDisplay);
        }
    }

    protected String getDisplayValueForRiskPropertyValue(String rawValue, UnaryOperator<String> valueMapper) {
        if (StringUtils.isEmpty((String)rawValue)) {
            return sernet.hui.swt.widgets.Messages.getString((String)"SingleSelectDummyValue");
        }
        return (String)valueMapper.apply(rawValue);
    }

    private void createLabelForProperty(Composite parent, HUITypeFactory typeFactory, PropertyType propertyType) {
        Label titleLabel = new Label(parent, 0);
        titleLabel.setLayoutData((Object)new GridData(1808));
        titleLabel.setText(typeFactory.getMessage(propertyType.getId()));
    }

    private void createTextForOldValue(Composite parent, PropertyType propertyType, String oldValue) {
        if (propertyType.isSingleSelect() && StringUtils.isEmpty((String)oldValue)) {
            oldValue = sernet.hui.swt.widgets.Messages.getString((String)"SingleSelectDummyValue");
        }
        Text oldText = new Text(parent, 2112);
        oldText.setEditable(false);
        oldText.setText(oldValue);
        GridData gridData = new GridData(1808);
        gridData.widthHint = 333;
        oldText.setLayoutData((Object)gridData);
    }

    private void createTextForNewValue(Composite parent, PropertyType propertyType, String value) {
        Text newText = new Text(parent, 2112);
        newText.setEditable(false);
        newText.setText(value);
        GridData gridData = new GridData(1808);
        gridData.widthHint = 333;
        newText.setLayoutData((Object)gridData);
    }

    private String getDate(String value) {
        try {
            return FormInputParser.dateToString((Date)new Date(Long.parseLong(value)));
        }
        catch (NumberFormatException | AssertException e) {
            LOG.error((Object)"Invalid date", e);
            return value;
        }
    }

    private String loadTextForOptionProperty(PropertyType propertyType, String newValue) {
        if (propertyType.isSingleSelect() && StringUtils.isEmpty((String)newValue)) {
            return sernet.hui.swt.widgets.Messages.getString((String)"SingleSelectDummyValue");
        }
        String[] propertyOptions = newValue.split(",");
        return OptionSelectionHelper.loadOptionLabels((PropertyType)propertyType, Arrays.asList(propertyOptions));
    }

    private RiskConfiguration getRiskConfiguration() {
        RiskService riskService = (RiskService)VeriniceContext.get((String)"itbpRiskService");
        return riskService.findRiskConfigurationOrDefault(this.element.getScopeId());
    }

    private String loadTextForReferenceProperty(PropertyType propertyType, String newValue) {
        String[] propertyOptions = newValue.split(",");
        return OptionSelectionHelper.loadReferenceLabels((PropertyType)propertyType, Arrays.asList(propertyOptions));
    }

    private void setDialogLocation() {
        Rectangle monitorArea = this.getShell().getDisplay().getPrimaryMonitor().getBounds();
        Rectangle shellArea = this.getShell().getBounds();
        int x = monitorArea.x + (monitorArea.width - shellArea.width) / 2;
        int y = monitorArea.y + (monitorArea.height - shellArea.height) / 2;
        this.getShell().setLocation(x, y);
    }

    private void loadChangedElementPropertiesFromTask() {
        this.changedElementProperties = this.getTaskService().loadChangedElementProperties(this.task.getId());
        LOG.info((Object)"Loaded changes for element properties from task.");
    }

    private ITaskService getTaskService() {
        return (ITaskService)VeriniceContext.get((String)"taskService");
    }

    public ICommandService getCommandService() {
        return (ICommandService)VeriniceContext.get((String)"commandService");
    }

    protected Button createButton(Composite parent, int id, String label, boolean defaultButton) {
        if (id == 1) {
            return null;
        }
        return super.createButton(parent, id, label, defaultButton);
    }
}

