/*
 * Decompiled with CFR 0.152.
 */
package sernet.verinice.bpm.rcp;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.log4j.Logger;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.handlers.HandlerUtil;
import sernet.gs.ui.rcp.main.bsi.dialogs.CnATreeElementSelectionDialog;
import sernet.gs.ui.rcp.main.service.ServiceFactory;
import sernet.hui.common.VeriniceContext;
import sernet.verinice.bpm.rcp.TaskChangeRegistry;
import sernet.verinice.interfaces.ICommand;
import sernet.verinice.interfaces.bpm.ITask;
import sernet.verinice.interfaces.bpm.ITaskService;
import sernet.verinice.model.common.CnATreeElement;
import sernet.verinice.model.common.Domain;
import sernet.verinice.model.common.DomainSpecificElementUtil;
import sernet.verinice.model.common.configuration.Configuration;
import sernet.verinice.rcp.RightsEnabledHandler;
import sernet.verinice.service.commands.CnATypeMapper;
import sernet.verinice.service.commands.LoadConfiguration;

public class AssignHandler
extends RightsEnabledHandler {
    private static final Logger LOG = Logger.getLogger(AssignHandler.class);

    public Object execute(ExecutionEvent event) throws ExecutionException {
        try {
            ISelection selection = HandlerUtil.getActiveWorkbenchWindow((ExecutionEvent)event).getActivePage().getSelection();
            if (selection instanceof IStructuredSelection) {
                List<CnATreeElement> userList;
                Shell shell = HandlerUtil.getActiveWorkbenchWindow((ExecutionEvent)event).getShell();
                Set<ITask> taskSet = this.getSelectedTasks((IStructuredSelection)selection);
                Domain domain = CnATypeMapper.getDomainFromTypeId((String)taskSet.iterator().next().getElementType());
                String type = DomainSpecificElementUtil.getPersonTypeIdFromDomain((Domain)domain);
                CnATreeElementSelectionDialog dialog = new CnATreeElementSelectionDialog(shell, type, null);
                dialog.setShowScopeCheckbox(false);
                if (dialog.open() == 0 && (userList = dialog.getSelectedElements()).size() == 1) {
                    CnATreeElement element = userList.get(0);
                    LoadConfiguration command = new LoadConfiguration(element);
                    command = (LoadConfiguration)ServiceFactory.lookupCommandService().executeCommand((ICommand)command);
                    Configuration configuration = command.getConfiguration();
                    if (configuration != null) {
                        Set taskIdSet = taskSet.stream().map(ITask::getId).collect(Collectors.toSet());
                        this.getTaskService().setAssignee(taskIdSet, configuration.getUser());
                        this.getTaskService().setAssigneeVar(taskIdSet, configuration.getUser());
                        TaskChangeRegistry.tasksAdded();
                    } else {
                        MessageDialog.openWarning((Shell)shell, (String)"Warning", (String)"Can not set assign person. No account data is set.");
                    }
                }
            }
        }
        catch (Exception e) {
            LOG.error((Object)"Error while assigning user to task.", (Throwable)e);
        }
        return null;
    }

    private Set<ITask> getSelectedTasks(IStructuredSelection selection) {
        HashSet<ITask> taskSet = new HashSet<ITask>(selection.size());
        for (ITask task : selection) {
            taskSet.add(task);
        }
        return taskSet;
    }

    private ITaskService getTaskService() {
        return (ITaskService)VeriniceContext.get((String)"taskService");
    }

    public String getRightID() {
        return "taskchangeassignee";
    }
}

