/*
 * Decompiled with CFR 0.152.
 */
package sernet.verinice.bp.rcp.risk.ui;

import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Control;
import sernet.gs.service.StringUtil;
import sernet.hui.common.connect.HUITypeFactory;
import sernet.hui.swt.widgets.HitroUIComposite;
import sernet.verinice.bp.rcp.risk.ui.Messages;
import sernet.verinice.model.bp.elements.BpThreat;

public final class ValidateRiskPropertyValues
extends SelectionAdapter {
    private final BpThreat element;
    private final HitroUIComposite huiComposite;
    private List<Runnable> validators;

    public ValidateRiskPropertyValues(HitroUIComposite huiComposite, BpThreat threat) {
        this.huiComposite = huiComposite;
        this.element = threat;
        this.validators = Stream.of(this.createValidator("bp_threat_risk_without_additional_safeguards_frequency", "bp_threat_risk_without_safeguards_frequency"), this.createValidator("bp_threat_risk_without_additional_safeguards_impact", "bp_threat_risk_without_safeguards_impact"), this.createValidator("bp_threat_risk_without_additional_safeguards_risk", "bp_threat_risk_without_safeguards_risk"), this.createValidator("bp_threat_risk_with_additional_safeguards_frequency", "bp_threat_risk_without_additional_safeguards_frequency"), this.createValidator("bp_threat_risk_with_additional_safeguards_impact", "bp_threat_risk_without_additional_safeguards_impact"), this.createValidator("bp_threat_risk_with_additional_safeguards_risk", "bp_threat_risk_without_additional_safeguards_risk")).collect(Collectors.toList());
        this.validators.forEach(Runnable::run);
    }

    private Runnable createValidator(String property, String compareProperty) {
        Control control = this.huiComposite.getField(property);
        String comparePropertyGroupLabel = HUITypeFactory.getInstance().getPropertyGroup("bp_threat", compareProperty).getName();
        ControlDecoration decorator = ValidateRiskPropertyValues.createLabelFieldDecoration(control, Messages.bind((String)Messages.warningRiskPropertyExceedance, (Object)comparePropertyGroupLabel));
        return () -> this.updateDecoratorVisibility(decorator, property, compareProperty);
    }

    public void widgetSelected(SelectionEvent e) {
        this.validators.forEach(Runnable::run);
    }

    private void updateDecoratorVisibility(ControlDecoration decorator, String property, String compareProperty) {
        String value = StringUtil.replaceEmptyStringByNull((String)this.element.getEntity().getRawPropertyValue(property));
        String compareValue = StringUtil.replaceEmptyStringByNull((String)this.element.getEntity().getRawPropertyValue(compareProperty));
        if (value != null && compareValue != null && value.compareTo(compareValue) > 0) {
            decorator.show();
        } else {
            decorator.hide();
        }
    }

    private static ControlDecoration createLabelFieldDecoration(Control contol, String descriptionText) {
        ControlDecoration txtDecorator = new ControlDecoration(contol, 131200);
        FieldDecoration fieldDecoration = FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_WARNING");
        Image img = fieldDecoration.getImage();
        txtDecorator.setImage(img);
        txtDecorator.setDescriptionText(descriptionText);
        return txtDecorator;
    }
}

