/*
 * Decompiled with CFR 0.152.
 */
package sernet.verinice.bp.rcp.risk.ui;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.Stack;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.jface.layout.RowLayoutFactory;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import sernet.verinice.bp.rcp.risk.ui.Messages;
import sernet.verinice.model.bp.risk.RiskPropertyValue;

public abstract class StackConfigurator<T extends RiskPropertyValue>
extends Composite {
    public static final int ELEMENT_SPACING = 10;
    public static final int ELEMENT_MARGINS = 25;
    public static final int LABEL_WIDTH = 180;
    private Composite pane;
    private int maxValues;
    private int numberOfNewElements;
    private Stack<T> deletedRows;
    protected LinkedHashMap<String, T> editorState;
    private final Runnable fireProperyChange;

    public StackConfigurator(Composite parent, int maxValues, List<T> values, Runnable fireProperyChange) {
        super(parent, 0);
        this.maxValues = maxValues;
        this.setEditorState(values);
        this.fireProperyChange = fireProperyChange;
        this.reset();
        this.refresh();
    }

    public void reset() {
        this.numberOfNewElements = 0;
        this.deletedRows = new Stack();
    }

    public List<T> getDeleted() {
        return this.deletedRows;
    }

    public List<T> getEditorState() {
        return new ArrayList<T>(this.editorState.values());
    }

    public void setEditorState(List<T> values) {
        if (this.editorState != null) {
            Set newKeys = values.stream().map(RiskPropertyValue::getId).collect(Collectors.toSet());
            List cutEntries = this.editorState.entrySet().stream().filter(x -> !newKeys.contains(x.getKey())).map(Map.Entry::getValue).collect(Collectors.toList());
            this.deletedRows.addAll(cutEntries);
        }
        this.editorState = new LinkedHashMap(values.size());
        values.stream().forEach(value -> {
            RiskPropertyValue riskPropertyValue = this.editorState.put(value.getId(), value);
        });
    }

    public void refresh() {
        if (this.pane != null) {
            this.pane.dispose();
        }
        this.setLayout((Layout)new GridLayout(1, true));
        this.pane = new Composite((Composite)this, 0);
        this.pane.setLayout((Layout)new RowLayout(512));
        List<T> rowData = this.getEditorState();
        int i = 0;
        while (i < rowData.size()) {
            Composite rowComposite = new Composite(this.pane, 0);
            rowComposite.setLayout((Layout)RowLayoutFactory.createFrom((RowLayout)new RowLayout(256)).spacing(10).create());
            Composite dataComposite = new Composite(rowComposite, 0);
            dataComposite.setLayout((Layout)new FillLayout());
            Composite buttonComposite = new Composite(rowComposite, 0);
            buttonComposite.setLayout((Layout)RowLayoutFactory.createFrom((RowLayout)new RowLayout(512)).spacing(10).create());
            this.addRow(dataComposite, (RiskPropertyValue)rowData.get(i));
            if (i == this.editorState.size() - 1) {
                if (this.editorState.size() > 1) {
                    this.addRemoveButton(buttonComposite);
                }
                if (this.editorState.size() < this.maxValues) {
                    this.addAddButton(buttonComposite);
                }
            }
            ++i;
        }
        Composite extraComposite = new Composite(this.pane, 0);
        extraComposite.setLayout((Layout)RowLayoutFactory.createFrom((RowLayout)new RowLayout(256)).spacing(10).create());
        this.getDefault().ifPresent(value -> this.addRestoreButton(extraComposite, (List<T>)value));
        if (rowData.isEmpty()) {
            this.addAddButton(extraComposite);
        }
        this.pane.requestLayout();
        this.redraw();
        this.pack(true);
        if (this.getParent() instanceof ScrolledComposite) {
            ((ScrolledComposite)this.getParent()).setMinSize(this.getClientArea().width, this.getClientArea().height);
        }
    }

    protected abstract void addRow(Composite var1, T var2);

    protected abstract @NonNull T generateNewData(int var1);

    protected void updateValue(String id, Function<T, T> updater) {
        this.editorState.computeIfPresent(id, (key, value) -> (RiskPropertyValue)updater.apply(value));
        this.fireProperyChange.run();
    }

    private void addAddButton(Composite parent) {
        Button add = new Button(parent, 0);
        add.setText("+");
        add.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ++StackConfigurator.this.numberOfNewElements;
                Object newValue = StackConfigurator.this.generateNewData(StackConfigurator.this.editorState.size() + 1);
                StackConfigurator.this.editorState.put(newValue.getId(), newValue);
                StackConfigurator.this.refresh();
                StackConfigurator.this.fireProperyChange.run();
            }
        });
    }

    private void addRemoveButton(Composite parent) {
        Button remove = new Button(parent, 0);
        remove.setText("-");
        remove.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String lastKey = (String)StackConfigurator.this.editorState.keySet().toArray()[StackConfigurator.this.editorState.values().size() - 1];
                RiskPropertyValue lastElement = (RiskPropertyValue)StackConfigurator.this.editorState.remove(lastKey);
                if (StackConfigurator.this.numberOfNewElements == 0) {
                    StackConfigurator.this.deletedRows.push(lastElement);
                } else {
                    --StackConfigurator.this.numberOfNewElements;
                }
                StackConfigurator.this.refresh();
                StackConfigurator.this.fireProperyChange.run();
            }
        });
    }

    private void addRestoreButton(Composite parent, final List<T> defaultValues) {
        Button restore = new Button(parent, 0);
        restore.setText(Messages.riskConfigurationReset);
        restore.setToolTipText(Messages.riskConfigurationResetTooltip);
        restore.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                StackConfigurator.this.setEditorState(defaultValues);
                StackConfigurator.this.numberOfNewElements = 0;
                StackConfigurator.this.refresh();
                StackConfigurator.this.fireProperyChange.run();
            }
        });
    }

    protected static ControlDecoration createLabelFieldDecoration(Text labelField, String descriptionText) {
        ControlDecoration txtDecorator = new ControlDecoration((Control)labelField, 131200);
        FieldDecoration fieldDecoration = FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_ERROR");
        Image img = fieldDecoration.getImage();
        txtDecorator.setImage(img);
        txtDecorator.setDescriptionText(descriptionText);
        return txtDecorator;
    }

    protected void updateDecoratorVisibility(ControlDecoration txtDecorator, String id, String newLabel) {
        if (!StackConfigurator.isUniqueAndNonEmpty(id, newLabel, this.editorState.values())) {
            txtDecorator.show();
        } else {
            txtDecorator.hide();
        }
    }

    protected Optional<List<T>> getDefault() {
        return Optional.empty();
    }

    private static boolean isUniqueAndNonEmpty(String id, String label, Collection<? extends RiskPropertyValue> existingPropertyValues) {
        if (label.isEmpty()) {
            return false;
        }
        for (RiskPropertyValue riskPropertyValue : existingPropertyValues) {
            String existingLabel;
            if (riskPropertyValue.getId().equals(id) || !label.equals(existingLabel = riskPropertyValue.getLabel())) continue;
            return false;
        }
        return true;
    }
}

