/*
 * Decompiled with CFR 0.152.
 */
package sernet.verinice.bp.rcp.risk.ui;

import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.layout.RowLayoutFactory;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.ColorDialog;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import sernet.hui.swt.SWTResourceManager;
import sernet.verinice.bp.rcp.risk.ui.ColorConverter;
import sernet.verinice.bp.rcp.risk.ui.Messages;
import sernet.verinice.bp.rcp.risk.ui.StackConfigurator;
import sernet.verinice.model.bp.risk.Risk;
import sernet.verinice.model.bp.risk.configuration.DefaultRiskConfiguration;

public final class RiskValuesConfigurator
extends StackConfigurator<Risk> {
    private static final int MAX_NUMBER_OF_RISKS = 6;
    private static final int COLOR_BUTTON_WIDTH = 30;

    public RiskValuesConfigurator(Composite parent, List<Risk> editorState, Runnable fireProperyChange) {
        super(parent, 6, editorState, fireProperyChange);
    }

    @Override
    protected @NonNull Risk generateNewData(int index) {
        return new Risk(Risk.getPropertyKeyForIndex((int)index), "", "", null);
    }

    @Override
    protected void addRow(Composite parent, final Risk risk) {
        parent.setLayout((Layout)RowLayoutFactory.createFrom((RowLayout)new RowLayout(256)).spacing(10).create());
        Composite leftComposite = new Composite(parent, 0);
        leftComposite.setLayout((Layout)RowLayoutFactory.createFrom((RowLayout)new RowLayout(512)).spacing(5).create());
        Text riskLabel = new Text(leftComposite, 2048);
        riskLabel.setLayoutData((Object)new RowData(180, -1));
        riskLabel.setText(risk.getLabel());
        ControlDecoration txtDecorator = RiskValuesConfigurator.createLabelFieldDecoration(riskLabel, Messages.errorUniqueRiskCategoryLabels);
        this.updateDecoratorVisibility(txtDecorator, risk.getId(), risk.getLabel());
        riskLabel.addModifyListener(e -> {
            if (e.getSource() instanceof Text) {
                String newLabel = ((Text)e.getSource()).getText();
                this.updateDecoratorVisibility(txtDecorator, risk.getId(), newLabel);
                this.updateValue(risk.getId(), valueFromEditorState -> valueFromEditorState.withLabel(newLabel));
            }
        });
        final CLabel riskColor = new CLabel(leftComposite, 0x1000008);
        riskColor.setLayoutData((Object)new RowData(30, -1));
        final RGB rgb = ColorConverter.toRGB(risk.getColor());
        if (rgb != null) {
            riskColor.setBackground(SWTResourceManager.getColor((RGB)rgb));
        }
        riskColor.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                ColorDialog dlg = new ColorDialog(RiskValuesConfigurator.this.getDisplay().getActiveShell());
                dlg.setRGB(rgb);
                dlg.setText(Messages.RiskValuesConfigurator_chooseColor);
                RGB newColor = dlg.open();
                if (!Objects.equals(rgb, newColor)) {
                    RiskValuesConfigurator.this.updateValue(risk.getId(), valueFromEditorState -> valueFromEditorState.withColor(ColorConverter.toRiskColor(newColor)));
                    riskColor.setBackground(SWTResourceManager.getColor((RGB)newColor));
                }
            }
        });
        Text riskDescription = new Text(parent, 2626);
        riskDescription.setLayoutData((Object)new RowData(450, 80));
        riskDescription.setText(risk.getDescription());
        riskDescription.addModifyListener(e -> {
            if (e.getSource() instanceof Text) {
                String newDescription = ((Text)e.getSource()).getText();
                this.updateValue(risk.getId(), valueFromEditorState -> valueFromEditorState.withDescription(newDescription));
            }
        });
    }

    @Override
    protected Optional<List<Risk>> getDefault() {
        return Optional.ofNullable(DefaultRiskConfiguration.getInstance().getRisks());
    }
}

