/*
 * Decompiled with CFR 0.152.
 */
package sernet.verinice.bp.rcp.risk.ui;

import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang.StringUtils;
import org.eclipse.swt.events.SelectionListener;
import sernet.gs.service.RetrieveInfo;
import sernet.gs.service.Retriever;
import sernet.hui.swt.widgets.HitroUIComposite;
import sernet.hui.swt.widgets.IHuiControlFactory;
import sernet.verinice.bp.rcp.risk.ui.ComputeRisk;
import sernet.verinice.bp.rcp.risk.ui.DynamicRiskPropertiesControlFactory;
import sernet.verinice.bp.rcp.risk.ui.EffectiveRisk;
import sernet.verinice.bp.rcp.risk.ui.ResetRiskPropertiesWithAdditionalSafeguards;
import sernet.verinice.bp.rcp.risk.ui.ValidateRiskPropertyValues;
import sernet.verinice.model.bp.elements.BpThreat;
import sernet.verinice.model.bp.groups.BpThreatGroup;
import sernet.verinice.model.bp.risk.configuration.RiskConfiguration;
import sernet.verinice.model.common.CnALink;
import sernet.verinice.model.common.CnATreeElement;

public final class RiskUiUtils {
    private static final Map<String, String> RISK_ANALYSIS_NECESSARY_PROPERTY_ID_BY_TYPE_ID;

    static {
        HashMap<String, String> m = new HashMap<String, String>();
        m.put("bp_application", "bp_application_riskanalysis_necessary");
        m.put("bp_businessprocess", "bp_businessprocess_riskanalysis_necessary");
        m.put("bp_device", "bp_device_riskanalysis_necessary");
        m.put("bp_icssystem", "bp_icssystem_riskanalysis_necessary");
        m.put("bp_itsystem", "bp_itsystem_riskanalysis_necessary");
        m.put("bp_network", "bp_network_riskanalysis_necessary");
        m.put("bp_room", "bp_room_riskanalysis_necessary");
        RISK_ANALYSIS_NECESSARY_PROPERTY_ID_BY_TYPE_ID = Collections.unmodifiableMap(m);
    }

    private RiskUiUtils() {
    }

    public static Map<String, IHuiControlFactory> createHuiControlFactories(CnATreeElement element) {
        HashMap<String, IHuiControlFactory> overrides = new HashMap<String, IHuiControlFactory>();
        if (element instanceof BpThreat) {
            Stream.of("bp_threat_risk_without_safeguards_frequency", "bp_threat_risk_without_additional_safeguards_frequency", "bp_threat_risk_with_additional_safeguards_frequency").forEach(property -> {
                DynamicRiskPropertiesControlFactory dynamicRiskPropertiesControlFactory = overrides.put((String)property, new DynamicRiskPropertiesControlFactory(element, RiskConfiguration::getFrequencies));
            });
            Stream.of("bp_threat_risk_without_safeguards_impact", "bp_threat_risk_without_additional_safeguards_impact", "bp_threat_risk_with_additional_safeguards_impact").forEach(property -> {
                DynamicRiskPropertiesControlFactory dynamicRiskPropertiesControlFactory = overrides.put((String)property, new DynamicRiskPropertiesControlFactory(element, RiskConfiguration::getImpacts));
            });
            Stream.of("bp_threat_risk_without_safeguards_risk", "bp_threat_risk_without_additional_safeguards_risk", "bp_threat_risk_with_additional_safeguards_risk").forEach(property -> {
                DynamicRiskPropertiesControlFactory dynamicRiskPropertiesControlFactory = overrides.put((String)property, new DynamicRiskPropertiesControlFactory(element, RiskConfiguration::getRisks));
            });
        }
        return overrides;
    }

    public static void addSelectionListener(HitroUIComposite huiComposite, CnATreeElement element) {
        if (element instanceof BpThreat) {
            BpThreat threat = (BpThreat)element;
            huiComposite.addSelectionListener("bp_threat_risk_treatment_option", (SelectionListener)new ResetRiskPropertiesWithAdditionalSafeguards(threat));
            RiskUiUtils.addRiskComputeListeners(huiComposite, threat, "bp_threat_risk_without_safeguards_frequency", "bp_threat_risk_without_safeguards_impact", "bp_threat_risk_without_safeguards_risk");
            RiskUiUtils.addRiskComputeListeners(huiComposite, threat, "bp_threat_risk_without_additional_safeguards_frequency", "bp_threat_risk_without_additional_safeguards_impact", "bp_threat_risk_without_additional_safeguards_risk");
            RiskUiUtils.addRiskComputeListeners(huiComposite, threat, "bp_threat_risk_with_additional_safeguards_frequency", "bp_threat_risk_with_additional_safeguards_impact", "bp_threat_risk_with_additional_safeguards_risk");
            ValidateRiskPropertyValues changeListener = new ValidateRiskPropertyValues(huiComposite, threat);
            Stream.of("bp_threat_risk_without_safeguards_frequency", "bp_threat_risk_without_safeguards_impact", "bp_threat_risk_without_additional_safeguards_frequency", "bp_threat_risk_without_additional_safeguards_impact", "bp_threat_risk_with_additional_safeguards_frequency", "bp_threat_risk_with_additional_safeguards_impact").forEach(property -> huiComposite.addSelectionListener(property, (SelectionListener)changeListener));
        }
    }

    private static void addRiskComputeListeners(HitroUIComposite huiComposite, BpThreat threat, String frequencyProperty, String impactProperty, String riskProperty) {
        ComputeRisk listener = new ComputeRisk(threat, frequencyProperty, impactProperty, riskProperty);
        huiComposite.addSelectionListener(frequencyProperty, (SelectionListener)listener);
        huiComposite.addSelectionListener(impactProperty, (SelectionListener)listener);
    }

    public static EffectiveRisk getEffectiveRisk(BpThreat threat) {
        String riskTreatment = threat.getEntity().getRawPropertyValue("bp_threat_risk_treatment_option");
        if (StringUtils.isEmpty((String)riskTreatment)) {
            return Optional.ofNullable(threat.getRiskWithoutAdditionalSafeguards()).map(EffectiveRisk::of).orElse(EffectiveRisk.UNKNOWN);
        }
        if ("bp_threat_risk_treatment_option_risk_reduction".equals(riskTreatment)) {
            return Optional.ofNullable(threat.getRiskWithAdditionalSafeguards()).map(EffectiveRisk::of).orElse(EffectiveRisk.UNKNOWN);
        }
        return EffectiveRisk.TREATED;
    }

    public static EffectiveRisk getEffectiveRisk(BpThreatGroup threatGroup) {
        Set children;
        if (!Retriever.areChildrenInitialized((CnATreeElement)threatGroup) || !threatGroup.getChildren().stream().allMatch(Retriever::isElementInitialized)) {
            threatGroup = (BpThreatGroup)Retriever.retrieveElement((CnATreeElement)threatGroup, (RetrieveInfo)new RetrieveInfo().setChildren(true).setChildrenProperties(true));
        }
        if (!(children = threatGroup.getChildren()).isEmpty()) {
            if (children.stream().noneMatch(BpThreatGroup.class::isInstance)) {
                Set effectiveRisks = children.stream().filter(BpThreat.class::isInstance).map(BpThreat.class::cast).map(RiskUiUtils::getEffectiveRisk).collect(Collectors.toSet());
                if (!effectiveRisks.isEmpty()) {
                    if (effectiveRisks.contains(EffectiveRisk.UNKNOWN)) {
                        return EffectiveRisk.UNKNOWN;
                    }
                    return effectiveRisks.stream().max(Comparator.comparing(EffectiveRisk::getRiskId)).orElseThrow(IllegalStateException::new);
                }
            }
        }
        return null;
    }

    public static EffectiveRisk getEffectiveRisk(CnATreeElement element) {
        String riskAnalysisNecessaryPropertyId = RISK_ANALYSIS_NECESSARY_PROPERTY_ID_BY_TYPE_ID.get(element.getTypeId());
        if (riskAnalysisNecessaryPropertyId != null && element.getEntity().isFlagged(riskAnalysisNecessaryPropertyId)) {
            return RiskUiUtils.getEffectiveRiskRiskAnalsisNecessary(element);
        }
        return null;
    }

    private static EffectiveRisk getEffectiveRiskRiskAnalsisNecessary(CnATreeElement element) {
        Set linkedThreats;
        if (!Retriever.areLinksInitizialized((CnATreeElement)element, (boolean)true) || !element.getLinksUp().stream().map(CnALink::getDependant).allMatch(Retriever::isElementInitialized)) {
            element = Retriever.retrieveElement((CnATreeElement)element, (RetrieveInfo)new RetrieveInfo().setLinksUp(true).setLinksUpProperties(true));
        }
        if (!(linkedThreats = element.getLinksUp().stream().filter(link -> link.getDependant() instanceof BpThreat).map(CnALink::getDependant).collect(Collectors.toSet())).isEmpty()) {
            Optional<EffectiveRisk> risk;
            Set<EffectiveRisk> effectiveRisksFromLinkedThreats = linkedThreats.stream().filter(BpThreat.class::isInstance).map(BpThreat.class::cast).map(RiskUiUtils::getEffectiveRisk).collect(Collectors.toSet());
            if (!effectiveRisksFromLinkedThreats.isEmpty() && (risk = RiskUiUtils.determineRiskForTargetObject(effectiveRisksFromLinkedThreats)).isPresent()) {
                return risk.get();
            }
        }
        return EffectiveRisk.UNKNOWN;
    }

    private static Optional<EffectiveRisk> determineRiskForTargetObject(Set<EffectiveRisk> effectiveRisksFromLinkedThreats) {
        if (effectiveRisksFromLinkedThreats.size() == 1 && effectiveRisksFromLinkedThreats.contains(EffectiveRisk.TREATED)) {
            return Optional.of(EffectiveRisk.TREATED);
        }
        if (effectiveRisksFromLinkedThreats.contains(EffectiveRisk.UNKNOWN)) {
            return Optional.of(EffectiveRisk.UNKNOWN);
        }
        EffectiveRisk maximumRisk = Collections.max(effectiveRisksFromLinkedThreats, Comparator.comparing(EffectiveRisk::getRiskId));
        if (!EffectiveRisk.TREATED.equals(maximumRisk)) {
            return Optional.of(maximumRisk);
        }
        return Optional.empty();
    }
}

