/*
 * Decompiled with CFR 0.152.
 */
package sernet.verinice.bp.rcp.risk.ui;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.RowLayoutFactory;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import sernet.gs.ui.rcp.main.common.model.CnATreeElementScopeUtils;
import sernet.hui.swt.SWTResourceManager;
import sernet.verinice.bp.rcp.risk.ui.ColorConverter;
import sernet.verinice.bp.rcp.risk.ui.Messages;
import sernet.verinice.model.bp.elements.ItNetwork;
import sernet.verinice.model.bp.risk.Frequency;
import sernet.verinice.model.bp.risk.Impact;
import sernet.verinice.model.bp.risk.Risk;
import sernet.verinice.model.bp.risk.configuration.RiskConfiguration;
import sernet.verinice.model.common.CnATreeElement;

public class RiskMatrixConfigurator
extends Composite {
    private static final int SELECTOR_SIZE = 100;
    public static final int ELEMENT_SPACING = 10;
    private static final RGB WHITE = new RGB(255, 255, 255);
    private static final RGB BLACK = new RGB(0, 0, 0);
    private Composite pane;
    private RiskConfiguration editorState;
    private final Runnable firePropertyChanged;
    private final Runnable fireRestore;

    public RiskMatrixConfigurator(Composite parent, RiskConfiguration riskConfiguration, Runnable firePropertyChanged, Runnable fireRestore) {
        super(parent, 0);
        this.firePropertyChanged = firePropertyChanged;
        this.fireRestore = fireRestore;
        this.editorState = riskConfiguration;
        this.refresh();
    }

    public static RiskConfiguration getRiskConfiguration(CnATreeElement element) {
        ItNetwork itNetwork = (ItNetwork)CnATreeElementScopeUtils.getScope(element);
        if (!(itNetwork instanceof ItNetwork)) {
            throw new IllegalArgumentException("Cannot retrieve risk configuration for " + element + " as it is not part of an IT network");
        }
        return itNetwork.getRiskConfigurationOrDefault();
    }

    public void setEditorState(RiskConfiguration riskConfiguration) {
        this.editorState = riskConfiguration;
    }

    public RiskConfiguration getEditorState() {
        return this.editorState;
    }

    public void refresh() {
        if (this.pane != null) {
            this.pane.dispose();
        }
        List impactValues = this.editorState.getImpacts();
        ArrayList impactValuesReverse = new ArrayList(impactValues);
        Collections.reverse(impactValuesReverse);
        List frequencyValues = this.editorState.getFrequencies();
        this.setLayout((Layout)new GridLayout(frequencyValues.size() + 1, true));
        this.pane = new Composite((Composite)this, 0);
        this.pane.setLayout((Layout)new GridLayout(frequencyValues.size() + 1, false));
        Label labels = new Label(this.pane, 0);
        labels.setLayoutData((Object)GridDataFactory.swtDefaults().span(frequencyValues.size() + 1, 1).create());
        labels.setText(Messages.riskConfigurationMatrixImpactAxis);
        impactValuesReverse.forEach(impact -> {
            Label label = new Label(this.pane, 0);
            GridData layoutData = new GridData();
            layoutData.widthHint = 180;
            label.setLayoutData((Object)layoutData);
            String text = this.cutLabel(impact.getLabel(), (Control)label, 205);
            label.setText(text);
            frequencyValues.forEach(frequency -> this.addRiskSelector((Impact)impact, (Frequency)frequency));
        });
        new Label(this.pane, 0);
        frequencyValues.forEach(frequency -> {
            Label label = new Label(this.pane, 0);
            String text = this.cutLabel(frequency.getLabel(), (Control)label, 100);
            label.setText(text);
        });
        new Label(this.pane, 0);
        Label axisLabel = new Label(this.pane, 0);
        axisLabel.setLayoutData((Object)GridDataFactory.swtDefaults().align(0x1000000, 1).span(frequencyValues.size(), 1).create());
        axisLabel.setText(Messages.riskConfigurationMatrixFrequencyAxis);
        new Label(this.pane, 0).setLayoutData((Object)GridDataFactory.swtDefaults().span(frequencyValues.size() + 1, 1).create());
        Label helpText = new Label(this.pane, 0);
        helpText.setLayoutData((Object)GridDataFactory.swtDefaults().span(frequencyValues.size() + 1, 1).create());
        helpText.setText(Messages.riskConfigurationMatrixUsage);
        Composite extraComposite = new Composite(this.pane, 0);
        extraComposite.setLayout((Layout)RowLayoutFactory.createFrom((RowLayout)new RowLayout(256)).spacing(10).create());
        this.addRestoreButton(extraComposite);
        this.pack(true);
        if (this.getParent() instanceof ScrolledComposite) {
            ((ScrolledComposite)this.getParent()).setMinSize(this.getClientArea().width, this.getClientArea().height);
        }
        this.pane.requestLayout();
        this.redraw();
    }

    private void addRiskSelector(final Impact impact, final Frequency frequency) {
        final CLabel selector = new CLabel(this.pane, 0x1000008);
        selector.setLayoutData((Object)new GridData(100, 100));
        selector.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                boolean modifierPressed = (e.stateMask & SWT.MODIFIER_MASK) != 0;
                int numberOfRisks = RiskMatrixConfigurator.this.editorState.getRisks().size();
                Risk currentRisk = RiskMatrixConfigurator.this.editorState.getRisk(frequency, impact);
                int index = RiskMatrixConfigurator.this.editorState.getRisks().indexOf(currentRisk);
                int newIndex = index + (modifierPressed ? -1 : 1);
                Risk newRisk = newIndex >= numberOfRisks || newIndex == -1 ? null : (newIndex < -1 ? (Risk)RiskMatrixConfigurator.this.editorState.getRisks().get(numberOfRisks - 1) : (Risk)RiskMatrixConfigurator.this.editorState.getRisks().get(newIndex));
                RiskMatrixConfigurator.this.fillSelector(selector, newRisk);
                RiskMatrixConfigurator.this.editorState = RiskMatrixConfigurator.this.editorState.withRisk(frequency, impact, newRisk);
                RiskMatrixConfigurator.this.firePropertyChanged.run();
            }
        });
        this.fillSelector(selector, this.editorState.getRisk(frequency, impact));
    }

    private void fillSelector(CLabel selector, Risk risk) {
        String longText;
        String text;
        Color backgroundColor = null;
        Color textColor = null;
        if (risk == null) {
            longText = text = sernet.hui.swt.widgets.Messages.getString((String)"SingleSelectDummyValue");
            textColor = SWTResourceManager.getColor((RGB)BLACK);
        } else {
            text = this.cutLabel(risk.getLabel(), (Control)selector, 75);
            longText = risk.getLabel();
            RGB riskColor = ColorConverter.toRGB(risk.getColor());
            if (riskColor != null) {
                backgroundColor = SWTResourceManager.getColor((RGB)riskColor);
                textColor = SWTResourceManager.getColor((RGB)RiskMatrixConfigurator.determineOptimalTextColor(riskColor, WHITE, BLACK));
            }
        }
        selector.setText(text);
        selector.setToolTipText(longText);
        selector.getBackground().dispose();
        selector.setBackground(backgroundColor);
        selector.getForeground().dispose();
        selector.setForeground(textColor);
    }

    private String cutLabel(String text, Control control, int size) {
        GC gc = new GC((Drawable)control);
        int stringWidth = gc.stringExtent((String)text).x;
        String newText = text;
        int x = newText.length();
        while (stringWidth > size) {
            newText = String.valueOf(text.substring(0, x)) + "...";
            stringWidth = gc.stringExtent((String)newText).x;
            --x;
        }
        gc.dispose();
        return newText;
    }

    private static RGB determineOptimalTextColor(RGB bgColor, RGB lightColor, RGB darkColor) {
        double contrastRatioToLightColor;
        double l = RiskMatrixConfigurator.getRelativeLuminance(bgColor);
        double lLightColor = RiskMatrixConfigurator.getRelativeLuminance(lightColor);
        double lDarkColor = RiskMatrixConfigurator.getRelativeLuminance(darkColor);
        double contrastRatioToDarkColor = (l + 0.05) / (lDarkColor + 0.05);
        if (contrastRatioToDarkColor > (contrastRatioToLightColor = (lLightColor + 0.05) / (l + 0.05))) {
            return darkColor;
        }
        return lightColor;
    }

    private static double getRelativeLuminance(RGB color) {
        double[] c = new double[]{color.red, color.green, color.blue};
        int i = 0;
        while (i <= 2) {
            double col = c[i] / 255.0;
            col = col <= 0.03928 ? (col /= 12.92) : Math.pow((col + 0.055) / 1.055, 2.4);
            c[i] = col;
            ++i;
        }
        return 0.2126 * c[0] + 0.7152 * c[1] + 0.0722 * c[2];
    }

    private void addRestoreButton(Composite parent) {
        Button restore = new Button(parent, 131072);
        restore.setText(Messages.riskConfigurationResetAll);
        restore.setToolTipText(Messages.riskConfigurationResetTooltip);
        restore.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RiskMatrixConfigurator.this.fireRestore.run();
            }
        });
    }
}

