/*
 * Decompiled with CFR 0.152.
 */
package sernet.verinice.bp.rcp.risk.ui;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.log4j.Logger;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IDecoration;
import org.eclipse.jface.viewers.ILightweightLabelDecorator;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;
import sernet.gs.ui.rcp.main.Activator;
import sernet.hui.common.VeriniceContext;
import sernet.hui.common.connect.ITargetObject;
import sernet.hui.swt.SWTResourceManager;
import sernet.verinice.bp.rcp.risk.ui.ColorConverter;
import sernet.verinice.bp.rcp.risk.ui.EffectiveRisk;
import sernet.verinice.bp.rcp.risk.ui.RiskUiUtils;
import sernet.verinice.model.bp.elements.BpThreat;
import sernet.verinice.model.bp.groups.BpThreatGroup;
import sernet.verinice.model.bp.risk.Risk;
import sernet.verinice.model.bp.risk.configuration.DefaultRiskConfiguration;
import sernet.verinice.model.bp.risk.configuration.RiskConfiguration;
import sernet.verinice.model.common.CnATreeElement;
import sernet.verinice.service.bp.risk.RiskService;

public class RiskDecorator
extends LabelProvider
implements ILightweightLabelDecorator {
    private static final Logger logger = Logger.getLogger(RiskDecorator.class);
    private static final RGB GRAY = new RGB(180, 180, 180);
    private static final RGB BLACK = new RGB(0, 0, 0);
    private static final RGB WHITE = new RGB(255, 255, 255);
    private boolean decoratorEnabled = Activator.getDefault().getPreferenceStore().getBoolean("show_bp_risk_analysis_decorator");
    private static final boolean ADD_COLOR_SUFFIX = Boolean.parseBoolean(System.getProperty("verinice.debug_bp_risk_analysis_decorator"));
    private static final Map<RGB, ImageDescriptor> CACHED_OVERLAYS_PER_COLOR = new LinkedHashMap<RGB, ImageDescriptor>(){
        private static final long serialVersionUID = 3645241081387305815L;

        @Override
        protected boolean removeEldestEntry(Map.Entry<RGB, ImageDescriptor> eldest) {
            return this.size() > 500;
        }
    };

    public RiskDecorator() {
        logger.info((Object)("Initializing, decoratorEnabled = " + this.decoratorEnabled));
        Activator.getDefault().getPreferenceStore().addPropertyChangeListener(event -> {
            if ("show_bp_risk_analysis_decorator".equals(event.getProperty())) {
                this.decoratorEnabled = Activator.getDefault().getPreferenceStore().getBoolean("show_bp_risk_analysis_decorator");
                logger.info((Object)("Activation state changed, decoratorEnabled = " + this.decoratorEnabled));
                this.updateDecorations();
            }
        });
    }

    private void updateDecorations() {
        this.fireLabelProviderChanged(new LabelProviderChangedEvent((IBaseLabelProvider)this));
    }

    public void decorate(Object element, IDecoration decoration) {
        if (this.decoratorEnabled) {
            RGB color = null;
            if (element instanceof BpThreat) {
                BpThreat threat = (BpThreat)element;
                EffectiveRisk risk = RiskUiUtils.getEffectiveRisk(threat);
                color = RiskDecorator.getColorForThreatRisk((CnATreeElement)threat, risk);
            } else if (element instanceof BpThreatGroup) {
                color = this.getColorForThreatGroup((BpThreatGroup)element);
            } else if (element instanceof ITargetObject) {
                color = RiskDecorator.getColorForTargetObject((CnATreeElement)element);
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Color for " + element + " = " + element));
            }
            if (color != null) {
                decoration.addOverlay(CACHED_OVERLAYS_PER_COLOR.computeIfAbsent(color, RiskDecorator::createOverlay));
                if (ADD_COLOR_SUFFIX) {
                    String colorString = String.format("#%02x%02x%02x", color.red, color.green, color.blue);
                    decoration.addSuffix(" - " + colorString);
                }
            }
        }
    }

    private static RGB getColorForTargetObject(CnATreeElement element) {
        EffectiveRisk risk = RiskUiUtils.getEffectiveRisk(element);
        return RiskDecorator.getColorForThreatRisk(element, risk);
    }

    private RGB getColorForThreatGroup(BpThreatGroup threatGroup) {
        EffectiveRisk risk = RiskUiUtils.getEffectiveRisk(threatGroup);
        return RiskDecorator.getColorForThreatRisk((CnATreeElement)threatGroup, risk);
    }

    private static RGB getColorForThreatRisk(CnATreeElement element, EffectiveRisk risk) {
        if (risk == null) {
            return null;
        }
        if (EffectiveRisk.TREATED.equals(risk)) {
            return GRAY;
        }
        if (EffectiveRisk.UNKNOWN.equals(risk)) {
            return BLACK;
        }
        RiskService riskService = (RiskService)VeriniceContext.get((String)"itbpRiskService");
        RiskConfiguration riskConfiguration = Optional.ofNullable(riskService.findRiskConfiguration(element.getScopeId())).orElseGet(DefaultRiskConfiguration::getInstance);
        return riskConfiguration.getRisks().stream().filter(item -> item.getId().equals(risk.getRiskId())).map(Risk::getColor).findFirst().map(ColorConverter::toRGB).orElse(null);
    }

    private static ImageDescriptor createOverlay(RGB rgb) {
        int baseSize = 12;
        return ImageDescriptor.createFromImageDataProvider(zoom -> {
            int whitePixel;
            int size = 12 * zoom / 100;
            Image image = new Image((Device)Display.getDefault(), size, size);
            GC gc = new GC((Drawable)image);
            gc.setForeground(SWTResourceManager.getColor((RGB)BLACK));
            gc.setBackground(SWTResourceManager.getColor((RGB)rgb));
            int[] nArray = new int[6];
            nArray[2] = size;
            nArray[4] = size;
            nArray[5] = size;
            int[] xAndYValues = nArray;
            gc.drawPolygon(xAndYValues);
            gc.fillPolygon(xAndYValues);
            gc.dispose();
            ImageData imageData = image.getImageData();
            imageData.transparentPixel = whitePixel = imageData.palette.getPixel(WHITE);
            image.dispose();
            return imageData;
        });
    }
}

