/*
 * Decompiled with CFR 0.152.
 */
package sernet.verinice.bp.rcp.risk.ui;

import java.util.List;
import java.util.Optional;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.layout.RowLayoutFactory;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import sernet.verinice.bp.rcp.risk.ui.Messages;
import sernet.verinice.bp.rcp.risk.ui.StackConfigurator;
import sernet.verinice.model.bp.risk.Impact;
import sernet.verinice.model.bp.risk.configuration.DefaultRiskConfiguration;

public final class ImpactConfigurator
extends StackConfigurator<Impact> {
    private static final int MAX_NUMBER_OF_IMPACTS = 10;

    public ImpactConfigurator(Composite parent, List<Impact> editorState, Runnable fireProperyChange) {
        super(parent, 10, editorState, fireProperyChange);
    }

    @Override
    protected @NonNull Impact generateNewData(int index) {
        return new Impact(Impact.getPropertyKeyForIndex((int)index), "", "");
    }

    @Override
    protected void addRow(Composite parent, Impact impact) {
        parent.setLayout((Layout)RowLayoutFactory.createFrom((RowLayout)new RowLayout(256)).spacing(10).create());
        Composite currentItemLeft = new Composite(parent, 0);
        currentItemLeft.setLayout((Layout)RowLayoutFactory.createFrom((RowLayout)new RowLayout(512)).spacing(5).create());
        Text labelField = new Text(currentItemLeft, 2048);
        labelField.setLayoutData((Object)new RowData(180, -1));
        labelField.setText(impact.getLabel());
        ControlDecoration txtDecorator = ImpactConfigurator.createLabelFieldDecoration(labelField, Messages.errorUniqueImpactLabels);
        this.updateDecoratorVisibility(txtDecorator, impact.getId(), impact.getLabel());
        labelField.addModifyListener(e -> {
            if (e.getSource() instanceof Text) {
                String newLabel = ((Text)e.getSource()).getText();
                this.updateDecoratorVisibility(txtDecorator, impact.getId(), newLabel);
                this.updateValue(impact.getId(), valueFromEditorState -> valueFromEditorState.withLabel(newLabel));
            }
        });
        Text descriptionField = new Text(parent, 2626);
        descriptionField.setLayoutData((Object)new RowData(450, 80));
        descriptionField.setText(impact.getDescription());
        descriptionField.addModifyListener(e -> {
            if (e.getSource() instanceof Text) {
                String newDescription = ((Text)e.getSource()).getText();
                this.updateValue(impact.getId(), valueFromEditorState -> valueFromEditorState.withDescription(newDescription));
            }
        });
    }

    @Override
    protected Optional<List<Impact>> getDefault() {
        return Optional.ofNullable(DefaultRiskConfiguration.getInstance().getImpacts());
    }
}

