/*
 * Decompiled with CFR 0.152.
 */
package sernet.verinice.bp.rcp.risk.ui;

import java.util.List;
import java.util.Optional;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.layout.RowLayoutFactory;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import sernet.verinice.bp.rcp.risk.ui.Messages;
import sernet.verinice.bp.rcp.risk.ui.StackConfigurator;
import sernet.verinice.model.bp.risk.Frequency;
import sernet.verinice.model.bp.risk.configuration.DefaultRiskConfiguration;

public final class FrequencyConfigurator
extends StackConfigurator<Frequency> {
    private static final int MAX_NUMBER_OF_FREQUENCIES = 10;

    public FrequencyConfigurator(Composite parent, List<Frequency> editorState, Runnable fireProperyChange) {
        super(parent, 10, editorState, fireProperyChange);
    }

    @Override
    protected @NonNull Frequency generateNewData(int index) {
        return new Frequency(Frequency.getPropertyKeyForIndex((int)index), "", "");
    }

    @Override
    protected void addRow(Composite parent, Frequency frequency) {
        parent.setLayout((Layout)RowLayoutFactory.createFrom((RowLayout)new RowLayout(256)).spacing(10).create());
        Composite currentItemLeft = new Composite(parent, 0);
        currentItemLeft.setLayout((Layout)RowLayoutFactory.createFrom((RowLayout)new RowLayout(512)).spacing(5).create());
        Text labelField = new Text(currentItemLeft, 2048);
        labelField.setLayoutData((Object)new RowData(180, -1));
        labelField.setText(frequency.getLabel());
        ControlDecoration txtDecorator = FrequencyConfigurator.createLabelFieldDecoration(labelField, Messages.errorUniqueFrequencyLabels);
        this.updateDecoratorVisibility(txtDecorator, frequency.getId(), frequency.getLabel());
        labelField.addModifyListener(e -> {
            if (e.getSource() instanceof Text) {
                String newLabel = ((Text)e.getSource()).getText();
                this.updateDecoratorVisibility(txtDecorator, frequency.getId(), newLabel);
                this.updateValue(frequency.getId(), valueFromEditorState -> valueFromEditorState.withLabel(newLabel));
            }
        });
        Text descriptionField = new Text(parent, 2626);
        descriptionField.setLayoutData((Object)new RowData(450, 80));
        descriptionField.setText(frequency.getDescription());
        descriptionField.addModifyListener(e -> {
            if (e.getSource() instanceof Text) {
                String newDescription = ((Text)e.getSource()).getText();
                this.updateValue(frequency.getId(), valueFromEditorState -> valueFromEditorState.withDescription(newDescription));
            }
        });
    }

    @Override
    protected Optional<List<Frequency>> getDefault() {
        return Optional.ofNullable(DefaultRiskConfiguration.getInstance().getFrequencies());
    }
}

