/*
 * Decompiled with CFR 0.152.
 */
package sernet.verinice.bp.rcp.filter;

import java.util.Set;
import sernet.gs.service.RetrieveInfo;
import sernet.gs.service.Retriever;
import sernet.gs.ui.rcp.main.common.model.CnATreeElementScopeUtils;
import sernet.verinice.model.bp.Proceeding;
import sernet.verinice.model.bp.SecurityLevel;
import sernet.verinice.model.bp.elements.BpRequirement;
import sernet.verinice.model.bp.elements.BpThreat;
import sernet.verinice.model.bp.elements.ItNetwork;
import sernet.verinice.model.common.CnALink;
import sernet.verinice.model.common.CnATreeElement;

public final class ThreatByProceedingFilterUtil {
    public static boolean showThreatWhenProceedingFilterIsEnabled(BpThreat threat) {
        CnATreeElement scope = CnATreeElementScopeUtils.getScope((CnATreeElement)threat);
        if (!(scope instanceof ItNetwork)) {
            return true;
        }
        ItNetwork itNetwork = (ItNetwork)scope;
        Proceeding proceeding = itNetwork.getProceeding();
        if (proceeding == null) {
            return true;
        }
        CnATreeElement element = Retriever.retrieveElement((CnATreeElement)threat, (RetrieveInfo)new RetrieveInfo().setLinksUpProperties(true));
        Set linksUpFromThreat = element.getLinksUp();
        if (linksUpFromThreat.isEmpty()) {
            return true;
        }
        for (CnALink cnALink : linksUpFromThreat) {
            BpRequirement requirement;
            SecurityLevel requirementSecurityLevel;
            if (!"rel_bp_requirement_bp_threat".equals(cnALink.getRelationId()) || !proceeding.requires(requirementSecurityLevel = (requirement = (BpRequirement)cnALink.getDependant()).getSecurityLevel())) continue;
            return true;
        }
        return false;
    }

    private ThreatByProceedingFilterUtil() {
    }
}

