/*
 * Decompiled with CFR 0.152.
 */
package sernet.verinice.bp.rcp.filter;

import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import sernet.verinice.model.bp.IBpGroup;
import sernet.verinice.model.bp.elements.ItNetwork;
import sernet.verinice.model.common.CnATreeElement;

class RecursiveTreeFilter
extends ViewerFilter {
    private final ViewerFilter delegateFilter;
    private final int maxDepth;

    RecursiveTreeFilter(ViewerFilter delegateFilter) {
        this(delegateFilter, Integer.MAX_VALUE);
    }

    RecursiveTreeFilter(ViewerFilter delegateFilter, int maxDepth) {
        this.delegateFilter = delegateFilter;
        this.maxDepth = maxDepth;
    }

    protected boolean checkChildren(CnATreeElement cnATreeElement) {
        return cnATreeElement instanceof ItNetwork || cnATreeElement instanceof IBpGroup;
    }

    public boolean select(Viewer viewer, Object parentElement, Object element) {
        return this.select(viewer, parentElement, element, 0);
    }

    private boolean select(Viewer viewer, Object parentElement, Object element, int depth) {
        CnATreeElement cnATreeElement = (CnATreeElement)element;
        if (this.delegateFilter.select(viewer, parentElement, (Object)cnATreeElement)) {
            return true;
        }
        if (this.checkChildren(cnATreeElement)) {
            if (depth == this.maxDepth) {
                return true;
            }
            return this.containsMatchingChild(viewer, cnATreeElement, depth);
        }
        return false;
    }

    private boolean containsMatchingChild(Viewer viewer, CnATreeElement cnATreeElement, int depth) {
        ITreeContentProvider provider = (ITreeContentProvider)((StructuredViewer)viewer).getContentProvider();
        Object[] objectArray = provider.getChildren((Object)cnATreeElement);
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object child = objectArray[n2];
            if (this.select(viewer, cnATreeElement, child, depth + 1)) {
                return true;
            }
            ++n2;
        }
        return false;
    }
}

