/*
 * Decompiled with CFR 0.152.
 */
package sernet.verinice.bp.rcp.filter;

import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNull;
import sernet.gs.service.CollectionUtil;
import sernet.verinice.model.bp.ChangeType;
import sernet.verinice.model.bp.ImplementationStatus;
import sernet.verinice.model.bp.SecurityLevel;

public class BaseProtectionFilterParameters {
    private @NonNull Optional<Boolean> auditPerformed = Optional.empty();
    private @NonNull Set<ImplementationStatus> implementationStatuses = new HashSet<ImplementationStatus>();
    private @NonNull Optional<Boolean> riskAnalysisNecessary = Optional.empty();
    private @NonNull Set<String> riskLabels = new HashSet<String>();
    private @NonNull Set<SecurityLevel> securityLevels = new HashSet<SecurityLevel>();
    private @NonNull Set<ChangeType> changeTypes = new HashSet<ChangeType>();
    private @NonNull Set<String> elementTypes = new HashSet<String>();
    private @NonNull Set<String> releases = new HashSet<String>();
    private @NonNull Set<String> tags = new HashSet<String>();
    private boolean applyTagFilterToItNetworks;
    private boolean hideEmptyGroups;

    public static Builder builder() {
        return new Builder();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.applyTagFilterToItNetworks ? 1231 : 1237);
        result = 31 * result + (this.elementTypes == null ? 0 : this.elementTypes.hashCode());
        result = 31 * result + (this.hideEmptyGroups ? 1231 : 1237);
        result = 31 * result + (this.implementationStatuses == null ? 0 : this.implementationStatuses.hashCode());
        result = 31 * result + (this.securityLevels == null ? 0 : this.securityLevels.hashCode());
        result = 31 * result + (this.tags == null ? 0 : this.tags.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BaseProtectionFilterParameters other = (BaseProtectionFilterParameters)obj;
        if (this.applyTagFilterToItNetworks != other.applyTagFilterToItNetworks) {
            return false;
        }
        if (!this.auditPerformed.equals(other.auditPerformed)) {
            return false;
        }
        if (!this.changeTypes.equals(other.changeTypes)) {
            return false;
        }
        if (!this.elementTypes.equals(other.elementTypes)) {
            return false;
        }
        if (this.hideEmptyGroups != other.hideEmptyGroups) {
            return false;
        }
        if (!this.implementationStatuses.equals(other.implementationStatuses)) {
            return false;
        }
        if (!this.releases.equals(other.releases)) {
            return false;
        }
        if (!this.riskAnalysisNecessary.equals(other.riskAnalysisNecessary)) {
            return false;
        }
        if (!this.riskLabels.equals(other.riskLabels)) {
            return false;
        }
        if (!this.securityLevels.equals(other.securityLevels)) {
            return false;
        }
        return this.tags.equals(other.tags);
    }

    public Optional<Boolean> getAuditPerformed() {
        return this.auditPerformed;
    }

    public Set<ChangeType> getChangeTypes() {
        return this.changeTypes;
    }

    public @NonNull Set<ImplementationStatus> getImplementationStatuses() {
        return this.implementationStatuses;
    }

    public Set<String> getReleases() {
        return this.releases;
    }

    public Optional<Boolean> getRiskAnalysisNecessary() {
        return this.riskAnalysisNecessary;
    }

    public Set<String> getRiskLabels() {
        return this.riskLabels;
    }

    public @NonNull Set<SecurityLevel> getSecurityLevels() {
        return this.securityLevels;
    }

    public @NonNull Set<String> getElementTypes() {
        return this.elementTypes;
    }

    public @NonNull Set<String> getTags() {
        return this.tags;
    }

    public boolean isApplyTagFilterToItNetworks() {
        return this.applyTagFilterToItNetworks;
    }

    public boolean isHideEmptyGroups() {
        return this.hideEmptyGroups;
    }

    public static class Builder {
        private @NonNull BaseProtectionFilterParameters parameters = new BaseProtectionFilterParameters();

        private Builder() {
        }

        public @NonNull BaseProtectionFilterParameters build() {
            return this.parameters;
        }

        public Builder withHideEmptyGroups(boolean hideEmptyGroups) {
            this.parameters.hideEmptyGroups = hideEmptyGroups;
            return this;
        }

        public Builder withApplyTagFilterToItNetworks(boolean applyTagFilterToItNetworks) {
            this.parameters.applyTagFilterToItNetworks = applyTagFilterToItNetworks;
            return this;
        }

        public Builder withTags(@NonNull Set<String> selectedTags) {
            this.parameters.tags = CollectionUtil.unmodifiableSet(selectedTags);
            return this;
        }

        public Builder withElementTypes(@NonNull Set<String> selectedElementTypes) {
            this.parameters.elementTypes = CollectionUtil.unmodifiableSet(selectedElementTypes);
            return this;
        }

        public Builder withSecurityLevels(@NonNull Set<SecurityLevel> selectedSecurityLevels) {
            this.parameters.securityLevels = CollectionUtil.unmodifiableSet(selectedSecurityLevels);
            return this;
        }

        public Builder withImplementationStatuses(@NonNull Set<ImplementationStatus> selectedImplementationStatus) {
            this.parameters.implementationStatuses = CollectionUtil.unmodifiableSet(selectedImplementationStatus);
            return this;
        }

        public Builder withAuditPerformed(Optional<Boolean> auditPerformed) {
            this.parameters.auditPerformed = auditPerformed;
            return this;
        }

        public Builder withChangeTypes(Set<ChangeType> changeTypes) {
            this.parameters.changeTypes = changeTypes;
            return this;
        }

        public Builder withReleases(@NonNull Set<String> releases) {
            this.parameters.releases = releases;
            return this;
        }

        public Builder withRiskAnalysisNecessary(Optional<Boolean> riskanalysisNecessary) {
            this.parameters.riskAnalysisNecessary = riskanalysisNecessary;
            return this;
        }

        public Builder withRiskLabels(Set<String> risks) {
            this.parameters.riskLabels = risks;
            return this;
        }
    }
}

