/*
 * Decompiled with CFR 0.152.
 */
package sernet.verinice.bp.rcp.filter;

import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import sernet.gs.ui.rcp.main.ImageCache;
import sernet.gs.ui.rcp.main.common.model.CnAElementHome;
import sernet.hui.common.VeriniceContext;
import sernet.hui.common.connect.HUITypeFactory;
import sernet.verinice.bp.rcp.filter.BaseProtectionFilterParameters;
import sernet.verinice.bp.rcp.filter.Messages;
import sernet.verinice.bp.rcp.filter.OptionalBooleanDropDown;
import sernet.verinice.interfaces.CommandException;
import sernet.verinice.interfaces.ICommand;
import sernet.verinice.interfaces.ICommandService;
import sernet.verinice.model.bp.ChangeType;
import sernet.verinice.model.bp.ImplementationStatus;
import sernet.verinice.model.bp.SecurityLevel;
import sernet.verinice.service.bp.risk.RiskService;
import sernet.verinice.service.commands.QueryDynamicPropertyValuesCommand;

public class BaseProtectionFilterDialog
extends Dialog {
    private static final String[] BASE_PROTECTION_TYPES = new String[]{"bp_businessprocess", "bp_application", "bp_itsystem", "bp_icssystem", "bp_device", "bp_network", "bp_room", "bp_person", "bp_requirement", "bp_threat", "bp_safeguard", "bp_document", "bp_incident", "bp_record"};
    private static final int VIEWER_TABLE_WIDTH = 470;
    private static final int VIEWER_TABLE_HEIGHT = 135;
    private Set<Button> changeTypeButtons = new HashSet<Button>();
    private Set<Button> implementationStatusButtons = new HashSet<Button>();
    private Set<Button> releaseButtons = new HashSet<Button>();
    private Set<Button> qualifierButtons = new HashSet<Button>();
    private Set<Button> risklabelButtons = new HashSet<Button>();
    private CheckboxTableViewer elementTypeSelector;
    private CheckboxTableViewer tagsSelector;
    private Button applyTagFilterToItNetworksCheckbox;
    private Button hideEmptyGroupsCheckbox;
    private OptionalBooleanDropDown auditPerformedDropdown;
    private OptionalBooleanDropDown riskAnalysisNecessaryDropDown;
    private @NonNull BaseProtectionFilterParameters filterParameters;
    private final @NonNull BaseProtectionFilterParameters defaultFilterParams;

    public BaseProtectionFilterDialog(Shell parentShell, @NonNull BaseProtectionFilterParameters filterParameters, @NonNull BaseProtectionFilterParameters defaultFilterParams) {
        super(parentShell);
        this.filterParameters = filterParameters;
        this.defaultFilterParams = defaultFilterParams;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(Messages.BaseProtectionFilterDialog_Title);
    }

    protected boolean isResizable() {
        return true;
    }

    protected Control createDialogArea(Composite parent) {
        Composite container = (Composite)super.createDialogArea(parent);
        ScrolledComposite scrollOfComposition = new ScrolledComposite(container, 512);
        scrollOfComposition.setExpandHorizontal(true);
        scrollOfComposition.setExpandVertical(true);
        scrollOfComposition.setMinSize(300, 300);
        Composite content = new Composite((Composite)scrollOfComposition, 0);
        scrollOfComposition.setContent((Control)content);
        content.setLayout((Layout)new GridLayout());
        GridData data = new GridData(4, 4, true, true);
        data.heightHint = 500;
        scrollOfComposition.setLayoutData((Object)data);
        Label intro = new Label(content, 0);
        intro.setText(Messages.BaseProtectionFilterDialog_IntroText);
        this.addFiltersForRequirementsAndSafeguards(content);
        try {
            this.addReleaseGroup(content);
        }
        catch (CommandException ex) {
            throw new RuntimeException("Failed to initialize release filter.", ex);
        }
        this.addChangeTypeGroup(content);
        this.addRiskLabelGroup(content);
        this.addRiskAnalysisNecessaryGroup(content);
        this.addAuditPerformedGroup(content);
        this.addElementTypesGroup(content);
        try {
            this.addTagsGroup(content);
        }
        catch (CommandException e) {
            throw new RuntimeException("Failed to initialize filter", e);
        }
        this.addApplyTagFilterToItNetworksGroup(content);
        this.addHideEmptyGroup(content);
        this.setValues(this.filterParameters);
        scrollOfComposition.setMinSize(content.computeSize(-1, -1));
        return parent;
    }

    private void addFiltersForRequirementsAndSafeguards(Composite parent) {
        Group boxesComposite = new Group(parent, 2048);
        boxesComposite.setLayoutData((Object)new GridData(4, 1, false, false));
        GridLayout layout = new GridLayout();
        boxesComposite.setLayout((Layout)layout);
        boxesComposite.setText(Messages.BaseProtectionFilterDialog_FiltersForRequirementsAndSafeguards);
        this.addImplementationStatusGroup((Composite)boxesComposite);
        this.addQualiferGroup((Composite)boxesComposite);
    }

    private void addImplementationStatusGroup(Composite parent) {
        Group boxesComposite = new Group(parent, 0);
        boxesComposite.setText(Messages.BaseProtectionFilterDialog_ImplementationState);
        GridData gridData = new GridData(4, 2, true, false, 1, 1);
        boxesComposite.setLayoutData((Object)gridData);
        GridLayout layout = new GridLayout(ImplementationStatus.values().length + 1, false);
        boxesComposite.setLayout((Layout)layout);
        ImplementationStatus[] implementationStatusArray = ImplementationStatus.values();
        int n = implementationStatusArray.length;
        int n2 = 0;
        while (n2 < n) {
            ImplementationStatus status = implementationStatusArray[n2];
            this.implementationStatusButtons.add(this.addButton(boxesComposite, status, status.getLabel()));
            ++n2;
        }
        this.implementationStatusButtons.add(this.addButton(boxesComposite, null, Messages.BaseProtectionFilterDialog_Property_Value_Null));
    }

    private void addQualiferGroup(Composite parent) {
        Group boxesComposite = new Group(parent, 0);
        boxesComposite.setText(Messages.BaseProtectionFilterDialog_Qualifier);
        GridData gridData = new GridData(4, 2, true, false, 1, 1);
        boxesComposite.setLayoutData((Object)gridData);
        GridLayout layout = new GridLayout(SecurityLevel.values().length + 1, false);
        boxesComposite.setLayout((Layout)layout);
        SecurityLevel[] securityLevelArray = SecurityLevel.values();
        int n = securityLevelArray.length;
        int n2 = 0;
        while (n2 < n) {
            SecurityLevel qualifier = securityLevelArray[n2];
            this.qualifierButtons.add(this.addButton(boxesComposite, qualifier, qualifier.getLabel()));
            ++n2;
        }
        this.qualifierButtons.add(this.addButton(boxesComposite, null, Messages.BaseProtectionFilterDialog_Property_Value_Null));
    }

    private void addAuditPerformedGroup(Composite container) {
        Group boxesComposite = new Group(container, 0);
        boxesComposite.setText(Messages.BaseProtectionFilterDialog_AuditPerformed);
        GridData gridData = new GridData(4, 2, true, false, 1, 1);
        boxesComposite.setLayoutData((Object)gridData);
        GridLayout layout = new GridLayout(1, false);
        boxesComposite.setLayout((Layout)layout);
        this.auditPerformedDropdown = new OptionalBooleanDropDown((Composite)boxesComposite);
    }

    private void addChangeTypeGroup(Composite parent) {
        ChangeType[] choices = ChangeType.values();
        Group boxesComposite = new Group(parent, 0);
        boxesComposite.setText(Messages.BaseProtectionFilterDialog_ChangeType);
        GridData gridData = new GridData(4, 2, true, false, 1, 1);
        boxesComposite.setLayoutData((Object)gridData);
        GridLayout layout = new GridLayout(choices.length + 1, false);
        boxesComposite.setLayout((Layout)layout);
        ChangeType[] changeTypeArray = choices;
        int n = choices.length;
        int n2 = 0;
        while (n2 < n) {
            ChangeType changeType = changeTypeArray[n2];
            this.changeTypeButtons.add(this.addButton(boxesComposite, changeType, changeType.getLabel()));
            ++n2;
        }
    }

    private void addReleaseGroup(Composite parent) throws CommandException {
        QueryDynamicPropertyValuesCommand command = new QueryDynamicPropertyValuesCommand();
        command.setPropertyType("release");
        command = (QueryDynamicPropertyValuesCommand)this.createCommandService().executeCommand((ICommand)command);
        List choices = command.getValues();
        Group boxesComposite = new Group(parent, 0);
        boxesComposite.setText(Messages.BaseProtectionFilterDialog_Releases);
        GridData gridData = new GridData(4, 2, true, false, 1, 1);
        boxesComposite.setLayoutData((Object)gridData);
        GridLayout layout = new GridLayout(choices.size() + 1, false);
        boxesComposite.setLayout((Layout)layout);
        for (String release : choices) {
            this.releaseButtons.add(this.addButton(boxesComposite, release, release));
        }
    }

    private void addRiskAnalysisNecessaryGroup(Composite container) {
        Group boxesComposite = new Group(container, 0);
        boxesComposite.setText(Messages.BaseProtectionFilterDialog_RiskanalysisNecessary);
        GridData gridData = new GridData(4, 2, true, false, 1, 1);
        boxesComposite.setLayoutData((Object)gridData);
        GridLayout layout = new GridLayout(1, false);
        boxesComposite.setLayout((Layout)layout);
        this.riskAnalysisNecessaryDropDown = new OptionalBooleanDropDown((Composite)boxesComposite);
    }

    private void addRiskLabelGroup(Composite parent) {
        List choices = this.getRiskService().findAllRiskLabels();
        Group boxesComposite = new Group(parent, 0);
        boxesComposite.setText(Messages.BaseProtectionFilterDialog_Risk);
        GridData gridData = new GridData(4, 2, true, false, 1, 1);
        boxesComposite.setLayoutData((Object)gridData);
        GridLayout layout = new GridLayout(choices.size() + 1, false);
        boxesComposite.setLayout((Layout)layout);
        for (String risk : choices) {
            this.risklabelButtons.add(this.addButton(boxesComposite, risk, risk));
        }
    }

    private Button addButton(Group container, Object value, String label) {
        Button button = new Button((Composite)container, 32);
        button.setText(label);
        button.setData(value);
        return button;
    }

    private void addElementTypesGroup(Composite container) {
        Group elementTypes = new Group(container, 0);
        elementTypes.setText(Messages.BaseProtectionFilterDialog_Objects);
        GridData gridData = new GridData(4, 2, true, false, 1, 1);
        elementTypes.setLayoutData((Object)gridData);
        elementTypes.setLayout((Layout)new GridLayout());
        ScrolledComposite scrolledComposite = new ScrolledComposite((Composite)elementTypes, 512);
        scrolledComposite.setLayoutData((Object)new GridData(1808));
        scrolledComposite.setExpandHorizontal(true);
        this.elementTypeSelector = CheckboxTableViewer.newCheckList((Composite)scrolledComposite, (int)2048);
        Table table = this.elementTypeSelector.getTable();
        table.setLayoutData((Object)new GridData(4, 1, false, false));
        this.elementTypeSelector.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.elementTypeSelector.setInput((Object)BASE_PROTECTION_TYPES);
        this.elementTypeSelector.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                return BaseProtectionFilterDialog.getTypeFactory().getMessage((String)element);
            }

            public Image getImage(Object element) {
                return ImageCache.getInstance().getImageForTypeId((String)element);
            }
        });
        scrolledComposite.setContent((Control)table);
        table.setSize(470, 135);
    }

    private void addTagsGroup(Composite container) throws CommandException {
        Group tags = new Group(container, 0);
        tags.setText(Messages.BaseProtectionFilterDialog_Tags);
        GridData gridData = new GridData(4, 2, true, false, 1, 1);
        tags.setLayoutData((Object)gridData);
        tags.setLayout((Layout)new GridLayout());
        ScrolledComposite scrolledComposite = new ScrolledComposite((Composite)tags, 512);
        scrolledComposite.setLayoutData((Object)new GridData(1808));
        scrolledComposite.setExpandHorizontal(true);
        this.tagsSelector = CheckboxTableViewer.newCheckList((Composite)scrolledComposite, (int)2048);
        Table table = this.tagsSelector.getTable();
        table.setLayoutData((Object)new GridData(4, 1, false, false));
        this.tagsSelector.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        List<String> availableTags = CnAElementHome.getInstance().getTags();
        availableTags.add(0, "NO_TAG");
        this.tagsSelector.setInput(availableTags);
        this.tagsSelector.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                return (String)element;
            }
        });
        scrolledComposite.setContent((Control)table);
        table.setSize(470, 135);
    }

    private void addApplyTagFilterToItNetworksGroup(Composite parent) {
        Group groupComposite = new Group(parent, 2048);
        GridData gridData = new GridData(4, 3, true, false);
        groupComposite.setLayoutData((Object)gridData);
        groupComposite.setLayout((Layout)new GridLayout(1, false));
        this.applyTagFilterToItNetworksCheckbox = new Button((Composite)groupComposite, 32);
        this.applyTagFilterToItNetworksCheckbox.setText(Messages.BaseProtectionFilterDialog_Apply_Tag_Filter_To_IT_Networks);
    }

    private void addHideEmptyGroup(Composite parent) {
        Group groupComposite = new Group(parent, 2048);
        GridData gridData = new GridData(4, 3, true, false);
        groupComposite.setLayoutData((Object)gridData);
        groupComposite.setLayout((Layout)new GridLayout(1, false));
        this.hideEmptyGroupsCheckbox = new Button((Composite)groupComposite, 32);
        this.hideEmptyGroupsCheckbox.setText(Messages.BaseProtectionFilterDialog_Hide_Empty_Groups);
    }

    private void setValues(BaseProtectionFilterParameters params) {
        boolean isSelected;
        for (Button button : this.changeTypeButtons) {
            isSelected = params.getChangeTypes().contains(button.getData());
            button.setSelection(isSelected);
        }
        for (Button button : this.implementationStatusButtons) {
            isSelected = params.getImplementationStatuses().contains(button.getData());
            button.setSelection(isSelected);
        }
        for (Button button : this.qualifierButtons) {
            isSelected = params.getSecurityLevels().contains(button.getData());
            button.setSelection(isSelected);
        }
        for (Button button : this.releaseButtons) {
            isSelected = params.getReleases().contains(button.getData());
            button.setSelection(isSelected);
        }
        for (Button button : this.risklabelButtons) {
            isSelected = params.getRiskLabels().contains(button.getData());
            button.setSelection(isSelected);
        }
        this.auditPerformedDropdown.select(params.getAuditPerformed());
        this.riskAnalysisNecessaryDropDown.select(params.getRiskAnalysisNecessary());
        this.elementTypeSelector.setCheckedElements((Object[])params.getElementTypes().toArray(new String[params.getElementTypes().size()]));
        this.tagsSelector.setCheckedElements((Object[])params.getTags().toArray(new String[params.getTags().size()]));
        this.applyTagFilterToItNetworksCheckbox.setSelection(params.isApplyTagFilterToItNetworks());
        this.hideEmptyGroupsCheckbox.setSelection(params.isHideEmptyGroups());
    }

    protected void createButtonsForButtonBar(Composite parent) {
        Button clearFilterButton = this.createButton(parent, 3, Messages.BaseProtectionFilterDialog_Clear, false);
        clearFilterButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BaseProtectionFilterDialog.this.setValues(BaseProtectionFilterDialog.this.defaultFilterParams);
            }
        });
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    public boolean close() {
        HashSet<ImplementationStatus> statuses = new HashSet<ImplementationStatus>(ImplementationStatus.values().length);
        for (Button button : this.implementationStatusButtons) {
            if (!button.getSelection()) continue;
            statuses.add((ImplementationStatus)button.getData());
        }
        HashSet<SecurityLevel> levels = new HashSet<SecurityLevel>(SecurityLevel.values().length);
        for (Button button : this.qualifierButtons) {
            if (!button.getSelection()) continue;
            levels.add((SecurityLevel)button.getData());
        }
        Set<String> releases = this.releaseButtons.stream().filter(b -> b.getSelection()).map(b -> (String)b.getData()).collect(Collectors.toSet());
        Optional<Boolean> auditPerformed = this.auditPerformedDropdown.getSelection();
        Optional<Boolean> riskanalysisNecessary = this.riskAnalysisNecessaryDropDown.getSelection();
        Set<String> riskLabels = this.risklabelButtons.stream().filter(b -> b.getSelection()).map(b -> (String)b.getData()).collect(Collectors.toSet());
        Set<ChangeType> changeTypes = this.changeTypeButtons.stream().filter(b -> b.getSelection()).map(b -> (ChangeType)b.getData()).collect(Collectors.toSet());
        Object[] checkedElements = this.elementTypeSelector.getCheckedElements();
        HashSet<String> types = new HashSet<String>(checkedElements.length);
        Object[] objectArray = checkedElements;
        int n = checkedElements.length;
        int n2 = 0;
        while (n2 < n) {
            Object checkedElementType = objectArray[n2];
            types.add((String)checkedElementType);
            ++n2;
        }
        HashSet<String> tags = new HashSet<String>();
        Object[] objectArray2 = this.tagsSelector.getCheckedElements();
        int n3 = objectArray2.length;
        n = 0;
        while (n < n3) {
            Object checkedTag = objectArray2[n];
            tags.add((String)checkedTag);
            ++n;
        }
        this.filterParameters = BaseProtectionFilterParameters.builder().withAuditPerformed(auditPerformed).withImplementationStatuses(statuses).withSecurityLevels(levels).withElementTypes(types).withTags(tags).withChangeTypes(changeTypes).withReleases(releases).withRiskAnalysisNecessary(riskanalysisNecessary).withRiskLabels(riskLabels).withApplyTagFilterToItNetworks(this.applyTagFilterToItNetworksCheckbox.getSelection()).withHideEmptyGroups(this.hideEmptyGroupsCheckbox.getSelection()).build();
        return super.close();
    }

    private RiskService getRiskService() {
        return (RiskService)VeriniceContext.get((String)"itbpRiskService");
    }

    private static HUITypeFactory getTypeFactory() {
        return (HUITypeFactory)VeriniceContext.get((String)"huiTypeFactory");
    }

    private ICommandService createCommandService() {
        return (ICommandService)VeriniceContext.get((String)"commandService");
    }

    public @NonNull BaseProtectionFilterParameters getFilterParameters() {
        return this.filterParameters;
    }
}

