/*
 * Decompiled with CFR 0.152.
 */
package sernet.verinice.bp.rcp.filter;

import java.util.Collection;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import sernet.gs.ui.rcp.main.Activator;
import sernet.gs.ui.rcp.main.common.model.CnATreeElementScopeUtils;
import sernet.hui.common.connect.ITaggableElement;
import sernet.verinice.bp.rcp.filter.BaseProtectionFilterParameters;
import sernet.verinice.bp.rcp.filter.DynamicBooleanPropertyFilter;
import sernet.verinice.bp.rcp.filter.DynamicEnumPropertyFilter;
import sernet.verinice.bp.rcp.filter.DynamicStringPropertyFilter;
import sernet.verinice.bp.rcp.filter.RecursiveTreeFilter;
import sernet.verinice.bp.rcp.filter.RiskLabelFilter;
import sernet.verinice.bp.rcp.filter.ThreatByProceedingFilterUtil;
import sernet.verinice.model.bp.ChangeType;
import sernet.verinice.model.bp.ISecurityLevelProvider;
import sernet.verinice.model.bp.ImplementationStatus;
import sernet.verinice.model.bp.Proceeding;
import sernet.verinice.model.bp.SecurityLevel;
import sernet.verinice.model.bp.elements.BpRequirement;
import sernet.verinice.model.bp.elements.BpThreat;
import sernet.verinice.model.bp.elements.ItNetwork;
import sernet.verinice.model.bp.elements.Safeguard;
import sernet.verinice.model.bp.groups.BpRequirementGroup;
import sernet.verinice.model.bp.groups.ImportBpGroup;
import sernet.verinice.model.bp.groups.SafeguardGroup;
import sernet.verinice.model.common.CnATreeElement;
import sernet.verinice.model.iso27k.Group;

public class BaseProtectionFilterBuilder {
    private BaseProtectionFilterBuilder() {
    }

    public static @NonNull Collection<ViewerFilter> makeFilters(BaseProtectionFilterParameters params, IPreferenceStore prererenceStore) {
        return Stream.of(BaseProtectionFilterBuilder.createRequirementSafeguardFilter(params), BaseProtectionFilterBuilder.createAuditPerformedFilter(params), BaseProtectionFilterBuilder.createChangeTypeFilter(params), BaseProtectionFilterBuilder.createReleaseFilter(params), BaseProtectionFilterBuilder.createRiskAnalysisNecessaryFilter(params), BaseProtectionFilterBuilder.createRiskLabelFilter(params), BaseProtectionFilterBuilder.createTypeFilter(params), BaseProtectionFilterBuilder.createTagFilter(params), BaseProtectionFilterBuilder.createHideEmptyGroupsFilter(params), BaseProtectionFilterBuilder.createProceedingFilter(prererenceStore)).filter(Objects::nonNull).collect(Collectors.toList());
    }

    private static ViewerFilter createAuditPerformedFilter(BaseProtectionFilterParameters params) {
        return params.getAuditPerformed().map(v -> new DynamicBooleanPropertyFilter("audit_performed", (Boolean)v)).orElse(null);
    }

    private static ViewerFilter createChangeTypeFilter(BaseProtectionFilterParameters params) {
        if (!params.getChangeTypes().isEmpty()) {
            return new RecursiveTreeFilter(new DynamicEnumPropertyFilter<ChangeType>("change_type", ChangeType.class, params.getChangeTypes()), 1);
        }
        return null;
    }

    private static ViewerFilter createReleaseFilter(BaseProtectionFilterParameters params) {
        if (!params.getReleases().isEmpty()) {
            return new RecursiveTreeFilter(new DynamicStringPropertyFilter("release", params.getReleases()), 1);
        }
        return null;
    }

    private static ViewerFilter createRiskAnalysisNecessaryFilter(BaseProtectionFilterParameters params) {
        return params.getRiskAnalysisNecessary().map(v -> new DynamicBooleanPropertyFilter("riskanalysis_necessary", (Boolean)v)).orElse(null);
    }

    public static @NonNull Collection<ViewerFilter> makeFilters(BaseProtectionFilterParameters params) {
        return BaseProtectionFilterBuilder.makeFilters(params, Activator.getDefault().getPreferenceStore());
    }

    private static ViewerFilter createRiskLabelFilter(BaseProtectionFilterParameters params) {
        if (!params.getRiskLabels().isEmpty()) {
            return new RiskLabelFilter(params.getRiskLabels());
        }
        return null;
    }

    private static ViewerFilter createRequirementSafeguardFilter(BaseProtectionFilterParameters filterParameters) {
        if (!filterParameters.getImplementationStatuses().isEmpty() || !filterParameters.getSecurityLevels().isEmpty()) {
            return new RecursiveTreeFilter(new RequirementSafeguardFilter(filterParameters.getImplementationStatuses(), filterParameters.getSecurityLevels(), filterParameters.isHideEmptyGroups(), filterParameters.getElementTypes()));
        }
        return null;
    }

    private static ViewerFilter createTypeFilter(BaseProtectionFilterParameters filterParameters) {
        if (!filterParameters.getElementTypes().isEmpty()) {
            return new RecursiveTreeFilter(new TypeFilter(filterParameters.getElementTypes(), filterParameters.isHideEmptyGroups()));
        }
        return null;
    }

    private static ViewerFilter createProceedingFilter(IPreferenceStore preferenceStore) {
        return new ProceedingFilter(preferenceStore);
    }

    private static ViewerFilter createTagFilter(final BaseProtectionFilterParameters filterParameters) {
        if (!filterParameters.getTags().isEmpty()) {
            return new RecursiveTreeFilter((ViewerFilter)new TagFilter(filterParameters.getTags(), filterParameters.isApplyTagFilterToItNetworks(), filterParameters.isHideEmptyGroups())){

                @Override
                protected boolean checkChildren(CnATreeElement cnATreeElement) {
                    if (filterParameters.isApplyTagFilterToItNetworks() && cnATreeElement instanceof ItNetwork) {
                        return false;
                    }
                    return super.checkChildren(cnATreeElement);
                }
            };
        }
        return null;
    }

    private static ViewerFilter createHideEmptyGroupsFilter(BaseProtectionFilterParameters filterParameters) {
        if (filterParameters.isHideEmptyGroups()) {
            return new RecursiveTreeFilter(HideEmptyGroupsFilter.INSTANCE);
        }
        return null;
    }

    private static final class HideEmptyGroupsFilter
    extends ViewerFilter {
        private static final HideEmptyGroupsFilter INSTANCE = new HideEmptyGroupsFilter();

        private HideEmptyGroupsFilter() {
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            return !(element instanceof Group);
        }
    }

    private static final class ProceedingFilter
    extends ViewerFilter {
        private final IPreferenceStore preferenceStore;

        public ProceedingFilter(IPreferenceStore preferenceStore) {
            this.preferenceStore = preferenceStore;
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            boolean filterByProceeding = this.preferenceStore.getBoolean("filter_information_networks_by_proceeding");
            if (filterByProceeding && element instanceof CnATreeElement) {
                if (element instanceof BpThreat) {
                    return ThreatByProceedingFilterUtil.showThreatWhenProceedingFilterIsEnabled((BpThreat)element);
                }
                if (element instanceof ISecurityLevelProvider) {
                    SecurityLevel securityLevel = ((ISecurityLevelProvider)element).getSecurityLevel();
                    return this.scopeRequiresSecurityLevel((CnATreeElement)element, securityLevel);
                }
            }
            return true;
        }

        private boolean scopeRequiresSecurityLevel(CnATreeElement element, SecurityLevel securityLevel) {
            CnATreeElement scope = CnATreeElementScopeUtils.getScope(element);
            if (scope instanceof ItNetwork) {
                ItNetwork itNetwork = (ItNetwork)scope;
                Proceeding proceeding = itNetwork.getProceeding();
                if (proceeding == null) {
                    return true;
                }
                return proceeding.requires(securityLevel);
            }
            return true;
        }
    }

    private static final class RequirementSafeguardFilter
    extends ViewerFilter {
        private final Collection<ImplementationStatus> selectedImplementationStatus;
        private final Collection<SecurityLevel> selectedSecurityLevels;
        private final Collection<String> selectedElementTypes;
        private final boolean hideEmptyGroups;

        RequirementSafeguardFilter(Collection<ImplementationStatus> selectedImplementationStatus, Collection<SecurityLevel> selectedSecurityLevels, boolean hideEmptyGroups, Collection<String> selectedElementTypes) {
            this.selectedImplementationStatus = selectedImplementationStatus;
            this.selectedSecurityLevels = selectedSecurityLevels;
            this.hideEmptyGroups = hideEmptyGroups;
            this.selectedElementTypes = selectedElementTypes;
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            if (!this.hideEmptyGroups && element instanceof Group || element instanceof ItNetwork) {
                return true;
            }
            if (this.hideEmptyGroups && (element instanceof BpRequirementGroup || element instanceof SafeguardGroup)) {
                return false;
            }
            if (!RequirementSafeguardFilter.emptyOrContains(this.selectedElementTypes, ((CnATreeElement)element).getTypeId())) {
                return false;
            }
            if (element instanceof BpRequirement) {
                return RequirementSafeguardFilter.emptyOrContains(this.selectedImplementationStatus, ((BpRequirement)element).getImplementationStatus()) && RequirementSafeguardFilter.emptyOrContains(this.selectedSecurityLevels, ((BpRequirement)element).getSecurityLevel());
            }
            if (element instanceof Safeguard) {
                return RequirementSafeguardFilter.emptyOrContains(this.selectedImplementationStatus, ((Safeguard)element).getImplementationStatus()) && RequirementSafeguardFilter.emptyOrContains(this.selectedSecurityLevels, ((Safeguard)element).getSecurityLevel());
            }
            return true;
        }

        private static <T> boolean emptyOrContains(Collection<T> collection, T value) {
            return collection.isEmpty() || collection.contains(value);
        }
    }

    private static final class TagFilter
    extends ViewerFilter {
        private final Set<String> selectedTags;
        private final boolean applyTagFilterToItNetworks;
        private final boolean hideEmptyGroups;

        TagFilter(Set<String> selectedTags, boolean applyTagFilterToItNetworks, boolean hideEmptyGroups) {
            this.selectedTags = selectedTags;
            this.applyTagFilterToItNetworks = applyTagFilterToItNetworks;
            this.hideEmptyGroups = hideEmptyGroups;
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            if (!this.hideEmptyGroups && element instanceof Group) {
                return true;
            }
            if (!(element instanceof ITaggableElement)) {
                return false;
            }
            if ((element instanceof ItNetwork || element instanceof ImportBpGroup) && !this.applyTagFilterToItNetworks) {
                return true;
            }
            ITaggableElement taggableElement = (ITaggableElement)element;
            Collection elementTags = taggableElement.getTags();
            boolean elementHasNoTags = elementTags.isEmpty();
            if (elementHasNoTags) {
                return this.selectedTags.contains("NO_TAG");
            }
            for (String selectedTag : this.selectedTags) {
                if (!elementTags.contains(selectedTag)) continue;
                return true;
            }
            return false;
        }
    }

    private static final class TypeFilter
    extends ViewerFilter {
        private final Collection<String> selectedElementTypes;
        private final boolean hideEmptyGroups;

        TypeFilter(Collection<String> selectedElementTypes, boolean hideEmptyGroups) {
            this.selectedElementTypes = selectedElementTypes;
            this.hideEmptyGroups = hideEmptyGroups;
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            if (!this.hideEmptyGroups && element instanceof Group || element instanceof ItNetwork) {
                return true;
            }
            CnATreeElement cnATreeElement = (CnATreeElement)element;
            return this.selectedElementTypes.contains(cnATreeElement.getTypeId());
        }
    }
}

