/*
 * Decompiled with CFR 0.152.
 */
package sernet.verinice.bp.rcp.filter;

import java.util.Collection;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.widgets.Display;
import sernet.gs.ui.rcp.main.ImageCache;
import sernet.verinice.bp.rcp.filter.BaseProtectionFilterBuilder;
import sernet.verinice.bp.rcp.filter.BaseProtectionFilterDialog;
import sernet.verinice.bp.rcp.filter.BaseProtectionFilterParameters;

public class BaseProtectionFilterAction
extends Action {
    private StructuredViewer viewer;
    private @NonNull BaseProtectionFilterParameters filterParameters;
    private final @NonNull BaseProtectionFilterParameters defaultFilterParams;

    public BaseProtectionFilterAction(StructuredViewer viewer, @NonNull BaseProtectionFilterParameters defaultFilterParams) {
        super("Filter...");
        this.viewer = viewer;
        this.defaultFilterParams = defaultFilterParams;
        this.filterParameters = defaultFilterParams;
        this.setImageDescriptor(ImageCache.getInstance().getImageDescriptor("filter_tsk.gif"));
    }

    public void run() {
        BaseProtectionFilterDialog dialog = new BaseProtectionFilterDialog(Display.getCurrent().getActiveShell(), this.filterParameters, this.defaultFilterParams);
        if (dialog.open() != 0) {
            return;
        }
        this.filterParameters = dialog.getFilterParameters();
        Collection<ViewerFilter> viewerFilters = BaseProtectionFilterBuilder.makeFilters(this.filterParameters);
        ViewerFilter[] filtersAsArray = viewerFilters.toArray(new ViewerFilter[viewerFilters.size()]);
        this.viewer.setFilters(filtersAsArray);
        if (this.defaultFilterParams.equals(this.filterParameters)) {
            this.setImageDescriptor(ImageCache.getInstance().getImageDescriptor("filter_tsk.gif"));
        } else {
            this.setImageDescriptor(ImageCache.getInstance().getImageDescriptor("filter_tsk_active.gif"));
        }
    }
}

