/*
 * Decompiled with CFR 0.152.
 */
package sernet.verinice.bp.rcp.converter;

import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import sernet.gs.ui.rcp.main.ItNetworkMultiselectWidget;
import sernet.verinice.bp.rcp.converter.Messages;
import sernet.verinice.interfaces.CommandException;
import sernet.verinice.model.common.CnATreeElement;
import sernet.verinice.rcp.account.BaseWizardPage;

public class ItNetworkPage
extends BaseWizardPage {
    private static final Logger LOG = Logger.getLogger(ItNetworkPage.class);
    public static final String PAGE_NAME = "bp-converter-wizard-it-network-page";
    private ITreeSelection selection;
    private CnATreeElement selectedElement;
    private List<Integer> itNetworkIds = new LinkedList<Integer>();
    private ItNetworkMultiselectWidget itNetworkWidget = null;

    public ItNetworkPage() {
        this((CnATreeElement)null);
    }

    public ItNetworkPage(ITreeSelection selection) {
        this((CnATreeElement)null);
        this.selection = selection;
    }

    public ItNetworkPage(CnATreeElement selectedItNetwork) {
        super(PAGE_NAME);
        this.selectedElement = selectedItNetwork;
    }

    @Override
    protected void initGui(Composite composite) {
        int layoutMarginWidth = 10;
        int layoutMarginHeight = 10;
        this.setTitle(Messages.ItNetworkPage_Title);
        this.setMessage(Messages.ItNetworkPage_Message);
        GridLayout layout = (GridLayout)composite.getLayout();
        layout.marginWidth = 10;
        layout.marginHeight = 10;
        GridData gd = new GridData(4, 4, true, true);
        composite.setLayoutData((Object)gd);
        try {
            this.itNetworkWidget = new ItNetworkMultiselectWidget(composite, this.selection, this.selectedElement);
        }
        catch (CommandException ex) {
            LOG.error((Object)"Error while loading IT networks", (Throwable)ex);
            this.setMessage(Messages.ItNetworkPage_Error, 3);
        }
        SelectionAdapter organizationListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ItNetworkPage.this.syncSelectedItNetworks();
                super.widgetSelected(e);
            }
        };
        this.itNetworkWidget.addSelectionListener((SelectionListener)organizationListener);
        this.syncSelectedItNetworks();
        composite.pack();
    }

    @Override
    protected void initData() throws Exception {
    }

    public boolean isPageComplete() {
        boolean complete;
        boolean bl = complete = !this.itNetworkIds.isEmpty();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Page complete: " + complete));
        }
        return complete;
    }

    private void syncSelectedItNetworks() {
        this.itNetworkIds.clear();
        if (this.itNetworkWidget.getSelectedElementSet() != null) {
            Set selectedOrganizations = this.itNetworkWidget.getSelectedElementSet();
            for (CnATreeElement organization : selectedOrganizations) {
                this.itNetworkIds.add(organization.getDbId());
            }
        }
        this.setPageComplete(this.isPageComplete());
    }

    public Set<CnATreeElement> getSelectedElementSet() {
        return this.itNetworkWidget.getSelectedElementSet();
    }

    public CnATreeElement getSelectedElement() {
        return (CnATreeElement)this.itNetworkWidget.getSelectedElement();
    }

    public List<Integer> getItNetworkIds() {
        return this.itNetworkIds;
    }
}

