/*
 * Decompiled with CFR 0.152.
 */
package sernet.verinice.bp.rcp.converter;

import java.lang.reflect.InvocationTargetException;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import sernet.gs.ui.rcp.main.common.model.CnAElementFactory;
import sernet.hui.common.VeriniceContext;
import sernet.verinice.bp.rcp.converter.ItNetworkPage;
import sernet.verinice.bp.rcp.converter.Messages;
import sernet.verinice.interfaces.CommandException;
import sernet.verinice.interfaces.ICommand;
import sernet.verinice.interfaces.ICommandService;
import sernet.verinice.model.common.CnATreeElement;
import sernet.verinice.service.commands.bp.converter.ConverterCommand;

public class ItNetworkConverterWizard
extends Wizard {
    private static final Logger log = Logger.getLogger(ItNetworkConverterWizard.class);
    private CnATreeElement selectedItNetwork = null;
    private ItNetworkPage itNetworkPage;
    private ICommandService commandService;

    public ItNetworkConverterWizard() {
        this.init();
    }

    public ItNetworkConverterWizard(CnATreeElement selectedOrganization) {
        this();
        this.selectedItNetwork = selectedOrganization;
    }

    private void init() {
        this.setNeedsProgressMonitor(true);
        this.setWindowTitle(Messages.ItNetworkConverterWizard_WindowTitle);
    }

    public void addPages() {
        this.itNetworkPage = new ItNetworkPage(this.selectedItNetwork);
        this.addPage((IWizardPage)this.itNetworkPage);
    }

    public boolean performFinish() {
        try {
            this.itNetworkPage.setMessage(Messages.ItNetworkConverterWizard_PageTitle, 1);
            this.runConvertingInWizard();
            CnAElementFactory.getInstance().reloadBpModelFromDatabase();
        }
        catch (InterruptedException | InvocationTargetException e) {
            log.error((Object)"InvocationTargetException or InterruptedException during conversion", (Throwable)e);
            this.itNetworkPage.setMessage(Messages.ItNetworkConverterWizard_ErrorInformation, 3);
            return false;
        }
        return true;
    }

    private void runConvertingInWizard() throws InvocationTargetException, InterruptedException {
        this.getContainer().run(true, false, new IRunnableWithProgress(){

            public void run(IProgressMonitor progressMonitor) throws InvocationTargetException, InterruptedException {
                progressMonitor.beginTask(Messages.ItNetworkConverterWizard_ConvertingIsRunning, -1);
                ItNetworkConverterWizard.this.runConverting();
                progressMonitor.done();
            }
        });
    }

    private void runConverting() {
        Set<CnATreeElement> selectedItNetworks = this.itNetworkPage.getSelectedElementSet();
        Set itNetworkUuidSet = selectedItNetworks.stream().map(CnATreeElement::getUuid).collect(Collectors.toSet());
        ConverterCommand command = new ConverterCommand(itNetworkUuidSet);
        try {
            command = (ConverterCommand)this.getCommandService().executeCommand((ICommand)command);
        }
        catch (CommandException e) {
            log.error((Object)Messages.ItNetworkConverterWizard_Error, (Throwable)e);
        }
    }

    public IWizardPage getStartingPage() {
        return this.itNetworkPage;
    }

    private ICommandService getCommandService() {
        if (this.commandService == null) {
            this.commandService = (ICommandService)VeriniceContext.get((String)"commandService");
        }
        return this.commandService;
    }
}

