/*
 * Decompiled with CFR 0.152.
 */
package sernet.verinice.bp.rcp.converter;

import org.apache.log4j.Logger;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import sernet.verinice.bp.rcp.converter.ItNetworkConverterWizard;
import sernet.verinice.bp.rcp.converter.Messages;
import sernet.verinice.model.bsi.ITVerbund;
import sernet.verinice.model.common.CnATreeElement;
import sernet.verinice.rcp.NonModalWizardDialog;
import sernet.verinice.rcp.RightsEnabledActionDelegate;

public class ItNetworkConverterActionDelegate
extends RightsEnabledActionDelegate
implements IWorkbenchWindowActionDelegate {
    private static final Logger log = Logger.getLogger(ItNetworkConverterActionDelegate.class);
    private CnATreeElement selectedItNetwork;
    private Shell shell;

    @Override
    public void doRun(IAction action) {
        try {
            TitleAreaDialog wizardDialog = this.openWizard();
            if (wizardDialog.open() == 0) {
                MessageDialog.openInformation((Shell)this.getShell(), (String)Messages.ItNetworkConverterActionDelegate_DialogTitle, (String)Messages.ItNetworkConverterActionDelegate_ConvertingFinished);
            }
        }
        catch (Exception e) {
            MessageDialog.openError((Shell)this.getShell(), (String)Messages.ItNetworkConverterActionDelegate_DialogTitle, (String)Messages.ItNetworkConverterActionDelegate_Error);
        }
    }

    public String getRightID() {
        return "convertitnetwork";
    }

    public void init(IWorkbenchWindow window) {
        try {
            this.shell = window.getShell();
        }
        catch (Exception t) {
            log.error((Object)"Error creating ItNetworkConverterActionDelegate", (Throwable)t);
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        if (selection instanceof ITreeSelection) {
            this.selectedItNetwork = null;
            ITreeSelection selectionCurrent = (ITreeSelection)selection;
            for (Object selectedObject : selectionCurrent) {
                if (!this.isItNetwork(selectedObject)) continue;
                this.selectedItNetwork = (CnATreeElement)selectedObject;
            }
        }
    }

    private boolean isItNetwork(Object element) {
        return element instanceof ITVerbund;
    }

    private Shell getShell() {
        return this.shell;
    }

    private TitleAreaDialog openWizard() {
        ItNetworkConverterWizard wizard = new ItNetworkConverterWizard(this.selectedItNetwork);
        return new NonModalWizardDialog(this.getShell(), (IWizard)wizard);
    }
}

