/*
 * Decompiled with CFR 0.152.
 */
package sernet.verinice.bp.rcp.converter;

import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import sernet.gs.ui.rcp.main.ImageCache;
import sernet.gs.ui.rcp.main.actions.RightsEnabledAction;
import sernet.gs.ui.rcp.main.common.model.CnAElementFactory;
import sernet.gs.ui.rcp.main.common.model.DefaultModelLoadListener;
import sernet.verinice.bp.rcp.converter.ItNetworkConverterWizard;
import sernet.verinice.bp.rcp.converter.Messages;
import sernet.verinice.model.bp.elements.BpModel;
import sernet.verinice.model.bsi.BSIModel;
import sernet.verinice.model.bsi.ITVerbund;
import sernet.verinice.model.common.CnATreeElement;
import sernet.verinice.rcp.NonModalWizardDialog;

public class ItNetworkConverterAction
extends RightsEnabledAction
implements ISelectionListener {
    public static final String ID = "sernet.verinice.bp.rcp.converter.itnetworkconverteraction";
    private CnATreeElement selectedItNetwork;

    public ItNetworkConverterAction(IWorkbenchWindow window) {
        super("convertitnetwork", Messages.ItNetworkConverterAction_ActionTitle);
        this.setId(ID);
        this.setImageDescriptor(ImageCache.getInstance().getImageDescriptor("convert.png"));
        this.addLoadListener();
        window.getSelectionService().addSelectionListener((ISelectionListener)this);
    }

    @Override
    public void doRun() {
        try {
            TitleAreaDialog wizardDialog = this.openWizard();
            if (wizardDialog.open() == 0) {
                MessageDialog.openInformation((Shell)this.getShell(), (String)Messages.ItNetworkConverterAction_DialogTitle, (String)Messages.ItNetworkConverterAction_ConvertingFinished);
            }
        }
        catch (Exception e) {
            MessageDialog.openError((Shell)this.getShell(), (String)Messages.ItNetworkConverterAction_DialogTitle, (String)Messages.ItNetworkConverterAction_Error);
        }
    }

    private TitleAreaDialog openWizard() {
        ItNetworkConverterWizard wizard = new ItNetworkConverterWizard(this.selectedItNetwork);
        return new NonModalWizardDialog(this.getShell(), (IWizard)wizard);
    }

    private void addLoadListener() {
        CnAElementFactory.getInstance().addLoadListener(new DefaultModelLoadListener(){

            @Override
            public void closed(BSIModel model) {
                ItNetworkConverterAction.this.setEnabled(false);
            }

            @Override
            public void loaded(BpModel model) {
                ItNetworkConverterAction.this.setEnabled(ItNetworkConverterAction.this.checkRights());
            }
        });
    }

    public void selectionChanged(IWorkbenchPart arg0, ISelection selection) {
        if (selection instanceof ITreeSelection) {
            this.selectedItNetwork = null;
            ITreeSelection selectionCurrent = (ITreeSelection)selection;
            for (Object selectedObject : selectionCurrent) {
                if (!this.isItNetwork(selectedObject)) continue;
                this.selectedItNetwork = (CnATreeElement)selectedObject;
            }
        }
    }

    private boolean isItNetwork(Object element) {
        return element instanceof ITVerbund;
    }

    private Shell getShell() {
        return Display.getCurrent().getActiveShell();
    }
}

