/*
 * Decompiled with CFR 0.152.
 */
package sernet.verinice.bp.rcp.consolidator;

import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.beans.typed.PojoProperties;
import org.eclipse.core.databinding.observable.IObservable;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.map.IObservableMap;
import org.eclipse.core.databinding.observable.masterdetail.IObservableFactory;
import org.eclipse.core.databinding.observable.set.IObservableSet;
import org.eclipse.core.databinding.observable.set.WritableSet;
import org.eclipse.core.databinding.property.Properties;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jface.databinding.viewers.IViewerObservableSet;
import org.eclipse.jface.databinding.viewers.ObservableListTreeContentProvider;
import org.eclipse.jface.databinding.viewers.ObservableMapLabelProvider;
import org.eclipse.jface.databinding.viewers.typed.ViewerProperties;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IFontProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import sernet.gs.service.RuntimeCommandException;
import sernet.gs.ui.rcp.main.Activator;
import sernet.gs.ui.rcp.main.service.ServiceFactory;
import sernet.hui.swt.SWTResourceManager;
import sernet.verinice.bp.rcp.consolidator.ConsolidatorTableContent;
import sernet.verinice.bp.rcp.consolidator.ConsolidatorWizard;
import sernet.verinice.bp.rcp.consolidator.Messages;
import sernet.verinice.interfaces.CommandException;
import sernet.verinice.interfaces.ICommand;
import sernet.verinice.service.commands.bp.ConsolidatorCheckPermissionsCommand;

public class ModuleSelectionPage
extends WizardPage {
    private List<ConsolidatorTableContent> allModules;
    private CheckboxTreeViewer treeViewer;
    private ConsolidatorWizard wizard;
    private Map<Integer, ConsolidatorCheckPermissionsCommand.PermissionDeniedReason> moduleIDsWithWritePermissionIssues = Collections.emptyMap();

    public ModuleSelectionPage(ConsolidatorWizard consolidatorWizard, @NonNull List<ConsolidatorTableContent> allModules) {
        super("wizardPage");
        this.wizard = consolidatorWizard;
        this.setPageComplete(false);
        this.allModules = allModules;
        this.setTitle(Messages.selectModules);
        this.setDescription(Messages.selectTheModulesToBeConsolidated);
        WritableSet<ConsolidatorTableContent> selectedModules = this.wizard.getSelectedModules();
        selectedModules.addChangeListener(event -> {
            this.setPageComplete(!selectedModules.isEmpty());
            this.setMessage(null, 2);
            if (!this.moduleIDsWithWritePermissionIssues.isEmpty()) {
                HashSet moduleIDs = new HashSet(selectedModules.stream().map(it -> it.getModule().getDbId()).collect(Collectors.toSet()));
                moduleIDs.retainAll(this.moduleIDsWithWritePermissionIssues.keySet());
                if (!moduleIDs.isEmpty()) {
                    this.setMessage(Messages.nonWritableModulesWarning, 2);
                }
            }
        });
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        this.setControl((Control)container);
        container.setLayout((Layout)new GridLayout(1, false));
        this.treeViewer = new CheckboxTreeViewer(container, 2048);
        Tree tree = this.treeViewer.getTree();
        tree.setHeaderVisible(true);
        tree.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        TreeViewerColumn tableViewerColumn = new TreeViewerColumn((TreeViewer)this.treeViewer, 0);
        TreeColumn tblclmnNewColumn = tableViewerColumn.getColumn();
        tblclmnNewColumn.setWidth(160);
        tblclmnNewColumn.setText(Messages.title);
        tblclmnNewColumn.setData(Comparator.comparing(ConsolidatorTableContent::getTitle));
        TreeViewerColumn tableViewerColumn1 = new TreeViewerColumn((TreeViewer)this.treeViewer, 0);
        TreeColumn tblclmnNewColumn1 = tableViewerColumn1.getColumn();
        tblclmnNewColumn1.setWidth(200);
        tblclmnNewColumn1.setText(Messages.scope);
        tblclmnNewColumn1.setData(Comparator.comparing(ConsolidatorTableContent::getScope));
        TreeViewerColumn tableViewerColumn2 = new TreeViewerColumn((TreeViewer)this.treeViewer, 0);
        TreeColumn tblclmnNewColumn2 = tableViewerColumn2.getColumn();
        tblclmnNewColumn2.setWidth(100);
        tblclmnNewColumn2.setText(Messages.parent);
        tblclmnNewColumn2.setData(Comparator.comparing(ConsolidatorTableContent::getParent));
        this.initDataBindings(new DataBindingContext());
        this.treeViewer.setComparator(new ViewerComparator(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                Comparator<Object> comparator;
                Tree tree = ((CheckboxTreeViewer)viewer).getTree();
                TreeColumn sortColumn = tree.getSortColumn();
                Comparator<Object> comparator2 = comparator = sortColumn == null ? null : (Comparator<Object>)sortColumn.getData();
                if (comparator != null && tree.getSortDirection() == 128) {
                    comparator = comparator.reversed();
                }
                return comparator == null ? 0 : comparator.compare(e1, e2);
            }
        });
        TreeColumn[] columns = tree.getColumns();
        int i = 0;
        while (i < columns.length) {
            TreeColumn column = columns[i];
            column.addListener(13, e -> {
                TreeColumn sortColumn = tree.getSortColumn();
                int direction = tree.getSortDirection();
                if (column.equals(sortColumn)) {
                    direction = direction == 128 ? 1024 : 128;
                } else {
                    tree.setSortColumn(column);
                    direction = 1024;
                }
                tree.setSortDirection(direction);
                this.treeViewer.refresh();
            });
            ++i;
        }
        tree.setSortColumn(columns[0]);
        tree.setSortDirection(1024);
        if (this.allModules.isEmpty()) {
            this.setErrorMessage(Messages.noMatchingModules);
        } else if (!Activator.getDefault().isStandalone()) {
            Set moduleIDs = this.allModules.stream().map(it -> it.getModule().getDbId()).collect(Collectors.toSet());
            ConsolidatorCheckPermissionsCommand checkPermissionsCommand = new ConsolidatorCheckPermissionsCommand(moduleIDs, true, true, true, true);
            try {
                checkPermissionsCommand = (ConsolidatorCheckPermissionsCommand)ServiceFactory.lookupCommandService().executeCommand((ICommand)checkPermissionsCommand);
                this.moduleIDsWithWritePermissionIssues = checkPermissionsCommand.getPermissionIssues();
                this.treeViewer.refresh(true);
            }
            catch (CommandException e2) {
                throw new RuntimeCommandException("Error checking write permissions", (Throwable)e2);
            }
        }
    }

    protected void initDataBindings(DataBindingContext bindingContext) {
        IObservableFactory factory = target -> {
            if (target instanceof IObservable) {
                return (IObservable)target;
            }
            return null;
        };
        ObservableListTreeContentProvider contentProvider = new ObservableListTreeContentProvider(factory, null);
        this.treeViewer.setContentProvider((IContentProvider)contentProvider);
        IObservableMap<ConsolidatorTableContent, Object>[] observeMaps = ModuleSelectionPage.observeMaps(contentProvider.getKnownElements(), ConsolidatorTableContent.class, new String[]{"title", "scope", "parent"});
        this.treeViewer.setLabelProvider((IBaseLabelProvider)new ModuleSelectionLabelProvider(observeMaps));
        IObservableList selfList = Properties.selfList(ConsolidatorTableContent.class).observe(this.allModules.stream().map(x -> x).collect(Collectors.toList()));
        this.treeViewer.setInput((Object)selfList);
        IViewerObservableSet checkboxTreeViewerObserveCheckedElements = ViewerProperties.checkedElements(ConsolidatorTableContent.class).observe((Viewer)this.treeViewer);
        bindingContext.bindSet((IObservableSet)checkboxTreeViewerObserveCheckedElements, this.wizard.getSelectedModules(), null, null);
    }

    private static <E> IObservableMap<E, Object>[] observeMaps(IObservableSet<E> domain, Class<E> type, String[] propertyNames) {
        IObservableMap[] result = new IObservableMap[propertyNames.length];
        int i = 0;
        while (i < propertyNames.length) {
            result[i] = PojoProperties.value(type, (String)propertyNames[i]).observeDetail(domain);
            ++i;
        }
        return result;
    }

    private class ModuleSelectionLabelProvider
    extends ObservableMapLabelProvider
    implements IColorProvider,
    IFontProvider {
        private final Font italicFont;

        public ModuleSelectionLabelProvider(IObservableMap<ConsolidatorTableContent, Object>[] observeMaps) {
            super(observeMaps);
            Font defaultFont = JFaceResources.getDefaultFont();
            FontData fontData = defaultFont.getFontData()[0];
            this.italicFont = SWTResourceManager.getFont((String)fontData.getName(), (int)fontData.getHeight(), (int)2);
        }

        public Color getForeground(Object element) {
            ConsolidatorTableContent c = (ConsolidatorTableContent)element;
            if (ModuleSelectionPage.this.moduleIDsWithWritePermissionIssues.containsKey(c.getModule().getDbId())) {
                return SWTResourceManager.getColor((int)16);
            }
            return null;
        }

        public Color getBackground(Object element) {
            return null;
        }

        public Font getFont(Object element) {
            ConsolidatorTableContent c = (ConsolidatorTableContent)element;
            if (ModuleSelectionPage.this.moduleIDsWithWritePermissionIssues.containsKey(c.getModule().getDbId())) {
                return this.italicFont;
            }
            return null;
        }
    }
}

