/*
 * Decompiled with CFR 0.152.
 */
package sernet.verinice.bp.rcp.consolidator;

import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.core.databinding.observable.set.WritableSet;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import sernet.gs.service.RuntimeCommandException;
import sernet.gs.ui.rcp.main.Activator;
import sernet.gs.ui.rcp.main.service.ServiceFactory;
import sernet.verinice.bp.rcp.consolidator.ConsolidatorTableContent;
import sernet.verinice.bp.rcp.consolidator.ConsolidatorWizard;
import sernet.verinice.bp.rcp.consolidator.Messages;
import sernet.verinice.interfaces.CommandException;
import sernet.verinice.interfaces.ICommand;
import sernet.verinice.service.commands.bp.ConsolidatorCheckPermissionsCommand;

public class DataSelectionPage
extends WizardPage {
    private static final String PROP_GRP_BP_REQUIREMENT_GROUP_GENERAL = "bp_requirement_group_general";
    private static final String PROP_GRP_BP_REQUIREMENT_GENERAL = "bp_requirement_general";
    private static final String PROP_GRP_BP_SAFEGUARD_GENERAL = "bp_safeguard_general";
    private static final String PROP_GRP_BP_THREAT_GENERAL = "bp_threat_general";
    ConsolidatorWizard wizard;
    Composite composite;
    OptionListener selectionListener = new OptionListener();

    public DataSelectionPage(@NonNull ConsolidatorWizard wizard) {
        super("wizardPage");
        this.setTitle(Messages.dataSelection);
        this.setDescription(Messages.selectTheDataToBeConsolidated);
        this.wizard = wizard;
        if (!Activator.getDefault().isStandalone()) {
            this.setPageComplete(false);
            wizard.getSelectedModules().addChangeListener(event -> {
                this.checkPermissions();
                this.getContainer().updateButtons();
            });
        }
    }

    private Group createGroup(String title) {
        Group g = new Group(this.composite, 0);
        g.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        g.setText(title);
        g.setLayout((Layout)new GridLayout(1, false));
        return g;
    }

    private void createCheckbox(Group group, String title, String propertyId, boolean selected) {
        Button b = new Button((Composite)group, 32);
        b.addSelectionListener((SelectionListener)this.selectionListener);
        b.setText(title);
        b.setData((Object)propertyId);
        if (selected) {
            b.setSelection(true);
            this.wizard.getSelectedPropertyGroups().add(propertyId);
        }
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        this.setControl((Control)container);
        container.setLayout((Layout)new GridLayout(1, false));
        ScrolledComposite scrolledComposite = new ScrolledComposite(container, 768);
        scrolledComposite.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        scrolledComposite.setExpandHorizontal(true);
        scrolledComposite.setExpandVertical(true);
        this.composite = new Composite((Composite)scrolledComposite, 0);
        this.composite.setLayout((Layout)new GridLayout(1, false));
        Group moduleGrp = this.createGroup(Messages.module);
        this.createCheckbox(moduleGrp, Messages.general, PROP_GRP_BP_REQUIREMENT_GROUP_GENERAL, true);
        Group requirementGrp = this.createGroup(Messages.requirement);
        this.createCheckbox(requirementGrp, Messages.general, PROP_GRP_BP_REQUIREMENT_GENERAL, true);
        this.createCheckbox(requirementGrp, Messages.implementation, "bp_requirement_implementation", true);
        this.createCheckbox(requirementGrp, Messages.costs, "bp_requirement_group_kosten", false);
        this.createCheckbox(requirementGrp, Messages.dataProtection, "bp_requirement_data_protection_objectives_eugdpr", false);
        this.createCheckbox(requirementGrp, Messages.kix, "bp_requirement_kix", false);
        this.createCheckbox(requirementGrp, Messages.audit, "bp_requirement_audit", false);
        this.createCheckbox(requirementGrp, Messages.revision, "bp_requirement_revision", false);
        Group threatGrp = this.createGroup(Messages.threat);
        this.createCheckbox(threatGrp, Messages.general, PROP_GRP_BP_THREAT_GENERAL, true);
        this.createCheckbox(threatGrp, Messages.riskWithout, "bp_threat_risk_without_safeguards", false);
        this.createCheckbox(threatGrp, Messages.riskWithoudAdditional, "bp_threat_risk_without_additional_safeguards", true);
        this.createCheckbox(threatGrp, Messages.riskTreatment, "bp_threat_risk_treatment_option_group", true);
        this.createCheckbox(threatGrp, Messages.riskWithAdditional, "bp_threat_risk_with_additional_safeguards", true);
        Group safeguardGrp = this.createGroup(Messages.safeguard);
        this.createCheckbox(safeguardGrp, Messages.general, PROP_GRP_BP_SAFEGUARD_GENERAL, true);
        this.createCheckbox(safeguardGrp, Messages.implementation, "bp_safeguard_implementation", true);
        this.createCheckbox(safeguardGrp, Messages.costs, "bp_safeguard_group_kosten", false);
        this.createCheckbox(safeguardGrp, Messages.dataProtection, "bp_safeguard_data_protection_objectives_eugdpr", false);
        this.createCheckbox(safeguardGrp, Messages.kix, "bp_safeguard_kix", false);
        this.createCheckbox(safeguardGrp, Messages.revision, "bp_safeguard_revision", false);
        scrolledComposite.setContent((Control)this.composite);
        scrolledComposite.setMinSize(this.composite.computeSize(-1, -1));
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.checkPermissions();
        }
    }

    private void checkPermissions() {
        block6: {
            if (!Activator.getDefault().isStandalone()) {
                this.setErrorMessage(null);
                WritableSet<ConsolidatorTableContent> selectedModules = this.wizard.getSelectedModules();
                Set moduleIDs = selectedModules.stream().map(it -> it.getModule().getDbId()).collect(Collectors.toSet());
                boolean needsWritePermissionOnModule = this.wizard.getSelectedPropertyGroups().stream().anyMatch(it -> it.startsWith("bp_requirement_group"));
                boolean needsWritePermissionOnRequirements = this.wizard.getSelectedPropertyGroups().stream().anyMatch(it -> it.startsWith("bp_requirement") && !it.startsWith("bp_requirement_group"));
                boolean needsWritePermissionOnSafeguards = this.wizard.getSelectedPropertyGroups().stream().anyMatch(it -> it.startsWith("bp_safeguard"));
                boolean needsWritePermissionOnThreats = this.wizard.getSelectedPropertyGroups().stream().anyMatch(it -> it.startsWith("bp_threat"));
                ConsolidatorCheckPermissionsCommand checkPermissionsCommand = new ConsolidatorCheckPermissionsCommand(moduleIDs, needsWritePermissionOnModule, needsWritePermissionOnRequirements, needsWritePermissionOnSafeguards, needsWritePermissionOnThreats);
                try {
                    checkPermissionsCommand = (ConsolidatorCheckPermissionsCommand)ServiceFactory.lookupCommandService().executeCommand((ICommand)checkPermissionsCommand);
                    Map permissionIssues = checkPermissionsCommand.getPermissionIssues();
                    boolean issuesFound = !permissionIssues.isEmpty();
                    this.setPageComplete(!issuesFound);
                    if (!issuesFound) break block6;
                    Set reasons = permissionIssues.values().stream().collect(Collectors.toSet());
                    if (reasons.contains(ConsolidatorCheckPermissionsCommand.PermissionDeniedReason.MODULE)) {
                        this.setErrorMessage(Messages.DataSelectionPage_PermissionError_Modules);
                        break block6;
                    }
                    if (reasons.contains(ConsolidatorCheckPermissionsCommand.PermissionDeniedReason.REQUIREMENTS)) {
                        this.setErrorMessage(Messages.DataSelectionPage_PermissionError_Requirements);
                        break block6;
                    }
                    if (reasons.contains(ConsolidatorCheckPermissionsCommand.PermissionDeniedReason.LINKED_OBJECTS)) {
                        this.setErrorMessage(Messages.DataSelectionPage_PermissionError_LinkedObjects);
                        break block6;
                    }
                    throw new IllegalStateException("Unhandled reasons: " + reasons);
                }
                catch (CommandException ex) {
                    throw new RuntimeCommandException("Error checking write permissions", (Throwable)ex);
                }
            }
        }
    }

    private final class OptionListener
    extends SelectionAdapter {
        private OptionListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            Button b = (Button)e.getSource();
            String option = (String)b.getData();
            if (b.getSelection()) {
                DataSelectionPage.this.wizard.getSelectedPropertyGroups().add(option);
            } else {
                DataSelectionPage.this.wizard.getSelectedPropertyGroups().remove(option);
            }
            DataSelectionPage.this.checkPermissions();
        }
    }
}

