/*
 * Decompiled with CFR 0.152.
 */
package sernet.verinice.bp.rcp.consolidator;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.log4j.Logger;
import org.eclipse.core.databinding.observable.set.WritableSet;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.MessageBox;
import sernet.gs.ui.rcp.main.common.model.CnATreeElementScopeUtils;
import sernet.gs.ui.rcp.main.service.ServiceFactory;
import sernet.verinice.bp.rcp.consolidator.Consolidator;
import sernet.verinice.bp.rcp.consolidator.ConsolidatorTableContent;
import sernet.verinice.bp.rcp.consolidator.DataSelectionPage;
import sernet.verinice.bp.rcp.consolidator.Messages;
import sernet.verinice.bp.rcp.consolidator.ModuleSelectionPage;
import sernet.verinice.interfaces.ICommand;
import sernet.verinice.interfaces.graph.VeriniceGraph;
import sernet.verinice.model.bp.elements.ItNetwork;
import sernet.verinice.model.bp.groups.BpRequirementGroup;
import sernet.verinice.model.common.CnATreeElement;
import sernet.verinice.service.commands.bp.ConsoliData;
import sernet.verinice.service.commands.crud.LoadModulesWithParentsAndScope;

public class ConsolidatorWizard
extends Wizard {
    private static final Logger logger = Logger.getLogger(ConsolidatorWizard.class);
    @NonNull Collection<Map.Entry<BpRequirementGroup, ItNetwork>> potentialTargeRequirementGroupsAndScopes = Collections.emptySet();
    final @NonNull BpRequirementGroup sourceModule;
    private @NonNull WritableSet<@NonNull ConsolidatorTableContent> selectedModules = WritableSet.withElementType(ConsolidatorTableContent.class);
    private @NonNull Set<String> selectedPropertyGroups = new HashSet<String>();

    public ConsolidatorWizard(@NonNull BpRequirementGroup sourceModule) {
        String title = Messages.consolidator;
        if (!sourceModule.getIdentifier().isEmpty()) {
            title = String.valueOf(title) + " [" + sourceModule.getIdentifier() + "]";
        }
        this.setWindowTitle(title);
        this.sourceModule = sourceModule;
    }

    private @NonNull Collection<Map.Entry<BpRequirementGroup, ItNetwork>> findOtherModules(@NonNull BpRequirementGroup module, boolean includeAllScopes) {
        LoadModulesWithParentsAndScope compoundLoader = includeAllScopes ? new LoadModulesWithParentsAndScope() : new LoadModulesWithParentsAndScope(new Integer[]{module.getScopeId()});
        try {
            compoundLoader = (LoadModulesWithParentsAndScope)ServiceFactory.lookupCommandService().executeCommand((ICommand)compoundLoader);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage());
            return Collections.emptySet();
        }
        VeriniceGraph graph = compoundLoader.getGraph();
        Stream<BpRequirementGroup> s = graph.getElements(BpRequirementGroup.class).stream().filter(x -> x.getIdentifier().equals(module.getIdentifier())).filter(x -> !x.equals((Object)module)).filter(x -> !"catalog_model".equals(CnATreeElementScopeUtils.getScope((CnATreeElement)x).getParent().getTypeId()));
        if (!includeAllScopes) {
            s = s.filter(x -> x.getScopeId().equals(module.getScopeId()));
        }
        @NonNull HashMap<K, V> requirementGroupsToContainingScopes = new HashMap();
        s.forEach(r -> {
            ItNetwork scope = (ItNetwork)graph.getElement(r.getScopeId());
            requirementGroupsToContainingScopes.putIfAbsent(r, scope);
        });
        return requirementGroupsToContainingScopes.entrySet();
    }

    private boolean askIfShouldIncludeAllScopes() {
        MessageBox messageBox = new MessageBox(this.getShell(), 196);
        messageBox.setText(Messages.allScopesTitle);
        messageBox.setMessage(Messages.allScopes);
        return messageBox.open() == 64;
    }

    public void addPages() {
        this.potentialTargeRequirementGroupsAndScopes = this.findOtherModules(this.sourceModule, this.askIfShouldIncludeAllScopes());
        @NonNull List<@NonNull ConsolidatorTableContent> list = ConsolidatorTableContent.getContent(this.potentialTargeRequirementGroupsAndScopes);
        this.addPage((IWizardPage)new ModuleSelectionPage(this, list));
        this.addPage((IWizardPage)new DataSelectionPage(this));
    }

    public boolean performFinish() {
        MessageBox warning = new MessageBox(this.getShell(), 200);
        warning.setText(Messages.consolidate);
        warning.setMessage(Messages.consolidatorWarning);
        if (warning.open() == 64) {
            ConsoliData xdata = new ConsoliData(this.sourceModule, this.selectedPropertyGroups, this.selectedModules.stream().map(x -> x.getModule().getUuid()).collect(Collectors.toSet()));
            String consolidatorError = Consolidator.consolidate(xdata);
            if (consolidatorError != null) {
                MessageBox errorMessage = new MessageBox(this.getShell(), 33);
                errorMessage.setText(Messages.consolidatorFailed);
                errorMessage.setMessage(consolidatorError);
                errorMessage.open();
            } else {
                logger.debug((Object)"ConsolidatorWizard was successful.");
            }
        }
        return true;
    }

    @NonNull Set<String> getSelectedPropertyGroups() {
        return this.selectedPropertyGroups;
    }

    WritableSet<ConsolidatorTableContent> getSelectedModules() {
        return this.selectedModules;
    }
}

