/*
 * Decompiled with CFR 0.152.
 */
package sernet.verinice.bp.rcp.consolidator;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.jdt.annotation.NonNull;
import sernet.hui.common.connect.IAbbreviatedElement;
import sernet.verinice.model.bp.elements.ItNetwork;
import sernet.verinice.model.bp.groups.BpRequirementGroup;
import sernet.verinice.model.common.CnATreeElement;
import sernet.verinice.service.NonNullUtils;

public class ConsolidatorTableContent {
    private @NonNull String title;
    private @NonNull String scope;
    private @NonNull String parent;
    private @NonNull BpRequirementGroup module;

    public @NonNull BpRequirementGroup getModule() {
        return this.module;
    }

    public @NonNull String getTitle() {
        return this.title;
    }

    public @NonNull String getScope() {
        return this.scope;
    }

    public @NonNull String getParent() {
        return this.parent;
    }

    private ConsolidatorTableContent(@NonNull String title, @NonNull String scope, @NonNull String parent, @NonNull BpRequirementGroup module) {
        this.title = title;
        this.scope = scope;
        this.parent = parent;
        this.module = module;
    }

    static List<@NonNull ConsolidatorTableContent> getContent(@NonNull Collection<Map.Entry<BpRequirementGroup, ItNetwork>> requirementGroupsAndScopes) {
        return requirementGroupsAndScopes.stream().map(ConsolidatorTableContent::convert).collect(Collectors.toList());
    }

    protected static @NonNull ConsolidatorTableContent convert( @NonNull Map.Entry<BpRequirementGroup, ItNetwork> b) {
        BpRequirementGroup module = b.getKey();
        ItNetwork scope = b.getValue();
        CnATreeElement parent = module.getParent();
        return new ConsolidatorTableContent((String)NonNullUtils.toNonNull((Object)module.getTitle()), ConsolidatorTableContent.toTitle((CnATreeElement)scope), ConsolidatorTableContent.toTitle(parent), module);
    }

    private static @NonNull String toTitle(CnATreeElement element) {
        IAbbreviatedElement abb;
        if (element == null) {
            return "";
        }
        String prettyTitle = (String)NonNullUtils.toNonNull((Object)element.getTitle());
        if (element instanceof IAbbreviatedElement && !(abb = (IAbbreviatedElement)element).getAbbreviation().isEmpty()) {
            prettyTitle = String.valueOf(abb.getAbbreviation()) + " " + prettyTitle;
        }
        return prettyTitle;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.parent == null ? 0 : this.parent.hashCode());
        result = 31 * result + (this.module == null ? 0 : this.module.hashCode());
        result = 31 * result + (this.scope == null ? 0 : this.scope.hashCode());
        result = 31 * result + (this.title == null ? 0 : this.title.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ConsolidatorTableContent other = (ConsolidatorTableContent)obj;
        if (!this.parent.equals(other.parent)) {
            return false;
        }
        if (!this.module.equals((Object)other.module)) {
            return false;
        }
        if (!this.scope.equals(other.scope)) {
            return false;
        }
        return this.title.equals(other.title);
    }
}

