/*
 * Decompiled with CFR 0.152.
 */
package sernet.verinice.bp.rcp.consolidator;

import org.apache.log4j.Logger;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.ui.IViewSite;
import sernet.gs.ui.rcp.main.ImageCache;
import sernet.gs.ui.rcp.main.actions.ViewAndWindowAction;
import sernet.verinice.bp.rcp.Messages;
import sernet.verinice.bp.rcp.consolidator.ConsolidatorWizard;
import sernet.verinice.model.bp.groups.BpRequirementGroup;
import sernet.verinice.rcp.NonModalWizardDialog;

public class ConsolidatorAction
extends ViewAndWindowAction {
    private static final Logger logger = Logger.getLogger(ConsolidatorAction.class);
    BpRequirementGroup selectedModule;

    public ConsolidatorAction(IViewSite viewSite) {
        super("consolidator_modbp", Messages.BaseProtectionView_Consolidator);
        this.setImageDescriptor(ImageCache.getInstance().getImageDescriptor("konsolidator.png"));
        this.setSite(viewSite);
    }

    @Override
    protected void doRun(IStructuredSelection structuredSelection) {
        if (this.getShell() == null || this.selectedModule == null) {
            logger.error((Object)"The shell or the selected module was null.");
            return;
        }
        new NonModalWizardDialog(this.getShell(), (IWizard)new ConsolidatorWizard(this.selectedModule)).open();
    }

    @Override
    protected void selectionChanged(IStructuredSelection selection) {
        this.setEnabled(selection.size() == 1 && selection.getFirstElement() instanceof BpRequirementGroup);
        if (this.isEnabled()) {
            this.selectedModule = (BpRequirementGroup)selection.getFirstElement();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Selected module: " + this.selectedModule));
            }
        }
    }
}

