/*
 * Decompiled with CFR 0.152.
 */
package sernet.verinice.bp.rcp.bcm;

import java.util.Optional;
import java.util.Set;
import org.eclipse.jface.fieldassist.ControlDecoration;
import sernet.gs.service.RetrieveInfo;
import sernet.gs.service.Retriever;
import sernet.hui.common.connect.IEntityChangedListener;
import sernet.hui.common.connect.PropertyChangedEvent;
import sernet.hui.common.multiselectionlist.IMLPropertyOption;
import sernet.hui.common.multiselectionlist.IMLPropertyType;
import sernet.verinice.bp.rcp.bcm.Messages;
import sernet.verinice.model.bp.BCMUtils;
import sernet.verinice.model.common.CnATreeElement;

class ZeitkritischUIUpdater
implements IEntityChangedListener {
    private final CnATreeElement element;
    private final Set<String> relevantProperties;
    private final ControlDecoration decoration;

    ZeitkritischUIUpdater(CnATreeElement element, BCMUtils.BCMProperties bcmProperties, ControlDecoration decoration) {
        this.element = element;
        this.decoration = decoration;
        this.relevantProperties = Set.of(bcmProperties.propertyImpact24h, bcmProperties.propertyImpact3d, bcmProperties.propertyImpact7d, bcmProperties.propertyImpact14d, bcmProperties.propertyImpact30d, "bp_business_continuity_reporting_selectedzeitkritisch");
    }

    public void propertyChanged(PropertyChangedEvent event) {
        if (this.relevantProperties.contains(event.getProperty().getPropertyType())) {
            this.performUIUpdate();
        }
    }

    void performUIUpdate() {
        boolean deduceZeitkritisch = this.element.getEntity().isFlagged("bp_business_continuity_reporting_selectedzeitkritisch");
        if (deduceZeitkritisch) {
            CnATreeElement scope = Retriever.retrieveElement((Integer)this.element.getScopeId(), (RetrieveInfo)RetrieveInfo.getPropertyInstance());
            String damagePotentialValueRaw = Optional.ofNullable(scope).map(it -> it.getEntity().getRawPropertyValue("bp_itnetwork_value_untragbarkeitsniveau")).orElse(null);
            if (damagePotentialValueRaw == null || damagePotentialValueRaw.isEmpty() || damagePotentialValueRaw.equals(BCMUtils.DAMAGE_POTENTIAL_VALUE_UNEDITED_RAW)) {
                this.decoration.setDescriptionText(Messages.untragbarkeitsniveauMissing);
                this.decoration.show();
            } else {
                boolean valueFound = BCMUtils.updateProcessZeitkritisch((CnATreeElement)this.element, (String)damagePotentialValueRaw);
                if (!valueFound) {
                    this.decoration.setDescriptionText(Messages.damageAssessmentIncomplete);
                    this.decoration.show();
                } else {
                    this.decoration.hide();
                }
            }
        } else {
            this.decoration.hide();
        }
    }

    public void selectionChanged(IMLPropertyType type, IMLPropertyOption opt) {
    }
}

