/*
 * Decompiled with CFR 0.152.
 */
package sernet.verinice.bp.rcp.bcm;

import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.eclipse.jface.fieldassist.ContentProposal;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.jface.fieldassist.IContentProposal;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Control;
import sernet.gs.service.AbstractNumericStringComparator;
import sernet.gs.ui.rcp.main.Activator;
import sernet.hui.common.connect.HUITypeFactory;
import sernet.hui.common.connect.IEntityChangedListener;
import sernet.hui.common.connect.ITargetObject;
import sernet.hui.common.connect.PropertyType;
import sernet.hui.swt.widgets.HitroUIComposite;
import sernet.hui.swt.widgets.IInputHelper;
import sernet.verinice.bp.rcp.bcm.CalculateMinMtpd;
import sernet.verinice.bp.rcp.bcm.CalculateMtpd;
import sernet.verinice.bp.rcp.bcm.Messages;
import sernet.verinice.bp.rcp.bcm.ZeitkritischUIUpdater;
import sernet.verinice.model.bp.BCMUtils;
import sernet.verinice.model.bp.IBpElement;
import sernet.verinice.model.common.CnALink;
import sernet.verinice.model.common.CnATreeElement;
import sernet.verinice.model.common.CnATreeElementLabelGenerator;

public final class BCMUiUtils {
    private static final Logger LOG = Logger.getLogger(BCMUiUtils.class);
    private static final Comparator<IContentProposal> proposalComparator = new AbstractNumericStringComparator<IContentProposal>(){
        private static final long serialVersionUID = 4673848808543338310L;

        public String convertToString(IContentProposal o) {
            return o.getLabel();
        }
    };

    private BCMUiUtils() {
    }

    public static void addSelectionListener(HitroUIComposite huiComposite, CnATreeElement element) {
        if (element instanceof ITargetObject && element instanceof IBpElement && !element.isScope()) {
            BCMUtils.BCMProperties properties = BCMUtils.getPropertiesForElement((CnATreeElement)element);
            BCMUiUtils.enableMinMtpdDeduction(huiComposite, element, properties);
            PropertyType prop = HUITypeFactory.getInstance().getEntityType("bp_itnetwork").getPropertyType("bp_itnetwork_value_untragbarkeitsniveau");
            int numberOfDamagePotentialOptions = prop.getOptions().size();
            if (BCMUiUtils.checkIsCombo(huiComposite, properties.propertyImpact24h, numberOfDamagePotentialOptions) && BCMUiUtils.checkIsCombo(huiComposite, properties.propertyImpact3d, numberOfDamagePotentialOptions) && BCMUiUtils.checkIsCombo(huiComposite, properties.propertyImpact7d, numberOfDamagePotentialOptions) && BCMUiUtils.checkIsCombo(huiComposite, properties.propertyImpact14d, numberOfDamagePotentialOptions) && BCMUiUtils.checkIsCombo(huiComposite, properties.propertyImpact30d, numberOfDamagePotentialOptions) && BCMUiUtils.checkIsCombo(huiComposite, properties.propertyMtpd, 7)) {
                BCMUiUtils.enableMtpdDeduction(element, properties);
                if ("bp_businessprocess".equals(element.getTypeId()) && BCMUiUtils.checkIsCombo(huiComposite, "bp_businessprocess_reporting_zeitkritisch", 4)) {
                    Control zeitkritischControl = huiComposite.getField("bp_businessprocess_reporting_zeitkritisch");
                    BCMUiUtils.enableZeitkritischUiUpdater(element, properties, zeitkritischControl);
                }
            }
        }
    }

    private static void enableMtpdDeduction(CnATreeElement element, BCMUtils.BCMProperties properties) {
        CalculateMtpd listener = new CalculateMtpd(element, properties);
        element.getEntity().addChangeListener((IEntityChangedListener)listener);
    }

    private static void enableZeitkritischUiUpdater(CnATreeElement element, BCMUtils.BCMProperties properties, Control zeitkritischControl) {
        ControlDecoration txtDecorator = new ControlDecoration(zeitkritischControl, 16512);
        FieldDecoration fieldDecoration = FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_WARNING");
        Image img = fieldDecoration.getImage();
        txtDecorator.setImage(img);
        ZeitkritischUIUpdater listener = new ZeitkritischUIUpdater(element, properties, txtDecorator);
        element.getEntity().addChangeListener((IEntityChangedListener)listener);
        listener.performUIUpdate();
    }

    private static void enableMinMtpdDeduction(HitroUIComposite huiComposite, CnATreeElement element, BCMUtils.BCMProperties properties) {
        String targetProperty = properties.propertyMtpdMin;
        String sourceProperty = properties.propertyMtpd;
        String overrideProperty = properties.propertyMtpdOverride;
        Control sourceField = huiComposite.getField(sourceProperty);
        if (!(sourceField instanceof Combo)) {
            LOG.warn((Object)("Illegal field for " + sourceProperty + ", requiring a combo but found " + sourceField));
        } else {
            Combo sourceCombo = (Combo)sourceField;
            if (BCMUiUtils.checkIsCombo(huiComposite, targetProperty, sourceCombo.getItemCount()) && BCMUiUtils.checkIsCombo(huiComposite, overrideProperty, sourceCombo.getItemCount() + 1)) {
                CalculateMinMtpd listener = new CalculateMinMtpd(element, sourceProperty, overrideProperty);
                element.getEntity().addChangeListener((IEntityChangedListener)listener);
            }
        }
    }

    private static boolean checkIsCombo(HitroUIComposite huiComposite, String propertyName, int requiredItemCount) {
        Control field = huiComposite.getField(propertyName);
        if (field == null) {
            LOG.warn((Object)("Field for " + propertyName + " not found in editor"));
            return false;
        }
        if (!(field instanceof Combo)) {
            LOG.warn((Object)("Illegal field for " + propertyName + ", requiring a combo but found " + field));
            return false;
        }
        Combo combo = (Combo)field;
        int itemCount = combo.getItemCount();
        if (itemCount != requiredItemCount) {
            LOG.warn((Object)("Illegal number of items for " + propertyName + ", requiring " + requiredItemCount + "but found " + itemCount));
            return false;
        }
        return true;
    }

    public static void addControlHints(HitroUIComposite huiComposite, CnATreeElement element) {
        if (element instanceof ITargetObject && element instanceof IBpElement && !element.isScope()) {
            String typeId = element.getTypeId();
            String property = String.valueOf(typeId) + "__rto";
            Control control = huiComposite.getField(property);
            if (control == null) {
                LOG.warn((Object)("Field for " + property + " not found in editor"));
            } else {
                ControlDecoration txtDecorator = new ControlDecoration(control, 16512);
                FieldDecoration fieldDecoration = FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_INFORMATION");
                Image img = fieldDecoration.getImage();
                txtDecorator.setImage(img);
                txtDecorator.setDescriptionText(Messages.rtoMustBeSmallerThanMinMtpd);
            }
        }
    }

    public static void addInputHelper(HitroUIComposite huiComposite, CnATreeElement element) {
        IInputHelper minRtoHelper = () -> {
            Set linkedBusinessProcesses = element.getLinksUp().stream().filter(link -> link.getDependant().getTypeId().equals("bp_businessprocess")).map(CnALink::getDependant).collect(Collectors.toSet());
            HashSet<ContentProposal> proposals = new HashSet<ContentProposal>(linkedBusinessProcesses.size());
            for (CnATreeElement linkedBusinessProcess : linkedBusinessProcesses) {
                String rto = linkedBusinessProcess.getEntity().getRawPropertyValue("bp_businessprocess__rto");
                if (StringUtils.isBlank((String)rto)) continue;
                String title = CnATreeElementLabelGenerator.getElementTitle((CnATreeElement)linkedBusinessProcess);
                proposals.add(new ContentProposal(rto, String.valueOf(title) + ": " + rto, null));
            }
            return (IContentProposal[])proposals.stream().sorted(proposalComparator).toArray(IContentProposal[]::new);
        };
        boolean showHint = Activator.getDefault().getPluginPreferences().getBoolean("cna_inputhelperhints");
        Stream.of("bp_application", "bp_itsystem", "bp_icssystem", "bp_device", "bp_network", "bp_room").forEach(typeId -> {
            String propertyName = String.valueOf(typeId) + "__rtoK";
            huiComposite.setInputHelper(propertyName, minRtoHelper, 0, showHint);
        });
    }
}

