/*
 * Decompiled with CFR 0.152.
 */
package sernet.verinice.bp.rcp;

import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.IProgressService;
import sernet.gs.model.Baustein;
import sernet.gs.model.Gefaehrdung;
import sernet.gs.model.IGSModel;
import sernet.gs.model.Massnahme;
import sernet.gs.service.GSServiceException;
import sernet.gs.service.RuntimeCommandException;
import sernet.gs.ui.rcp.main.Activator;
import sernet.gs.ui.rcp.main.ExceptionUtil;
import sernet.gs.ui.rcp.main.bsi.dnd.transfer.IGSModelElementTransfer;
import sernet.gs.ui.rcp.main.bsi.dnd.transfer.VeriniceElementTransfer;
import sernet.gs.ui.rcp.main.bsi.views.HtmlWriter;
import sernet.gs.ui.rcp.main.common.model.CnAElementFactory;
import sernet.gs.ui.rcp.main.common.model.CnAElementHome;
import sernet.hui.common.VeriniceContext;
import sernet.springclient.RightsServiceClient;
import sernet.verinice.bp.rcp.Messages;
import sernet.verinice.interfaces.CommandException;
import sernet.verinice.interfaces.RightEnabledUserInteraction;
import sernet.verinice.iso27k.rcp.GS2BSITransformOperation;
import sernet.verinice.iso27k.rcp.action.DropPerformer;
import sernet.verinice.iso27k.service.GS2BSITransformService;
import sernet.verinice.iso27k.service.ItemTransformException;
import sernet.verinice.model.bp.elements.BpThreat;
import sernet.verinice.model.bp.elements.Safeguard;
import sernet.verinice.model.bp.groups.BpThreatGroup;
import sernet.verinice.model.bp.groups.SafeguardGroup;
import sernet.verinice.model.common.CnATreeElement;
import sernet.verinice.model.iso27k.Group;

public class GsCatalogModelingDropPerformer
implements DropPerformer,
RightEnabledUserInteraction {
    private static final Logger log = Logger.getLogger(GsCatalogModelingDropPerformer.class);
    private static final List<String> supportedDropTypeIds = new ArrayList<String>(2);
    private boolean isActive = false;
    private CnATreeElement targetElement = null;

    static {
        supportedDropTypeIds.add("bp_safeguard_group");
        supportedDropTypeIds.add("bp_threat_group");
    }

    @Override
    public boolean performDrop(Object data, Object target, Viewer viewer) {
        List<IGSModel> draggedModules = this.getDraggedElements(data);
        if (log.isDebugEnabled()) {
            this.logParameter(draggedModules, this.targetElement);
        }
        this.transformDroppedElements(draggedModules, this.targetElement, viewer);
        return true;
    }

    private void transformDroppedElements(List<IGSModel> draggedModules, CnATreeElement target, Viewer viewer) {
        if (!this.isActive()) {
            return;
        }
        TreeSelection oldSelection = (TreeSelection)viewer.getSelection();
        if (log.isDebugEnabled()) {
            log.debug((Object)"performDrop...");
        }
        Group group = (Group)target;
        if (!CnAElementHome.getInstance().isNewChildAllowed((CnATreeElement)group)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"User is not allowed to add elements to this group");
            }
            return;
        }
        try {
            GS2BSITransformOperation operation = new GS2BSITransformOperation(group, draggedModules, new GsItem2BpTransformer());
            IProgressService progressService = PlatformUI.getWorkbench().getProgressService();
            progressService.run(true, true, (IRunnableWithProgress)operation);
            String message = MessageFormat.format(Messages.GsCatalogModelingDropPerformer_finished_dialog_message, operation.getNumberProcessed(), ((Group)target).getTitle());
            IPreferenceStore preferenceStore = Activator.getDefault().getPreferenceStore();
            this.displayToggleDialog(message, Messages.GsCatalogModelingDropPerformer_finished_dialog_title, Messages.GsCatalogModelingDropPerformer_finished_dialog_toggle_message, preferenceStore, "info_controls_transformed_to_modernized_gs");
            if (!oldSelection.isEmpty()) {
                viewer.setSelection((ISelection)oldSelection);
            }
        }
        catch (ItemTransformException e) {
            log.error((Object)Messages.GsCatalogModelingDropPerformer_transform_error_message, (Throwable)e);
            this.showException(e);
        }
        catch (InvocationTargetException e) {
            log.error((Object)Messages.GsCatalogModelingDropPerformer_transform_error_message, (Throwable)e);
            Throwable t = e.getTargetException();
            if (t instanceof ItemTransformException) {
                this.showException((ItemTransformException)t);
            } else {
                ExceptionUtil.log(e, Messages.GsCatalogModelingDropPerformer_transform_error_message);
            }
        }
        catch (Exception e) {
            log.error((Object)Messages.GsCatalogModelingDropPerformer_transform_error_message, (Throwable)e);
            ExceptionUtil.log(e, Messages.GsCatalogModelingDropPerformer_transform_error_message);
        }
    }

    private void showException(ItemTransformException e) {
        String message = String.valueOf(Messages.GsCatalogModelingDropPerformer_exception_dialog_message) + e.getMessage();
        MessageDialog.openError((Shell)PlatformUI.getWorkbench().getDisplay().getActiveShell(), (String)Messages.GsCatalogModelingDropPerformer_exception_dialog_title, (String)message);
    }

    private void displayToggleDialog(String message, String title, String toggleMessage, IPreferenceStore preferenceStore, String preferenceConstant) {
        boolean dontShow = preferenceStore.getBoolean(preferenceConstant);
        if (!dontShow) {
            MessageDialogWithToggle dialog = MessageDialogWithToggle.openInformation((Shell)PlatformUI.getWorkbench().getDisplay().getActiveShell(), (String)title, (String)message, (String)toggleMessage, (boolean)dontShow, (IPreferenceStore)preferenceStore, (String)preferenceConstant);
            preferenceStore.setValue(preferenceConstant, dialog.getToggleState());
        }
    }

    private List<IGSModel> getDraggedElements(Object data) {
        List<IGSModel> elementList = Collections.emptyList();
        if (data instanceof Object[]) {
            Object[] objectData = (Object[])data;
            elementList = new ArrayList<IGSModel>(objectData.length);
            Object[] objectArray = objectData;
            int n = objectData.length;
            int n2 = 0;
            while (n2 < n) {
                Object o = objectArray[n2];
                if (o instanceof IGSModel) {
                    elementList.add((IGSModel)o);
                }
                ++n2;
            }
        }
        return elementList;
    }

    @Override
    public boolean validateDrop(Object rawTarget, int operation, TransferData transferData) {
        if (!this.checkRights()) {
            log.debug((Object)"CheckRights() failed, return false");
            return false;
        }
        if (!this.getTransfer().isSupportedType(transferData)) {
            log.debug((Object)"Unsupported type of TransferData");
            return false;
        }
        this.targetElement = this.getTargetElement(rawTarget);
        this.isActive = this.isTargetElement();
        return this.isActive;
    }

    @Override
    public boolean isActive() {
        return this.isActive;
    }

    public boolean checkRights() {
        Activator.inheritVeriniceContextState();
        RightsServiceClient service = (RightsServiceClient)VeriniceContext.get((String)"rightsService");
        return service.isEnabled(this.getRightID());
    }

    public String getRightID() {
        return "baseprotectionmodeling";
    }

    private CnATreeElement getTargetElement(Object target) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Target: " + target));
        }
        CnATreeElement element = null;
        if (target instanceof CnATreeElement && !supportedDropTypeIds.contains((element = (CnATreeElement)target).getTypeId())) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Unsupported type of target element: " + element.getTypeId()));
            }
            element = null;
        }
        return element;
    }

    protected boolean isTargetElement() {
        return this.targetElement != null;
    }

    protected VeriniceElementTransfer getTransfer() {
        return IGSModelElementTransfer.getInstance();
    }

    private void logParameter(List<IGSModel> draggedElements, CnATreeElement targetElementParam) {
        log.debug((Object)"Module(s):");
        for (IGSModel module : draggedElements) {
            log.debug((Object)module);
        }
        log.debug((Object)("is/are modeled with: " + targetElementParam + "..."));
    }

    private final class GsItem2BpTransformer
    implements GS2BSITransformService.ItemTransformer {
        private GsItem2BpTransformer() {
        }

        @Override
        public void transformElement(Group<?> group, Object item, List<CnATreeElement> elements) {
            if (item instanceof Baustein) {
                Baustein b = (Baustein)item;
                String title = String.valueOf(b.getId()) + " " + b.getTitel();
                if (group instanceof BpThreatGroup) {
                    Group<?> saveGroup = this.createGroup(group, title, BpThreatGroup.class, "bp_threat_group");
                    for (Gefaehrdung g : b.getGefaehrdungen()) {
                        this.transformGefaehrdung(saveGroup, elements, g);
                    }
                } else if (group instanceof SafeguardGroup) {
                    Group<?> saveGroup = this.createGroup(group, title, SafeguardGroup.class, "bp_safeguard_group");
                    for (Massnahme m : b.getMassnahmen()) {
                        this.transformMassnahme(saveGroup, elements, m);
                    }
                }
            } else if (item instanceof Massnahme) {
                Massnahme m = (Massnahme)item;
                this.transformMassnahme(group, elements, m);
            } else if (item instanceof Gefaehrdung) {
                Gefaehrdung g = (Gefaehrdung)item;
                this.transformGefaehrdung(group, elements, g);
            }
        }

        private Group<?> createGroup(Group<?> container, String title, Class<? extends Group<?>> elementClass, String typeId) {
            try {
                Group<?> saveNew = CnAElementHome.getInstance().save((CnATreeElement)container, elementClass, typeId);
                saveNew.setTitel(title);
                CnAElementHome.getInstance().updateEntity((CnATreeElement)saveNew);
                CnAElementFactory.getModel(container).childAdded(container, saveNew);
                return saveNew;
            }
            catch (CommandException e) {
                throw new RuntimeCommandException("Error while creating/saving Group: " + title, (Throwable)e);
            }
        }

        private void transformGefaehrdung(Group<?> group, List<CnATreeElement> elements, Gefaehrdung gefaehrdung) {
            BpThreat bpThreat = new BpThreat(group);
            bpThreat.setTitel(String.valueOf(gefaehrdung.getId()) + " " + gefaehrdung.getTitel());
            try {
                String description = HtmlWriter.getHtml(gefaehrdung);
                bpThreat.setObjectBrowserDescription(description);
            }
            catch (GSServiceException e) {
                log.error((Object)"Error setting description for safeguard", (Throwable)e);
            }
            elements.add((CnATreeElement)bpThreat);
        }

        private void transformMassnahme(Group<?> group, List<CnATreeElement> elements, Massnahme massnahme) {
            Safeguard safeguard = new Safeguard(group);
            safeguard.setIdentifier(massnahme.getId());
            safeguard.setTitle(massnahme.getTitel());
            try {
                String description = HtmlWriter.getHtml(massnahme);
                safeguard.setObjectBrowserDescription(description);
            }
            catch (GSServiceException e) {
                log.error((Object)"Error setting description for safeguard", (Throwable)e);
            }
            elements.add((CnATreeElement)safeguard);
        }
    }
}

